package com.kms.katalon.core.logging.model;

import java.util.Date;

public class TestStatus {

    public enum TestStatusValue {
        // Final statuses (happy case)
        PASSED,
        SKIPPED,
        // Final statuses (unhappy case)
        FAILED,
        INCOMPLETE,
        ERROR,
        // Informational statuses
        INFO,
        WARNING,
        // Not finished yet
        NOT_RUN;

        public boolean isError() {
            return this == ERROR || this == FAILED || this == INCOMPLETE;
        }

        // Determine if the status is final (aka cannot be changed to another status)
        // INFO, WARNING and NOT_RUN are non-final statuses
        public boolean isFinal() {
            return this == TestStatusValue.ERROR || this == TestStatusValue.FAILED || this == TestStatusValue.INCOMPLETE
                    || this == TestStatusValue.PASSED || this == TestStatusValue.SKIPPED;
        }
    }

    public TestStatus() {

    }

    public TestStatus(TestStatusValue value) {
        this.statusValue = value;
    }

    // Error Java stack Trace
    protected String stackTrace = "";

    // Default is PASSED
    protected TestStatusValue statusValue = TestStatusValue.PASSED;

    protected Date startTime;

    protected Date endTime;

    public String toString() {
        return "TestStatus{value=" + statusValue + '}';
    }

    public String getStackTrace() {
        return stackTrace;
    }

    public void setStackTrace(String stackTrace) {
        this.stackTrace = stackTrace;
    }

    public TestStatusValue getStatusValue() {
        return statusValue;
    }

    public void setStatusValue(TestStatusValue statusValue) {
        this.statusValue = statusValue;
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

}
