package com.kms.katalon.core.main;

import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;

public class ExecutionServiceContext {
    private static ExecutionServiceContext instance;

    public static ExecutionServiceContext getInstance() {
        if (instance == null) {
            instance = new ExecutionServiceContext();
        }
        return instance;
    }

    private ExecutionServiceContext() {
        // Hide the default constructor
    }

    private IEclipseContext applicationContext;

    private IEclipseContext getContext() {
        if (applicationContext == null) {
            applicationContext = EclipseContextFactory.create();
        }
        return applicationContext;
    }

    public <Type> Type registerService(Class<Type> serviceClass) {
        return registerService(serviceClass, serviceClass);
    }

    public <Type, ImplementationType extends Type> Type registerService(Class<Type> interfaceClass,
            Class<ImplementationType> implementationClass) {
        var instance = ContextInjectionFactory.make(implementationClass, getContext());
        registerService(interfaceClass, instance);
        return instance;
    }

    public <Type> void registerService(Class<Type> interfaceClass, Type instance) {
        getContext().set(interfaceClass, instance);
    }

    public void registerService(String name, Object value) {
        getContext().set(name, value);
    }

    public <Type> Type getService(Class<Type> serviceClass) {
        Type service = getContext().get(serviceClass);
        return service != null ? service : registerService(serviceClass);
    }

    public void injectDependencies(Object target) {
        if (applicationContext == null) {
            throw new IllegalStateException("DI context not initialized");
        }
        ContextInjectionFactory.inject(target, applicationContext);
    }
}
