package com.kms.katalon.core.model.internal;

import java.io.Serializable;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.kms.katalon.core.enums.mobile.LocatorStrategy;
import com.kms.katalon.core.selfhealing.SelfHealingInputSource;
import com.kms.katalon.util.collections.Pair;

/**
 * @apiNote **INTERNAL USE ONLY.** Do not use this class in client code.
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class MobilePlatformExecutionSettings implements Serializable {

    private static final long serialVersionUID = 1L;

    public MobilePlatformExecutionSettings() {
        super();
    }

    // Element timeout
    private int elementTimeoutInSeconds;

    // Action delay (per keyword)
    private int actionDelayInMillis;

    private List<String> actionDelayAffectedKeywords;
    
    private List<Pair<LocatorStrategy, Boolean>> prioritizedLocatorStrategiesForAndroid;

    private List<Pair<LocatorStrategy, Boolean>> prioritizedLocatorStrategiesForIos;

    // appium:newCommandTimeout
    private int newCommandTimeoutInSeconds;

    // Self-healing feature
    private boolean enableSelfHealing;

    private List<String> excludedKeywords;

    private boolean aiSelfHealingEnabled;

    private List<SelfHealingInputSource> aiSelfHealingInputSources;

    public int getElementTimeoutInSeconds() {
        return elementTimeoutInSeconds;
    }

    public void setElementTimeoutInSeconds(int elementTimeoutInSeconds) {
        this.elementTimeoutInSeconds = elementTimeoutInSeconds;
    }

    public int getActionDelayInMillis() {
        return actionDelayInMillis;
    }

    public void setActionDelayInMillis(int actionDelayInMillis) {
        this.actionDelayInMillis = actionDelayInMillis;
    }

    public List<String> getActionDelayAffectedKeywords() {
        return actionDelayAffectedKeywords;
    }

    public void setActionDelayAffectedKeywords(List<String> actionDelayAffectedKeywords) {
        this.actionDelayAffectedKeywords = actionDelayAffectedKeywords;
    }

    public int getNewCommandTimeoutInSeconds() {
        return newCommandTimeoutInSeconds;
    }

    public void setNewCommandTimeoutInSeconds(int newCommandTimeoutInSeconds) {
        this.newCommandTimeoutInSeconds = newCommandTimeoutInSeconds;
    }

    public boolean isEnableSelfHealing() {
        return enableSelfHealing;
    }

    public void setEnableSelfHealing(boolean enableSelfHealing) {
        this.enableSelfHealing = enableSelfHealing;
    }

    public boolean isAiSelfHealingEnabled() {
        return aiSelfHealingEnabled;
    }

    public void setAiSelfHealingEnabled(boolean aiSelfHealingEnabled) {
        this.aiSelfHealingEnabled = aiSelfHealingEnabled;
    }

    public List<SelfHealingInputSource> getAiSelfHealingInputSources() {
        return aiSelfHealingInputSources;
    }

    public void setAiSelfHealingInputSources(List<SelfHealingInputSource> aiSelfHealingInputSources) {
        this.aiSelfHealingInputSources = aiSelfHealingInputSources;
    }

    public List<String> getExcludedKeywords() {
        return excludedKeywords;
    }

    public void setExcludedKeywords(List<String> excludedKeywords) {
        this.excludedKeywords = excludedKeywords;
    }

    public List<Pair<LocatorStrategy, Boolean>> getPrioritizedLocatorStrategiesForAndroid() {
        return prioritizedLocatorStrategiesForAndroid;
    }

    public void setPrioritizedLocatorStrategiesForAndroid(List<Pair<LocatorStrategy, Boolean>> prioritizedLocatorStrategiesForAndroid) {
        this.prioritizedLocatorStrategiesForAndroid = prioritizedLocatorStrategiesForAndroid;
    }

    public List<Pair<LocatorStrategy, Boolean>> getPrioritizedLocatorStrategiesForIos() {
        return prioritizedLocatorStrategiesForIos;
    }

    public void setPrioritizedLocatorStrategiesForIos(List<Pair<LocatorStrategy, Boolean>> prioritizedLocatorStrategiesForIos) {
        this.prioritizedLocatorStrategiesForIos = prioritizedLocatorStrategiesForIos;
    }

    public static class Builder {

        private int elementTimeoutInSeconds;

        private int actionDelayInMillis;

        private List<String> actionDelayAffectedKeywords;

        private int newCommandTimeoutInSeconds;
        
        private List<Pair<LocatorStrategy, Boolean>> prioritizedLocatorStrategiesForAndroid;
        
        private List<Pair<LocatorStrategy, Boolean>> prioritizedLocatorStrategiesForIos;

        private boolean enableSelfHealing;

        private List<String> excludedKeywords;

        private boolean aiSelfHealingEnabled;

        private List<SelfHealingInputSource> aiSelfHealingInputSources;

        public Builder() {
        }

        public Builder elementTimeoutInSeconds(int elementTimeoutInSeconds) {
            this.elementTimeoutInSeconds = elementTimeoutInSeconds;
            return this;
        }

        public Builder actionDelayInMillis(int actionDelayInMillis) {
            this.actionDelayInMillis = actionDelayInMillis;
            return this;
        }

        public Builder actionDelayAffectedKeywords(List<String> actionDelayAffectedKeywords) {
            this.actionDelayAffectedKeywords = actionDelayAffectedKeywords;
            return this;
        }

        public Builder newCommandTimeoutInSeconds(int newCommandTimeoutInSeconds) {
            this.newCommandTimeoutInSeconds = newCommandTimeoutInSeconds;
            return this;
        }
        
        public Builder prioritizedLocatorStrategiesForAndroid(List<Pair<LocatorStrategy, Boolean>> prioritizedLocatorStrategiesForAndroid) {
            this.prioritizedLocatorStrategiesForAndroid = prioritizedLocatorStrategiesForAndroid;
            return this;
        }
        
        public Builder prioritizedLocatorStrategiesForIos(List<Pair<LocatorStrategy, Boolean>> prioritizedLocatorStrategiesForIos) {
            this.prioritizedLocatorStrategiesForIos = prioritizedLocatorStrategiesForIos;
            return this;
        }

        public Builder enableSelfHealing(boolean enableSelfHealing) {
            this.enableSelfHealing = enableSelfHealing;
            return this;
        }
        
        public Builder excludedKeywords(List<String> excludedKeywords) {
            this.excludedKeywords = excludedKeywords;
            return this;
        }

        public Builder setAiSelfHealingEnabled(boolean aiSelfHealingEnabled) {
            this.aiSelfHealingEnabled = aiSelfHealingEnabled;
            return this;
        }

        public Builder setAiSelfHealingInputSources(List<SelfHealingInputSource> aiSelfHealingInputSources) {
            this.aiSelfHealingInputSources = aiSelfHealingInputSources;
            return this;
        }

        public MobilePlatformExecutionSettings build() {
            MobilePlatformExecutionSettings executionSettings = new MobilePlatformExecutionSettings();
            executionSettings.setElementTimeoutInSeconds(elementTimeoutInSeconds);
            executionSettings.setActionDelayInMillis(actionDelayInMillis);
            executionSettings.setActionDelayAffectedKeywords(actionDelayAffectedKeywords);
            executionSettings.setNewCommandTimeoutInSeconds(newCommandTimeoutInSeconds);
            executionSettings.setPrioritizedLocatorStrategiesForAndroid(prioritizedLocatorStrategiesForAndroid);
            executionSettings.setPrioritizedLocatorStrategiesForIos(prioritizedLocatorStrategiesForIos);
            executionSettings.setEnableSelfHealing(enableSelfHealing);
            executionSettings.setExcludedKeywords(excludedKeywords);
            executionSettings.setAiSelfHealingEnabled(aiSelfHealingEnabled);
            executionSettings.setAiSelfHealingInputSources(aiSelfHealingInputSources);
            return executionSettings;
        }
    }
}
