package com.kms.katalon.core.model.internal;

import java.io.Serializable;
import java.util.List;

import com.kms.katalon.core.selfhealing.SelfHealingInputSource;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.kms.katalon.core.testobject.SelectorMethod;
import com.kms.katalon.util.collections.Pair;

/**
 * @apiNote **INTERNAL USE ONLY.** Do not use this class in client code.
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class WebUIPlatformExecutionSettings implements Serializable {

    private static final long serialVersionUID = 1L;
    
    public WebUIPlatformExecutionSettings() {
        super();
    }

    // Element timeout
    private int elementTimeoutInSeconds;

    // Self-healing feature
    private boolean enableSelfHealing;

    private List<String> excludeKeywords;

    private List<Pair<SelectorMethod, Boolean>> methodsPriorityOrder;

    private boolean aiSelfHealingEnabled;

    private List<SelfHealingInputSource> aiSelfHealingInputSources;

    public int getElementTimeoutInSeconds() {
        return elementTimeoutInSeconds;
    }

    public void setElementTimeoutInSeconds(int elementTimeoutInSeconds) {
        this.elementTimeoutInSeconds = elementTimeoutInSeconds;
    }

    public boolean isEnableSelfHealing() {
        return enableSelfHealing;
    }

    public void setEnableSelfHealing(boolean enableSelfHealing) {
        this.enableSelfHealing = enableSelfHealing;
    }

    public List<String> getExcludeKeywords() {
        return excludeKeywords;
    }

    public void setExcludeKeywords(List<String> excludeKeywords) {
        this.excludeKeywords = excludeKeywords;
    }

    public List<Pair<SelectorMethod, Boolean>> getMethodsPriorityOrder() {
        return this.methodsPriorityOrder;
    }

    public void setMethodsPriorityOrder(List<Pair<SelectorMethod, Boolean>> methodsPriorityOrder) {
        this.methodsPriorityOrder = methodsPriorityOrder;
    }

    public boolean isAiSelfHealingEnabled() {
        return aiSelfHealingEnabled;
    }

    public void setAiSelfHealingEnabled(boolean aiSelfHealingEnabled) {
        this.aiSelfHealingEnabled = aiSelfHealingEnabled;
    }

    public List<SelfHealingInputSource> getAiSelfHealingInputSources() {
        return aiSelfHealingInputSources;
    }

    public void setAiSelfHealingInputSources(List<SelfHealingInputSource> aiSelfHealingInputSources) {
        this.aiSelfHealingInputSources = aiSelfHealingInputSources;
    }

    public static class Builder {

        private int elementTimeoutInSeconds;

        private boolean enableSelfHealing;

        private List<String> excludeKeywords;

        private List<Pair<SelectorMethod, Boolean>> methodsPriorityOrder;

        private boolean aiSelfHealingEnabled;

        private List<SelfHealingInputSource> aiSelfHealingInputSources;

        public Builder() {
        }

        public Builder elementTimeoutInSeconds(int elementTimeoutInSeconds) {
            this.elementTimeoutInSeconds = elementTimeoutInSeconds;
            return this;
        }

        public Builder enableSelfHealing(boolean enableSelfHealing) {
            this.enableSelfHealing = enableSelfHealing;
            return this;
        }

        public Builder setExcludeKeywords(List<String> excludeKeywords) {
            this.excludeKeywords = excludeKeywords;
            return this;
        }

        public Builder setMethodsPriorityOrder(List<Pair<SelectorMethod, Boolean>> methodsPriorityOrder) {
            this.methodsPriorityOrder = methodsPriorityOrder;
            return this;
        }

        public Builder setAiSelfHealingEnabled(boolean aiSelfHealingEnabled) {
            this.aiSelfHealingEnabled = aiSelfHealingEnabled;
            return this;
        }

        public Builder setAiSelfHealingInputSources(List<SelfHealingInputSource> aiSelfHealingInputSources) {
            this.aiSelfHealingInputSources = aiSelfHealingInputSources;
            return this;
        }

        public WebUIPlatformExecutionSettings build() {
            WebUIPlatformExecutionSettings executionSettings = new WebUIPlatformExecutionSettings();
            executionSettings.setElementTimeoutInSeconds(elementTimeoutInSeconds);
            executionSettings.setEnableSelfHealing(enableSelfHealing);
            executionSettings.setExcludeKeywords(excludeKeywords);
            executionSettings.setMethodsPriorityOrder(methodsPriorityOrder);
            executionSettings.setAiSelfHealingEnabled(aiSelfHealingEnabled);
            executionSettings.setAiSelfHealingInputSources(aiSelfHealingInputSources);
            return executionSettings;
        }
    }
}
