package com.kms.katalon.core.testobject.authorization;

public enum OAuth1SignatureMethod {
    HMAC_SHA1("HMAC-SHA1"), RSA_SHA1("RSA-SHA1");

    private final String displayName;

    OAuth1SignatureMethod(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return displayName;
    }

    public static OAuth1SignatureMethod fromDisplayName(String displayName) {
        for (OAuth1SignatureMethod method : values()) {
            if (method.getDisplayName().equals(displayName)) {
                return method;
            }
        }
        
        try {
            return valueOf(displayName);
        } catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Unknown OAuth1 signature method: " + displayName);
        }
    }
}
