package com.kms.katalon.core.trace;

import java.util.HashMap;
import java.util.Map;

public final class SourceLocator {
    private SourceLocator() {
    }

    public static Map<String, Object> capture() {
        Map<String, Object> result = new HashMap<>();
        try {
            StackTraceElement[] stack = Thread.currentThread().getStackTrace();
            for (StackTraceElement frame : stack) {
                if (frame == null) {
                    continue;
                }
                String fileName = frame.getFileName();
                if (fileName == null || !fileName.endsWith(".groovy")) {
                    continue;
                }
                String className = frame.getClassName();
                if (className != null && className.contains("KeywordInterceptor")) {
                    continue;
                }
                result.put("file", fileName);
                result.put("line", frame.getLineNumber());
                result.put("column", 1);
                break;
            }
        } catch (Throwable ignored) {
            result.clear();
        }
        return result;
    }
}

