package com.kms.katalon.core.util;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

import com.kms.katalon.util.NameUtil;

import net.lightbody.bmp.core.har.HarContent;
import net.lightbody.bmp.core.har.HarEntry;
import net.lightbody.bmp.core.har.HarNameValuePair;
import net.lightbody.bmp.core.har.HarPostData;
import net.lightbody.bmp.core.har.HarPostDataParam;
import net.lightbody.bmp.core.har.HarRequest;
import net.lightbody.bmp.core.har.HarResponse;

public class KatalonHarEntry extends HarEntry {

    private RequestInformation _katalonRequestInformation; // HAR's naming convention for custom fields

    private Pattern secureValuesPattern;

    public KatalonHarEntry() {

    }

    public KatalonHarEntry(HarEntry harEntry, Pattern secureValuesPattern) {
        this();

        this.secureValuesPattern = secureValuesPattern;

        setPageref(harEntry.getPageref());
        setStartedDateTime(harEntry.getStartedDateTime());

        HarRequest request = harEntry.getRequest();
        if (request != null) {
            String url = request.getUrl();
            request.setUrl(maskValue(url));

            List<HarNameValuePair> headers = request.getHeaders();
            if (headers != null) {
                headers = headers.stream()
                        .map(header -> new HarNameValuePair(header.getName(), maskValue(header.getValue())))
                        .collect(Collectors.toList());
                request.getHeaders().clear();
                request.getHeaders().addAll(headers);
            }

            HarPostData postData = request.getPostData();
            if (postData != null) {
                List<HarPostDataParam> dataParams = postData.getParams();
                if (dataParams != null) {
                    postData.setParams(dataParams.stream().map(param -> {
                        param.setValue(maskValue(param.getValue()));
                        return param;
                    }).collect(Collectors.toList()));
                }

                postData.setText(maskValue(postData.getText()));
                postData.setComment(maskValue(postData.getComment()));
            }

            request.setComment(maskValue(request.getComment()));
            setRequest(request);
        }

        HarResponse response = harEntry.getResponse();
        if (response != null) {
            List<HarNameValuePair> headers = response.getHeaders();
            if (headers != null) {
                headers = headers.stream()
                        .map(header -> new HarNameValuePair(header.getName(), maskValue(header.getValue())))
                        .collect(Collectors.toList());
                response.getHeaders().clear();
                response.getHeaders().addAll(headers);
            }

            HarContent content = response.getContent();
            if (content != null) {
                content.setText(maskValue(content.getText()));
                content.setComment(maskValue(content.getComment()));
            }

            response.setRedirectURL(maskValue(response.getRedirectURL()));
            response.setComment(maskValue(response.getComment()));
            setResponse(response);
        }

        setCache(harEntry.getCache());
        setTimings(harEntry.getTimings());
        setServerIPAddress(harEntry.getServerIPAddress());
        setConnection(harEntry.getConnection());
        setComment(maskValue(harEntry.getComment()));
    }

    public RequestInformation get_katalonRequestInformation() {
        return _katalonRequestInformation;
    }

    public void set_katalonRequestInformation(RequestInformation _katalonRequestInformation) {
        this._katalonRequestInformation = _katalonRequestInformation;
    }

    public String maskValue(String message) {
        if (message == null || secureValuesPattern == null) {
            return message;
        }

        Matcher matcher = secureValuesPattern.matcher(message);
        return matcher.replaceAll(NameUtil.BULLET_MASK);
    }
}
