package com.kms.katalon.core.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.commons.lang3.StringUtils;

public class Strings {
    public interface StringProvider {
        public String call();
    }

    @SafeVarargs
    public static String firstNonBlank(StringProvider... stringProviders) {
        for (StringProvider stringProviderI : stringProviders) {
            if (stringProviderI == null) {
                continue;
            }
            String stringI = stringProviderI.call();
            if (StringUtils.isNotBlank(stringI)) {
                return stringI;
            }
        }
        return null;
    }

    @SafeVarargs
    public static <T extends CharSequence> T firstNonBlank(T... strings) {
        for (T stringI : strings) {
            if (StringUtils.isNotBlank(stringI)) {
                return stringI;
            }
        }
        return null;
    }

    @SafeVarargs
    public static <T extends CharSequence> boolean isAllNonBlank(T... strings) {
        return !StringUtils.isAnyBlank(strings);
    }

    public static String getQuotedString(String text) {
        return Pattern.quote(text);
    }

    public static String getContainsPattern(String aPartOfText) {
        return ".*" + getQuotedString(aPartOfText) + ".*";
    }

    public static String extractJSONContent(String content) {
        if (StringUtils.isBlank(content)) {
            return "";
        }
        Pattern pattern = Pattern.compile("```json\\n(.*?)\\n```", Pattern.CASE_INSENSITIVE | Pattern.DOTALL);
        Matcher matcher = pattern.matcher(content);
        if (matcher.find()) {
            return matcher.group(1).trim();
        }
        return content.trim();
    }
}
