package com.kms.katalon.core.util;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.kms.katalon.core.testobject.MobileTestObject;
import com.kms.katalon.core.testobject.TestObject;

public class TestObjectDeserializer extends JsonDeserializer<TestObject> {

    @Override
    public TestObject deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        ObjectCodec codec = p.getCodec();
        JsonNode node = codec.readTree(p);
        boolean isMobile = node.has("locatorStrategy") || node.has("locatorCollection") || node.has("platform");
        if (isMobile) {
            return codec.treeToValue(node, MobileTestObject.class);
        } else {
            return codec.treeToValue(node, TestObject.class);
        }
    }
}
