package com.kms.katalon.core.cucumber.keyword.internal;

/**
 * Enum to represent the type of Cucumber target being executed.
 * 
 */
public enum CucumberTargetType {
    /**
     * Represents execution of a single feature file
     */
    FEATURE_FILE("FeatureFile"),
    
    /**
     * Represents execution of a feature folder and its nested sub-folders
     */
    FEATURE_FOLDER("FeatureFolder");
    
    private final String displayName;
    
    CucumberTargetType(String displayName) {
        this.displayName = displayName;
    }
    
    /**
     * Gets the display name for logging purposes
     * 
     * @return the display name
     */
    public String getDisplayName() {
        return displayName;
    }
    
    /**
     * Checks if this target type is a folder
     * 
     * @return true if this is a folder target type, false otherwise
     */
    public boolean isFolder() {
        return this == FEATURE_FOLDER;
    }
}
