package com.kms.katalon.core.cucumber.plugin;

import com.kms.katalon.core.logging.KeywordLogger;

import io.cucumber.messages.types.*;
import io.cucumber.messages.types.Exception;

public class EnvelopMasker {

    private static KeywordLogger logger = KeywordLogger.getInstance(EnvelopMasker.class);

    private EnvelopMasker() {
    }

    public static Envelope mask(Envelope envelop) {
        if (envelop == null) {
            return null;
        }

        if (envelop.getGherkinDocument().isPresent()) {
            return Envelope.of(envelop.getGherkinDocument().map(EnvelopMasker::mask).orElse(null));
        }

        if (envelop.getParseError().isPresent()) {
            return Envelope.of(envelop.getParseError().map(EnvelopMasker::mask).orElse(null));
        }

        if (envelop.getPickle().isPresent()) {
            return Envelope.of(envelop.getPickle().map(EnvelopMasker::mask).orElse(null));
        }

        if (envelop.getTestCase().isPresent()) {
            return Envelope.of(envelop.getTestCase().map(EnvelopMasker::mask).orElse(null));
        }

        if (envelop.getTestRunFinished().isPresent()) {
            return Envelope.of(envelop.getTestRunFinished().map(EnvelopMasker::mask).orElse(null));
        }

        if (envelop.getTestStepFinished().isPresent()) {
            return Envelope.of(envelop.getTestStepFinished().map(EnvelopMasker::mask).orElse(null));
        }

        if (envelop.getTestRunHookFinished().isPresent()) {
            return Envelope.of(envelop.getTestRunHookFinished().map(EnvelopMasker::mask).orElse(null));
        }

        return envelop;
    }

    public static GherkinDocument mask(GherkinDocument doc) {
        if (doc == null) {
            return null;
        }

        return new GherkinDocument(
                doc.getUri().orElse(null),
                doc.getFeature().map(EnvelopMasker::mask).orElse(null),
                doc.getComments().stream().map(EnvelopMasker::mask).toList()
        );
    }

    public static Feature mask(Feature feature) {
        if (feature == null) {
            return null;
        }

        return new Feature(
                feature.getLocation(),
                feature.getTags(),
                feature.getLanguage(),
                feature.getKeyword(),
                mask(feature.getName()),
                mask(feature.getDescription()),
                feature.getChildren().stream().map(EnvelopMasker::mask).toList()
        );
    }

    public static FeatureChild mask(FeatureChild child) {
        if (child == null) {
            return null;
        }

        return new FeatureChild(
                mask(child.getRule().orElse(null)),
                mask(child.getBackground().orElse(null)),
                mask(child.getScenario().orElse(null))
        );
    }

    public static Rule mask(Rule rule) {
        if (rule == null) {
            return null;
        }

        return new Rule(
                rule.getLocation(),
                rule.getTags(),
                rule.getKeyword(),
                mask(rule.getName()),
                mask(rule.getDescription()),
                rule.getChildren().stream().map(EnvelopMasker::mask).toList(),
                rule.getId()
        );
    }

    public static RuleChild mask(RuleChild child) {
        if (child == null) {
            return null;
        }

        return new RuleChild(
                mask(child.getBackground().orElse(null)),
                mask(child.getScenario().orElse(null))
        );
    }

    public static Background mask(Background background) {
        if (background == null) {
            return null;
        }

        return new Background(
                background.getLocation(),
                background.getKeyword(),
                mask(background.getName()),
                mask(background.getDescription()),
                background.getSteps().stream().map(EnvelopMasker::mask).toList(),
                background.getId()
        );
    }

    public static Scenario mask(Scenario scenario) {
        if (scenario == null) {
            return null;
        }

        return new Scenario(
                scenario.getLocation(),
                scenario.getTags(),
                scenario.getKeyword(),
                mask(scenario.getName()),
                mask(scenario.getDescription()),
                scenario.getSteps().stream().map(EnvelopMasker::mask).toList(),
                scenario.getExamples().stream().map(EnvelopMasker::mask).toList(),
                scenario.getId()
        );
    }

    public static Step mask(Step step) {
        if (step == null) {
            return null;
        }

        return new Step(
                step.getLocation(),
                step.getKeyword(),
                step.getKeywordType().orElse(null),
                mask(step.getText()),
                step.getDocString().map(EnvelopMasker::mask).orElse(null),
                step.getDataTable().map(EnvelopMasker::mask).orElse(null),
                step.getId()
        );
    }

    public static Examples mask(Examples examples) {
        if (examples == null) {
            return null;
        }

        return new Examples(
                examples.getLocation(),
                examples.getTags(),
                examples.getKeyword(),
                mask(examples.getName()),
                mask(examples.getDescription()),
                mask(examples.getTableHeader().orElse(null)),
                examples.getTableBody().stream().map(EnvelopMasker::mask).toList(),
                examples.getId()
        );
    }

    public static DocString mask(DocString docString) {
        if (docString == null) {
            return null;
        }

        return new DocString(
                docString.getLocation(),
                docString.getMediaType().orElse(null),
                mask(docString.getContent()),
                docString.getDelimiter()
        );
    }

    public static DataTable mask(DataTable dataTable) {
        if (dataTable == null) {
            return null;
        }

        return new DataTable(
                dataTable.getLocation(),
                dataTable.getRows().stream().map(EnvelopMasker::mask).toList()
        );
    }

    public static TableRow mask(TableRow tableRow) {
        if (tableRow == null) {
            return null;
        }

        return new TableRow(
                tableRow.getLocation(),
                tableRow.getCells().stream().map(EnvelopMasker::mask).toList(),
                tableRow.getId()
        );
    }

    public static TableCell mask(TableCell tableCell) {
        if (tableCell == null) {
            return null;
        }

        return new TableCell(
                tableCell.getLocation(),
                mask(tableCell.getValue())
        );
    }

    public static Pickle mask(Pickle pickle) {
        if (pickle == null) {
            return null;
        }

        return new Pickle(
                pickle.getId(),
                pickle.getUri(),
                mask(pickle.getName()),
                pickle.getLanguage(),
                pickle.getSteps().stream().map(EnvelopMasker::mask).toList(),
                pickle.getTags(),
                pickle.getAstNodeIds()
        );
    }

    public static PickleStep mask(PickleStep pickleStep) {
        if (pickleStep == null) {
            return null;
        }

        return new PickleStep(
                mask(pickleStep.getArgument().orElse(null)),
                pickleStep.getAstNodeIds(),
                pickleStep.getId(),
                pickleStep.getType().orElse(null),
                mask(pickleStep.getText())
        );
    }

    public static PickleStepArgument mask(PickleStepArgument arg) {
        if (arg == null) {
            return null;
        }

        return new PickleStepArgument(
                mask(arg.getDocString().orElse(null)),
                mask(arg.getDataTable().orElse(null))
        );
    }

    public static PickleDocString mask(PickleDocString pickleDocString) {
        if (pickleDocString == null) {
            return null;
        }

        return new PickleDocString(
                pickleDocString.getMediaType().orElse(null),
                mask(pickleDocString.getContent())
        );
    }

    public static PickleTable mask(PickleTable pickleTable) {
        if (pickleTable == null) {
            return null;
        }

        return new PickleTable(
                pickleTable.getRows().stream().map(EnvelopMasker::mask).toList()
        );
    }

    public static PickleTableRow mask(PickleTableRow row) {
        if (row == null) {
            return null;
        }

        return new PickleTableRow(
                row.getCells().stream().map(EnvelopMasker::mask).toList()
        );
    }

    public static PickleTableCell mask(PickleTableCell cell) {
        if (cell == null) {
            return null;
        }

        return new PickleTableCell(
                mask(cell.getValue())
        );
    }

    public static TestCase mask(TestCase testCase) {
        if (testCase == null) {
            return null;
        }

        return new TestCase(
                testCase.getId(),
                testCase.getPickleId(),
                testCase.getTestSteps().stream().map(EnvelopMasker::mask).toList(),
                testCase.getTestRunStartedId().orElse(null)
        );
    }

    public static TestStep mask(TestStep testStep) {
        if (testStep == null) {
            return null;
        }

        return new TestStep(
                testStep.getHookId().orElse(null),
                testStep.getId(),
                testStep.getPickleStepId().orElse(null),
                testStep.getStepDefinitionIds().orElse(null),
                testStep.getStepMatchArgumentsLists().map(m -> m.stream().map(EnvelopMasker::mask).toList()).orElse(null)
        );
    }

    public static StepMatchArgumentsList mask(StepMatchArgumentsList argumentsList) {
        if (argumentsList == null) {
            return null;
        }

        return new StepMatchArgumentsList(
                argumentsList.getStepMatchArguments().stream().map(EnvelopMasker::mask).toList()
        );
    }

    public static StepMatchArgument mask(StepMatchArgument argument) {
        if (argument == null) {
            return null;
        }

        return new StepMatchArgument(
                mask(argument.getGroup()),
                argument.getParameterTypeName().orElse(null)
        );
    }

    public static Group mask(Group group) {
        if (group == null) {
            return null;
        }

        return new Group(
                group.getChildren().stream().map(EnvelopMasker::mask).toList(),
                group.getStart().orElse(null),
                mask(group.getValue().orElse(null))
        );
    }

    public static Comment mask(Comment comment) {
        if (comment == null) {
            return null;
        }

        return new Comment(
                comment.getLocation(),
                mask(comment.getText())
        );
    }

    public static TestRunFinished mask(TestRunFinished testRunFinished) {
        if (testRunFinished == null) {
            return null;
        }

        return new TestRunFinished(
                mask(testRunFinished.getMessage().orElse(null)),
                testRunFinished.getSuccess(),
                testRunFinished.getTimestamp(),
                mask(testRunFinished.getException().orElse(null)),
                testRunFinished.getTestRunStartedId().orElse(null)
        );
    }

    public static TestStepFinished mask(TestStepFinished testStepFinished) {
        if (testStepFinished == null) {
            return null;
        }

        return new TestStepFinished(
                testStepFinished.getTestCaseStartedId(),
                testStepFinished.getTestStepId(),
                mask(testStepFinished.getTestStepResult()),
                testStepFinished.getTimestamp()
        );
    }

    public static TestRunHookFinished mask(TestRunHookFinished testRunHookFinished) {
        if (testRunHookFinished == null) {
            return null;
        }

        return new TestRunHookFinished(
                testRunHookFinished.getTestRunHookStartedId(),
                mask(testRunHookFinished.getResult()),
                testRunHookFinished.getTimestamp()
        );
    }

    public static TestStepResult mask(TestStepResult result) {
        if (result == null) {
            return null;
        }

        return new TestStepResult(
                result.getDuration(),
                mask(result.getMessage().orElse(null)),
                result.getStatus(),
                mask(result.getException().orElse(null))
        );
    }

    public static Exception mask(Exception exception) {
        if (exception == null) {
            return null;
        }

        return new Exception(
                exception.getType(),
                mask(exception.getMessage().orElse(null)),
                exception.getStackTrace().orElse(null)
        );
    }

    public static ParseError mask(ParseError error) {
        if (error == null) {
            return null;
        }

        return new ParseError(
                error.getSource(),
                mask(error.getMessage())
        );
    }

    public static String mask(String value) {
        return logger.maskSecureValues(value);
    }
}
