package com.kms.katalon.core.mobile.keyword.builtin

import java.text.MessageFormat

import org.openqa.selenium.WebElement

import com.kms.katalon.core.annotation.internal.Action
import com.kms.katalon.core.configuration.RunConfiguration
import com.kms.katalon.core.exception.StepFailedException
import com.kms.katalon.core.helper.KeywordHelper
import com.kms.katalon.core.keyword.internal.SupportLevel
import com.kms.katalon.core.mobile.constants.StringConstants
import com.kms.katalon.core.mobile.helper.MobileCommonHelper
import com.kms.katalon.core.mobile.keyword.internal.MobileAbstractKeyword
import com.kms.katalon.core.mobile.keyword.internal.MobileKeywordMain
import com.kms.katalon.core.model.FailureHandling
import com.kms.katalon.core.testobject.TestObject

import groovy.transform.CompileStatic

@Action(value = "findElements")
public class FindElementsKeyword extends MobileAbstractKeyword {

    @CompileStatic
    @Override
    public SupportLevel getSupportLevel(Object ...params) {
        return super.getSupportLevel(params)
    }

    @CompileStatic
    @Override
    public Object execute(Object ...params) {
        TestObject to = getTestObject(params[0])
        int timeout = (int) params[1]
        FailureHandling flowControl = (FailureHandling)(params.length > 2 && params[2] instanceof FailureHandling ? params[2] : RunConfiguration.getDefaultFailureHandling())
        return findWebElements(to, timeout, flowControl)
    }

    @CompileStatic
    public Object findWebElements(TestObject to, int timeout, FailureHandling flowControl) throws StepFailedException {
        return (List<WebElement>) MobileKeywordMain.runKeyword({
            KeywordHelper.checkTestObjectParameter(to)
            timeout = MobileCommonHelper.checkTimeout(timeout)
            List<WebElement> webElements = MobileCommonHelper.findElements(getAnyAppiumDriver(), to, timeout);
            logger.logPassed(MessageFormat.format(StringConstants.KW_MSG_FOUND_WEB_ELEMENTS, to.getObjectId()))
            return webElements
        }, flowControl, RunConfiguration.getTakeScreenshotOption(), to != null ? MessageFormat.format(StringConstants.KW_MSG_CANNOT_FIND_WEB_ELEMENTS_X, to.getObjectId()) : StringConstants.KW_MSG_CANNOT_FIND_WEB_ELEMENTS)
    }
}
