package com.kms.katalon.core.mobile.keyword.builtin;

import java.text.MessageFormat;

import org.openqa.selenium.WebElement;

import com.kms.katalon.core.annotation.internal.Action
import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.core.exception.StepFailedException;
import com.kms.katalon.core.keyword.internal.SupportLevel;
import com.kms.katalon.core.mobile.constants.CoreMobileMessageConstants;
import com.kms.katalon.core.mobile.constants.StringConstants;
import com.kms.katalon.core.mobile.helper.AndroidHelper
import com.kms.katalon.core.mobile.helper.IOSHelper
import com.kms.katalon.core.mobile.keyword.internal.MobileAbstractKeyword
import com.kms.katalon.core.mobile.keyword.internal.MobileKeywordMain;
import com.kms.katalon.core.model.FailureHandling;
import com.kms.katalon.core.testobject.TestObject

import groovy.transform.CompileStatic;
import io.appium.java_client.AppiumDriver;
import io.appium.java_client.android.AndroidDriver;
import io.appium.java_client.ios.IOSDriver;

@Action(value = "scrollToTextHorizontal")
public class ScrollToTextHorizontalKeyword extends MobileAbstractKeyword {

    @CompileStatic
    @Override
    public SupportLevel getSupportLevel(Object ...params) {
        return super.getSupportLevel(params)
    }

    @CompileStatic
    @Override
    public Object execute(Object ...params) {
        TestObject testObject = (TestObject) params[0]
        String text = (String) params[1]
        int timeout = (int) params[2]
        FailureHandling flowControl = (FailureHandling)(params.length > 3 && params[3] instanceof FailureHandling ? params[3] : RunConfiguration.getDefaultFailureHandling())
        scrollToTextHorizontal(testObject, text, timeout, flowControl)
    }

    public void scrollToTextHorizontal(TestObject testObject, String text, int timeout, FailureHandling flowControl) throws StepFailedException {
        MobileKeywordMain.runKeyword({
            logger.logDebug(StringConstants.COMM_LOG_INFO_CHECKING_TEXT)
            if (text == null) {
                throw new IllegalArgumentException(StringConstants.COMM_EXC_TEXT_IS_NULL)
            }

            AppiumDriver driver = getAnyAppiumDriver()
            WebElement element = null

            if (driver instanceof AndroidDriver) {
                element = AndroidHelper.scrollToTextHorizontal(testObject, text, timeout);
            } else if (driver instanceof IOSDriver) {
                element = IOSHelper.scrollToTextHorizontal(testObject, text, timeout);
            }

            if (element != null) {
                logger.logPassed(MessageFormat.format(StringConstants.KW_LOG_PASSED_SCROLL_TO_TEXT_X, text))
            } else {
                MobileKeywordMain.stepFailed(MessageFormat.format(CoreMobileMessageConstants.KW_MSG_TEXT_NOT_FOUND, text), flowControl, null, true)
            }
        }, flowControl, RunConfiguration.getTakeScreenshotOption(), MessageFormat.format(StringConstants.KW_MSG_UNABLE_SCROLL_TO_TEXT_X, text))
    }
}
