package com.kms.katalon.core.mobile.keyword.builtin

import java.text.MessageFormat
import java.time.Duration

import org.openqa.selenium.Point

import com.kms.katalon.core.annotation.internal.Action
import com.kms.katalon.core.configuration.RunConfiguration
import com.kms.katalon.core.exception.StepFailedException
import com.kms.katalon.core.keyword.internal.SupportLevel
import com.kms.katalon.core.mobile.constants.StringConstants
import com.kms.katalon.core.mobile.helper.MobileCommonHelper
import com.kms.katalon.core.mobile.keyword.internal.MobileAbstractKeyword
import com.kms.katalon.core.mobile.keyword.internal.MobileKeywordMain
import com.kms.katalon.core.model.FailureHandling

import groovy.transform.CompileStatic
import io.appium.java_client.AppiumDriver

@Action(value = "swipeWithDuration")
public class SwipeWithDurationKeyword extends MobileAbstractKeyword {

    @CompileStatic
    @Override
    public SupportLevel getSupportLevel(Object ...params) {
        return super.getSupportLevel(params)
    }

    @CompileStatic
    @Override
    public Object execute(Object ...params) {
        int startX = (int) params[0]
        int startY = (int) params[1]
        int endX = (int) params[2]
        int endY = (int) params[3]
        long durationInMillis = (long) params[4]
        FailureHandling flowControl = (FailureHandling)(params.length > 5 && params[5] instanceof FailureHandling ? params[5] : RunConfiguration.getDefaultFailureHandling())
        swipeWithDuration(startX, startY, endX, endY, durationInMillis, flowControl)
    }

    @CompileStatic
    public void swipeWithDuration(int startX, int startY, int endX, int endY, long durationInMillis, FailureHandling flowControl) throws StepFailedException {
        MobileKeywordMain.runKeyword({
            AppiumDriver driver = getAnyAppiumDriver()
            MobileCommonHelper.swipe(driver, new Point(startX, startY), new Point(endX, endY), Duration.ofMillis(durationInMillis));
            logger.logPassed(MessageFormat.format(StringConstants.KW_LOG_PASSED_SWIPED_FROM_STARTXY_TO_ENDXY, startX, startY, endX, endY))
        }, flowControl, RunConfiguration.getTakeScreenshotOption(), StringConstants.KW_MSG_CANNOT_SWIPE_ON_DEVICE)
    }
}
