package com.kms.katalon.core.mobile.keyword.builtin

import java.text.MessageFormat

import com.kms.katalon.core.annotation.internal.Action
import com.kms.katalon.core.configuration.RunConfiguration
import com.kms.katalon.core.exception.StepFailedException
import com.kms.katalon.core.keyword.internal.SupportLevel
import com.kms.katalon.core.mobile.constants.StringConstants
import com.kms.katalon.core.mobile.keyword.internal.MobileAbstractKeyword
import com.kms.katalon.core.mobile.keyword.internal.MobileKeywordMain
import com.kms.katalon.core.model.FailureHandling

import groovy.transform.CompileStatic
import io.appium.java_client.AppiumDriver
import io.appium.java_client.remote.SupportsContextSwitching

@Action(value = "switchToContext")
public class SwitchToContext extends MobileAbstractKeyword {

    @CompileStatic
    @Override
    public SupportLevel getSupportLevel(Object ...params) {
        return super.getSupportLevel(params)
    }

    @CompileStatic
    @Override
    public Object execute(Object ...params) {
        String context = params[0];
        FailureHandling flowControl = (FailureHandling)(params.length > 1 && params[1] instanceof FailureHandling ? params[1] : RunConfiguration.getDefaultFailureHandling())
        switchToContext(context, flowControl)
    }

    @CompileStatic
    public void switchToContext(String context, FailureHandling flowControl) throws StepFailedException {
        MobileKeywordMain.runKeyword({
            AppiumDriver driver = getAnyAppiumDriver()
            Set<String> contexts = ((SupportsContextSwitching) driver).getContextHandles();
            if (contexts.contains(context)) {
                ((SupportsContextSwitching) driver).context(context);
                logger.logPassed(MessageFormat.format(StringConstants.KW_LOG_PASSED_SWITCH_CONTEXT, context));
            } else {
                MobileKeywordMain.stepFailed(MessageFormat.format(StringConstants.KW_MSG_THE_CONTEXT_NOT_FOUND, context), flowControl, null, true)
            }
        }, flowControl, RunConfiguration.getTakeScreenshotOption(), MessageFormat.format(StringConstants.KW_MSG_UNABLE_SWITCH_CONTEXT, context))
    }
}
