package com.kms.katalon.core.webui.common.controller;

import org.openqa.selenium.JavascriptExecutor;

public class WaitForStablePhase extends ElementWaitingPhase {

    public WaitForStablePhase(JavascriptExecutor webDriver) {
        super(webDriver);
    }

    @Override
    protected String getWaitingScript() {
        return super.getWaitingScript() + """
                //// Should not leverage function checkElementStates in playwright because the function requestAnimationFrame won't work if browser is not focused
                function waitForAnimationEnd(element) {
                    return Promise.all(element.getAnimations({ subtree: true })
                        .filter(animation => {
                            const effect = animation.effect;
                          return window.getComputedStyle(effect.target, effect.pseudoElement)['animation-iteration-count'] !== 'infinite';
                        })
                        .map(animation => animation.finished));
                }

                // Trigger animation if any
                element.scrollIntoView({ behavior: 'smooth', block: 'center', inline: 'center' });

                waitForAnimationEnd(element).then((waited) => {
                    notifyWaitingResult({ result: waited
                        ? ElementWaitingInteractableState.DONE
                        : ElementWaitingInteractableState.TIMED_OUT });
                }).catch(notifyWaitingError);
                """;
    }
}
