package com.kms.katalon.core.webui.constants;

public class ElementWaitingScript {

    public static final String ADD_DOM_OBSERVER_SCRIPT = """
            async function waitWithDOMMutation(validator, timeout) {
                return new Promise((resolve, reject) => {
                    try {
                        if (timeout <= 0) {
                            resolve(false);
                            return;
                        }

                        if (validator()) {
                            resolve(true);
                            return;
                        }

                        const observer = new MutationObserver((mutations) => {
                            if (validator()) {
                                observer.disconnect();
                                resolve(true);
                            }
                        });

                        observer.observe(document.body, { childList: true, attributes: true, subtree: true });

                        setTimeout(() => {
                            resolve(false);
                            observer.disconnect();
                        }, timeout);
                    } catch (error) {
                        reject(error);
                    }
                });
            }
            """;
}
