package com.kms.katalon.core.webui.driver;

import java.net.MalformedURLException;

import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.RemoteWebDriver;

import com.kms.katalon.core.webui.driver.smart.SmartDriverUtil;
import com.kms.katalon.core.webui.util.WebDriverUtil;
import com.kms.katalon.selenium.driver.CRemoteWebDriver;

public class ExistingSessionDriverBuilder extends BaseDriverBuilder {
    private String remoteServerUrl;

    private String sessionId;

    private String webSocketUrl;

    public ExistingSessionDriverBuilder remoteServerUrl(String remoteServerUrl) {
        this.remoteServerUrl = remoteServerUrl;
        return this;
    }

    public ExistingSessionDriverBuilder sessionId(String sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    public ExistingSessionDriverBuilder webSocketUrl(String webSocketUrl) {
        this.webSocketUrl = webSocketUrl;
        return this;
    }

    @Override
    public WebDriver build() throws MalformedURLException {
        CommandExecutor executor = WebDriverUtil.createCommandExecutorWithRunningSession(remoteServerUrl, sessionId,
                webSocketUrl);
        WebDriver driver;
        if (StringUtils.isNotBlank(webSocketUrl)) {
            driver = new CRemoteWebDriver(executor, new MutableCapabilities(),
                    driverConfigProvider.getActionDelayInMilisecond());
            driver = injectSmartExtensions(driver);
        } else {
            driver = new RemoteWebDriver(executor, new MutableCapabilities());
        }

        return SmartDriverUtil.createSmartDriver(driver);
    }
}
