package com.kms.katalon.core.webui.driver.chrome;

import java.io.File;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.remote.AbstractDriverOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.kms.katalon.core.util.ConsoleCommandExecutor;
import com.kms.katalon.core.webui.common.internal.SeleniumBrowserInfo;
import com.kms.katalon.core.webui.driver.DriverFactory;
import com.kms.katalon.core.webui.driver.chromium.ChromiumDriverBuilder;
import com.kms.katalon.core.webui.util.OSUtil;
import com.kms.katalon.core.webui.util.WebDriverPropertyUtil;
import com.kms.katalon.selenium.driver.CChromeDriver;

public class ChromeDriverBuilder extends ChromiumDriverBuilder {
    
    private static final Logger logger = LoggerFactory.getLogger(ChromeDriverBuilder.class);
    
    private boolean useChromeForTesting = false;
    
    public ChromeDriverBuilder useChromeForTesting(boolean value) {
        this.useChromeForTesting = value;
        return this;
    }

    @Override
    protected AbstractDriverOptions<?> createOptions(Capabilities capabilities) {
        return WebDriverPropertyUtil.generateDefaultChromeOptions().merge(capabilities);
    }

    @Override
    protected WebDriver createDriver(AbstractDriverOptions<?> options) {
        if (!(options instanceof ChromeOptions chromeOptions)) {
            return null;
        }

        Object extraCapability = chromeOptions.getCapability(ChromeOptions.CAPABILITY);
        
        if (null != extraCapability && extraCapability instanceof Map mapData && null != mapData.get(WebDriverPropertyUtil.CHROME_BINARY_PROPERTY_KEY)) {
            logger.info("Use user's configured Chrome binary option: %s".formatted(mapData.get(WebDriverPropertyUtil.CHROME_BINARY_PROPERTY_KEY)));
            
            // keep as it is
            System.setProperty(DriverFactory.CHROME_DRIVER_PATH_PROPERTY_KEY, ChromeDriverUtil.getChromeDriverPath());
        } else {
            if (this.useChromeForTesting) {
                setupDriverForCFT(chromeOptions);
            } else {
                setupDriverForChome(chromeOptions);
            }
        }

        System.setProperty(DriverFactory.CHROME_DRIVER_PATH_PROPERTY_KEY, ChromeDriverUtil.getChromeDriverPath());
        return new CChromeDriver(chromeOptions, driverConfigProvider.getActionDelayInMilisecond());
    }

    private void setupDriverForChome(ChromeOptions chromeOptions) {
        if (OSUtil.isMac()) {
            String chromeBinary = "/Applications/Google Chrome.app/Contents/MacOS/Google Chrome";
            File chromeBinaryFilePath = new File(chromeBinary);
            if (chromeBinaryFilePath.exists()) {
                chromeOptions.setBinary(chromeBinary);
            }
        } else if (OSUtil.isWindows()) {
            // Do nothing
        } else {
            String chromeBinary = ConsoleCommandExecutor.safeWhere("google-chrome");
            if (StringUtils.isEmpty(WebDriverPropertyUtil.BROWSER_STARTUP_HOMEPAGE_PREFERENCE)) {
                chromeBinary = "/usr/bin/google-chrome";
            }
            File chromeBinaryFilePath = new File(chromeBinary);
            if (chromeBinaryFilePath.exists()) {
                chromeOptions.setBinary(chromeBinary);
            }
        }
    }

    private void setupDriverForCFT(final ChromeOptions chromeOptions) {
        logger.info("Use managed Chrome browser & driver");
        String browserVersion = chromeOptions.getBrowserVersion();
        SeleniumBrowserInfo browserInfo = ChromeDriverUtil.getSeleniumBrowserInfo(browserVersion);
        
        logger.info("Chrome driver path: %s".formatted(browserInfo.getDriverPath()));
        logger.info("Chrome browser path: %s".formatted(browserInfo.getBrowserPath()));
        
        System.setProperty(DriverFactory.CHROME_DRIVER_PATH_PROPERTY_KEY, browserInfo.getDriverPath());
        chromeOptions.setBinary(browserInfo.getBrowserPath());
    }
}
