package com.kms.katalon.core.webui.driver.remote;

import com.kms.katalon.core.webui.driver.AbstractDriverBuilder;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.net.NetworkUtils;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;

public abstract class AbstractRemoteDriverBuilder extends AbstractDriverBuilder {

    private static final int REMOTE_BROWSER_CONNECT_TIMEOUT = 60000;

    protected static void waitForRemoteBrowserReady(URL url) throws Exception {
        long timeoutAt = System.currentTimeMillis() + REMOTE_BROWSER_CONNECT_TIMEOUT;
        boolean connectable = false;

        while (!connectable) {
            try {
                url.openConnection().connect();
                connectable = true;
            } catch (IOException e) {
                // cannot connect yet
            }

            if (timeoutAt < System.currentTimeMillis()) {
                var messageFormat = "Unable to connect to browser on host %s and port %s after %s seconds.";
                var message = String.format(messageFormat, url.getHost(), url.getPort(), REMOTE_BROWSER_CONNECT_TIMEOUT);
                throw new Exception(message);
            }

            try {
                Thread.sleep(100);
            } catch (InterruptedException ignored) {}
        }
    }

    protected static int determineNextFreePort(int port) {
        int newport;
        var networkUtils = new NetworkUtils();
        for (newport = port; newport < port + 2000; newport++) {
            var address = new InetSocketAddress(networkUtils.obtainLoopbackIp4Address(), newport);
            Socket socket = null;

            try {
                socket = new Socket();
                socket.bind(address);
                return newport;
            } catch (IOException e) {
                // Port is already bound. Skip it and continue
            } finally {
                if (socket != null) {
                    try {
                        socket.close();
                    } catch (IOException e) {
                        // Ignore this error
                    }
                }
            }
        }

        throw new WebDriverException(String.format("Cannot find free port in the range %d to %d ", port, newport));
    }
}
