package com.kms.katalon.core.webui.keyword.builtin

import com.kms.katalon.core.annotation.internal.Action
import com.kms.katalon.core.keyword.internal.SupportLevel
import com.kms.katalon.core.webui.keyword.internal.WebUIAbstractKeyword
import com.kms.katalon.core.trace.TraceHolder

import groovy.transform.CompileStatic

/**
 * Adds a user-defined marker step into the Playwright trace (debug landmark).
 */
@Action(value = "addTraceMarker")
class AddTraceMarkerKeyword extends WebUIAbstractKeyword {

    @Override
    SupportLevel getSupportLevel(Object... params) {
        return SupportLevel.BUITIN
    }

    @Override
    Object execute(Object... params) {
        String title = params.length > 0 ? String.valueOf(params[0]) : 'Marker'
        String detail = params.length > 1 ? String.valueOf(params[1]) : ''
        addTraceMarker(title, detail)
        return null
    }

    void addTraceMarker(String title, String detail) {
        def session = TraceHolder.getSession()
        if (session == null || !(session?.recording)) return
        String label = title ?: 'Marker'
        Map params = [:]
        if (detail) params.detail = detail
        Map meta = [category: 'Marker', apiName: 'WebUI.addTraceMarker']
        String callId = session?.invokeMethod('beginStep', [label, params, meta, null] as Object[])
        session?.invokeMethod('endStep', [callId, 'ok', null, meta] as Object[])
    }
}
