package com.kms.katalon.core.webui.keyword.builtin

import java.text.MessageFormat

import org.apache.commons.lang3.StringUtils

import com.kms.katalon.core.annotation.internal.Action
import com.kms.katalon.core.configuration.RunConfiguration
import com.kms.katalon.core.driver.IDriverType
import com.kms.katalon.core.keyword.internal.SupportLevel
import com.kms.katalon.core.logging.KeywordLogger
import com.kms.katalon.core.model.FailureHandling
import com.kms.katalon.core.model.TakeScreenshotOption
import com.kms.katalon.core.util.internal.PathUtil
import com.kms.katalon.core.webui.authentication.basic.BasicAuthenticationStrategy
import com.kms.katalon.core.webui.authentication.basic.BasicAuthenticationStrategyFactory
import com.kms.katalon.core.webui.constants.StringConstants
import com.kms.katalon.core.webui.driver.DriverFactory
import com.kms.katalon.core.webui.driver.WebUIDriverType
import com.kms.katalon.core.webui.keyword.internal.WebUIAbstractKeyword
import com.kms.katalon.core.webui.keyword.internal.WebUIKeywordMain
import com.kms.katalon.core.webui.util.WebDriverUtil

import groovy.transform.CompileStatic

@Action(value = "authenticate")
public class AuthenticateKeyword extends WebUIAbstractKeyword {
    List<WebUIDriverType> supportedDrivers = new ArrayList<WebUIDriverType>(Arrays.asList(
            WebUIDriverType.CHROME_DRIVER, WebUIDriverType.FIREFOX_DRIVER, WebUIDriverType.EDGE_CHROMIUM_DRIVER,
            WebUIDriverType.TESTCLOUD_DRIVER, WebUIDriverType.REMOTE_WEB_DRIVER));
        
    List<String> supportedBrowsers = List.of("chrome", "firefox", "edge");

    @CompileStatic
    @Override
    public SupportLevel getSupportLevel(Object ...params) {
        return super.getSupportLevel(params)
    }

    @CompileStatic
    @Override
    public Object execute(Object ...params) {
        String url = (String) params[0]
        String userName = (String) params[1]
        String password = (String) params[2]
        int timeout = (int) params[3]
        FailureHandling flowControl = (FailureHandling)(params.length > 4 && params[4] instanceof FailureHandling ? params[4] : RunConfiguration.getDefaultFailureHandling())
        authenticate(url,userName,password,timeout,flowControl)
    }

    @CompileStatic
    public void authenticate(final String url, String userName, String password, int timeout,
            FailureHandling flowControl) {

        WebUIKeywordMain.runKeyword({
            throwErrorIfNotEligibleToExecute(userName, password)
            
            BasicAuthenticationStrategyFactory basicAuthStrategyFactory = new BasicAuthenticationStrategyFactory()
            BasicAuthenticationStrategy strategy = basicAuthStrategyFactory.getBasicAuthenticationStrategy()
            boolean authenticateSuccess = strategy.navigate(
                PathUtil.getUrl(url, "https"),
                userName,
                password,
                timeout
            )

            if (authenticateSuccess) {
                logger.logPassed(MessageFormat.format(StringConstants.KW_LOG_PASSED_NAVIAGTED_TO_AUTHENTICATED_PAGE, [userName, password] as Object[]))
            } else {
                WebUIKeywordMain.stepFailedWithReason(StringConstants.KW_MSG_CANNOT_NAV_TO_AUTHENTICATED_PAGE, flowControl, "", false)
            }
        }, flowControl, TakeScreenshotOption.NONE, StringConstants.KW_MSG_CANNOT_NAV_TO_AUTHENTICATED_PAGE)
    }

    @CompileStatic
    private String getUnsupportedBrowserMessage() {
        String template = "Unsupported browser (only support %s)";
        String browsers = "";
        //Unsupported browser (only support Chrome, Firefox, and Edge Chromium)
        for(int i = 0 ; i < supportedDrivers.size() ; i++) {
            if(i == supportedDrivers.size()-1) {
                browsers += "and "+supportedDrivers[i].toString();
            } else {
                browsers += supportedDrivers[i].toString()+", ";
            }
        }
        return String.format(template, browsers);
    }
    
    @CompileStatic
    private void throwErrorIfNotEligibleToExecute(String username, String password) throws Exception {
        String osName = System.getProperty("os.name")
        IDriverType driverType = DriverFactory.getExecutedBrowser()

        if(driverType == WebUIDriverType.IE_DRIVER && !StringUtils.containsIgnoreCase(osName, "win")) {
            throw new Exception("Unsupported platform (only support Windows)")
        }

        if(!supportedDrivers.contains(driverType)){
            throw new Exception(getUnsupportedBrowserMessage())
        }
        
        String browserName = WebDriverUtil.getBrowserName(DriverFactory.getWebDriver())
        if (!isSupportedBrowser(browserName)) {
            throw new Exception("Unsupported browser (only support Chrome, Firefox, and Edge Chromium)")
        }
        
        logger.logDebug(StringConstants.KW_LOG_INFO_CHECKING_USERNAME)
        if (username == null) {
            throw new IllegalArgumentException(StringConstants.KW_EXC_USERNAME_IS_NULL)
        }
        logger.logDebug(StringConstants.KW_LOG_INFO_CHECKING_PASSWORD)
        if (password == null) {
            throw new IllegalArgumentException(StringConstants.KW_EXC_PASSWORD_IS_NULL)
        }
    }
    
    @CompileStatic
    private boolean isSupportedBrowser(String browserName) {
        return supportedBrowsers.stream()
                .anyMatch({supported -> browserName.containsIgnoreCase(supported)});
    }
}
