package com.kms.katalon.core.webui.keyword.builtin

import java.text.MessageFormat

import org.openqa.selenium.JavascriptExecutor
import org.openqa.selenium.WebDriver
import org.openqa.selenium.WebElement

import com.kms.katalon.core.annotation.internal.Action
import com.kms.katalon.core.configuration.RunConfiguration
import com.kms.katalon.core.exception.StepFailedException
import com.kms.katalon.core.keyword.internal.SupportLevel
import com.kms.katalon.core.model.FailureHandling
import com.kms.katalon.core.testobject.TestObject
import com.kms.katalon.core.webui.common.WebUiCommonHelper
import com.kms.katalon.core.webui.constants.StringConstants
import com.kms.katalon.core.webui.driver.DriverFactory
import com.kms.katalon.core.webui.keyword.internal.WebUIAbstractKeyword
import com.kms.katalon.core.webui.keyword.internal.WebUIKeywordMain
import com.kms.katalon.core.webui.model.SeleniumActionRetryController.RetryContext

import groovy.transform.CompileStatic

@Action(value = "findWebElement")
public class FindWebElementKeyword extends WebUIAbstractKeyword {

    @CompileStatic
    @Override
    public SupportLevel getSupportLevel(Object ...params) {
        return super.getSupportLevel(params)
    }

    @CompileStatic
    @Override
    public Object execute(Object ...params) {
        TestObject to = getTestObject(params[0])
        int timeOut = (int) params[1]
        FailureHandling flowControl = (FailureHandling)(params.length > 2 && params[2] instanceof FailureHandling ? params[2] : RunConfiguration.getDefaultFailureHandling())
        findWebElement(to, timeOut, flowControl)
    }

    @CompileStatic
    public WebElement findWebElement(TestObject to, int timeout, FailureHandling flowControl) throws StepFailedException {
        WebDriver driver = DriverFactory.getWebDriver();
        timeout = WebUiCommonHelper.checkTimeout(timeout);
        long timeoutInMillis = timeout * 1000L;
        return (WebElement) WebUIKeywordMain.runKeywordUntilTimeout({retryContext ->
            boolean isSwitchedIntoFrame = false;
            try {
                isSwitchedIntoFrame = WebUiCommonHelper.switchToParentFrame(driver, to);
                WebElement webElement = findWebElement(driver, to, timeoutInMillis);
                logger.logPassed(MessageFormat.format(StringConstants.KW_MSG_FOUND_WEB_ELEMENT, to.getObjectId()));
                return webElement;
            } finally {
                if (isSwitchedIntoFrame) {
                    WebUiCommonHelper.switchToDefaultContent(driver)
                }
            }
            return null
        }, flowControl, RunConfiguration.getTakeScreenshotOption(), (to != null) ? MessageFormat.format(StringConstants.KW_MSG_CANNOT_FIND_WEB_ELEMENT_X, to.getObjectId())
        : StringConstants.KW_MSG_CANNOT_FIND_WEB_ELEMENT, timeout)
    }
}
