package com.kms.katalon.core.webui.keyword.builtin

import static org.openqa.selenium.WindowType.TAB

import java.text.MessageFormat

import org.apache.commons.lang3.StringUtils
import org.openqa.selenium.WebDriver

import com.kms.katalon.core.annotation.internal.Action
import com.kms.katalon.core.configuration.RunConfiguration
import com.kms.katalon.core.exception.StepFailedException
import com.kms.katalon.core.keyword.internal.SupportLevel
import com.kms.katalon.core.model.FailureHandling
import com.kms.katalon.core.util.internal.PathUtil
import com.kms.katalon.core.webui.constants.StringConstants
import com.kms.katalon.core.webui.driver.DriverFactory
import com.kms.katalon.core.webui.keyword.internal.WebUIAbstractKeyword
import com.kms.katalon.core.webui.keyword.internal.WebUIKeywordMain

import groovy.transform.CompileStatic

@Action(value = "newTab")
public class NewTabKeyword extends WebUIAbstractKeyword {

    @CompileStatic
    @Override
    public SupportLevel getSupportLevel(Object ...params) {
        return super.getSupportLevel(params)
    }

    @CompileStatic
    @Override
    public Object execute(Object ...params) {
        String rawUrl = (String) params[0]
        FailureHandling flowControl = (FailureHandling)(params.length > 1 && params[1] instanceof FailureHandling ? params[1] : RunConfiguration.getDefaultFailureHandling())
        newTabAndNavigateToUrl(rawUrl, flowControl)
    }

    @CompileStatic
    public void newTabAndNavigateToUrl(String rawUrl, FailureHandling flowControl) throws StepFailedException {
        WebUIKeywordMain.runKeyword({
            WebDriver webDriver = DriverFactory.getWebDriver()
            webDriver.switchTo().newWindow(TAB)

            // Auto navigate the new tab to the url if any
            logger.logDebug(StringConstants.KW_LOG_INFO_CHECKING_URL)
            if (StringUtils.isNotBlank(rawUrl)) {
                URL url = PathUtil.getUrl(rawUrl, "http")
                logger.logDebug(MessageFormat.format(StringConstants.KW_LOG_INFO_NAVIGATING_TO, url.toString()))
                webDriver.navigate().to(url.toString())
            }

            logger.logPassed(MessageFormat.format(StringConstants.KW_LOG_PASSED_NEW_TAB_AND_NAVIGATE_TO, rawUrl))
        }, flowControl, RunConfiguration.getTakeScreenshotOption(), MessageFormat.format(StringConstants.KW_MSG_CANNOT_NEW_TAB_AND_NAVIGATE_TO, rawUrl))
    }
}
