package com.kms.katalon.core.webui.keyword.builtin

import java.text.MessageFormat

import org.openqa.selenium.WebElement
import org.openqa.selenium.interactions.Actions
import org.openqa.selenium.interactions.WheelInput

import com.kms.katalon.core.annotation.internal.Action
import com.kms.katalon.core.configuration.RunConfiguration
import com.kms.katalon.core.exception.StepFailedException
import com.kms.katalon.core.keyword.internal.SupportLevel
import com.kms.katalon.core.model.FailureHandling
import com.kms.katalon.core.testobject.TestObject
import com.kms.katalon.core.webui.common.WebUiCommonHelper
import com.kms.katalon.core.webui.constants.StringConstants
import com.kms.katalon.core.webui.driver.DriverFactory
import com.kms.katalon.core.webui.keyword.internal.WebUIAbstractKeyword
import com.kms.katalon.core.webui.keyword.internal.WebUIKeywordMain

import groovy.transform.CompileStatic

@Action(value = "scrollFromElement")
public class ScrollFromElementKeyword extends WebUIAbstractKeyword {

    @CompileStatic
    @Override
    public SupportLevel getSupportLevel(Object ...params) {
        return super.getSupportLevel(params)
    }

    @CompileStatic
    @Override
    public Object execute(Object ...params) {
        TestObject fromElement = getTestObject(params[0])
        int deltaX = (int) params[1]
        int deltaY = (int) params[2]
        int timeOut = (int) params[3]
        FailureHandling flowControl = (FailureHandling)(params.length > 4 && params[4] instanceof FailureHandling ? params[4] : RunConfiguration.getDefaultFailureHandling())
        scrollFromElement(fromElement, deltaX, deltaY, timeOut, flowControl)
    }

    @CompileStatic
    public void scrollFromElement(TestObject to, int deltaX, int deltaY, int timeOut, FailureHandling flowControl) throws StepFailedException {
        WebUIKeywordMain.runKeyword({
            boolean isSwitchIntoFrame = false
            try {
                WebUiCommonHelper.checkTestObjectParameter(to)
                timeOut = WebUiCommonHelper.checkTimeout(timeOut)
                isSwitchIntoFrame = WebUiCommonHelper.switchToParentFrame(to)
                WebElement webElement = WebUIAbstractKeyword.findWebElement(to, timeOut)
                logger.logDebug(MessageFormat.format(StringConstants.KW_LOG_INFO_SCROLLING_FROM_OBJ, to.getObjectId()))
                WheelInput.ScrollOrigin scrollOrigin = WheelInput.ScrollOrigin.fromElement(webElement)
                (new Actions(DriverFactory.getWebDriver()))
                        .scrollFromOrigin(scrollOrigin, deltaX, deltaY).perform()
                logger.logPassed(MessageFormat.format(StringConstants.KW_LOG_PASSED_SCROLLING_FROM_OBJ, to.getObjectId()))
            } finally {
                if (isSwitchIntoFrame) {
                    WebUiCommonHelper.switchToDefaultContent()
                }
            }
        }, flowControl, RunConfiguration.getTakeScreenshotOption(), (to != null) ? MessageFormat.format(StringConstants.KW_MSG_CANNOT_SCROLLING_FROM_OBJ, to.getObjectId())
        : StringConstants.KW_MSG_CANNOT_SCROLLING_TO_OBJ)
    }
}
