package com.kms.katalon.core.webui.keyword.builtin

import java.awt.Color

import com.kms.katalon.core.annotation.internal.Action
import com.kms.katalon.core.configuration.RunConfiguration
import com.kms.katalon.core.keyword.internal.SupportLevel
import com.kms.katalon.core.model.FailureHandling
import com.kms.katalon.core.model.TakeScreenshotOption
import com.kms.katalon.core.testobject.TestObject
import com.kms.katalon.core.util.internal.TestOpsUtil
import com.kms.katalon.core.webui.common.WebUiCommonHelper
import com.kms.katalon.core.webui.common.internal.SmartWait
import com.kms.katalon.core.webui.constants.StringConstants
import com.kms.katalon.core.webui.driver.DriverFactory
import com.kms.katalon.core.webui.helper.screenshot.ScreenshotTextHelper
import com.kms.katalon.core.webui.keyword.internal.WebUIAbstractKeyword
import com.kms.katalon.core.webui.keyword.internal.WebUIKeywordMain
import com.kms.katalon.core.webui.util.FileUtil

import groovy.transform.CompileStatic

@Action(value = "takeScreenshot")
public class TakeScreenshotKeyword extends WebUIAbstractKeyword {

    @CompileStatic
    @Override
    public SupportLevel getSupportLevel(Object ...params) {
        return super.getSupportLevel(params)
    }

    @CompileStatic
    @Override
    public Object execute(Object... params) {
        if (!isValidData(params)) {
            return null
        }

        String fileName = (String)params[0]
        boolean isTestOpsVisionCheckPoint = (boolean)params[3]
        if (!isTestOpsVisionCheckPoint && fileName == null) {
            fileName = defaultFileName()
        }
        List<TestObject> hideElement = (List<TestObject>) params[1];
        Color hideColor = (Color)params[2];
        Map<String, Object> screenshotOptions = (Map<String, Object>) params[4];
        FailureHandling flowControl = params[5] == null ?
                RunConfiguration.getDefaultFailureHandling() : (FailureHandling)params[5]
        return takeScreenshot(fileName, hideElement, hideColor, isTestOpsVisionCheckPoint, screenshotOptions, flowControl)
    }

    private boolean isValidData(Object... params) {
        if (params.length != 6) {
            return false
        }

        if (params[0] != null && !(params[0] instanceof String)) {
            return false;
        }
        
        if (params[1] != null && !(params[1] instanceof List)) {
            return false;
        }
        
        if (params[2] != null && !(params[2] instanceof Color)) {
            return false;
        }
        
        if (params[3] != null && !(params[3] instanceof Boolean)) {
            return false;
        }

        if (params[4] != null && !(params[4] instanceof Map)) {
            return false;
        }

        if (params[5] != null && !(params[5] instanceof FailureHandling)) {
            return false;
        }

        return true;
    }

    private String defaultFileName() {
        return logger.getLogFolderPath() + File.separator + System.currentTimeMillis() + ".png";
    }

    @CompileStatic
    public String takeScreenshot(String fileName, List<TestObject> hideElements, Color hideColor,
            boolean isTestOpsVisionCheckPoint, Map<String, Object> screenshotOptions, FailureHandling flowControl) {
        long timeoutInMillis = RunConfiguration.getElementTimeoutForWebInMillis()

        return WebUIKeywordMain.runKeyword({
            if (WebUiCommonHelper.smartWaitEnabled()) {
                SmartWait.doSmartWait(DriverFactory.getWebDriver(), timeoutInMillis)
            }

            String screenFileName = FileUtil.takesScreenshot(fileName, hideElements, hideColor, isTestOpsVisionCheckPoint);
            if (screenshotOptions != null) {
                ScreenshotTextHelper.addTextToScreenShot(screenFileName, screenshotOptions)
            }
            if (screenFileName != null) {
                String fileNameForLog = TestOpsUtil.getRelativePathForLog(screenFileName)
                Map<String, String> attributes = new HashMap<>()
                attributes.put(StringConstants.XML_LOG_ATTACHMENT_PROPERTY, fileNameForLog)
                logger.logPassed("Taking screenshot successfully", attributes)
            }
            return screenFileName;
        }, flowControl, TakeScreenshotOption.NONE, StringConstants.KW_LOG_WARNING_CANNOT_TAKE_SCREENSHOT)
    }
}
