package com.kms.katalon.core.webui.keyword.builtin

import java.text.MessageFormat
import java.util.concurrent.TimeUnit

import org.openqa.selenium.JavascriptExecutor
import org.openqa.selenium.WebDriver
import org.openqa.selenium.WebElement
import org.openqa.selenium.support.ui.Select

import com.kms.katalon.core.annotation.internal.Action
import com.kms.katalon.core.configuration.RunConfiguration
import com.kms.katalon.core.exception.StepFailedException
import com.kms.katalon.core.keyword.internal.SupportLevel
import com.kms.katalon.core.model.FailureHandling
import com.kms.katalon.core.testobject.TestObject
import com.kms.katalon.core.webui.common.WebUiCommonHelper
import com.kms.katalon.core.webui.constants.StringConstants
import com.kms.katalon.core.webui.driver.DriverFactory
import com.kms.katalon.core.webui.keyword.internal.WebUIAbstractKeyword
import com.kms.katalon.core.webui.keyword.internal.WebUIKeywordMain
import com.kms.katalon.core.webui.model.SeleniumActionRetryController.RetryContext

import groovy.transform.CompileStatic

@Action(value = "verifyOptionPresentByLabel")
public class VerifyOptionPresentByLabelKeyword extends WebUIAbstractKeyword {

    @CompileStatic
    @Override
    public SupportLevel getSupportLevel(Object ...params) {
        return super.getSupportLevel(params)
    }

    @CompileStatic
    @Override
    public Object execute(Object ...params) {
        TestObject to = getTestObject(params[0])
        String label = (String) params[1]
        boolean isRegex = (boolean) params[2]
        int timeOut = (int) params[3]
        FailureHandling flowControl = (FailureHandling)(params.length > 4 && params[4] instanceof FailureHandling ? params[4] : RunConfiguration.getDefaultFailureHandling())
        return verifyOptionPresentByLabel(to,label,isRegex,timeOut,flowControl)
    }

    @CompileStatic
    public boolean verifyOptionPresentByLabel(TestObject to, String label, boolean isRegex, int timeOut,
            FailureHandling flowControl) throws StepFailedException {
        String regularExpressionLog = ((isRegex) ? " using regular expression" : "")
        WebDriver driver = DriverFactory.getWebDriver();
        timeOut = WebUiCommonHelper.checkTimeout(timeOut)
        long timeoutInMillis = TimeUnit.SECONDS.toMillis(timeOut)
        return WebUIKeywordMain.runKeywordUntilTimeout({retryContext ->
            boolean isSwitchIntoFrame = false
            try {
                WebUiCommonHelper.checkTestObjectParameter(to)
                logger.logDebug(StringConstants.KW_LOG_INFO_CHECKING_LBL)
                if (label == null) {
                    throw new IllegalArgumentException(StringConstants.KW_EXC_LBL_CANNOT_BE_NULL)
                }
                isSwitchIntoFrame = WebUiCommonHelper.switchToParentFrame(driver, to, timeOut)
                WebElement webElement = WebUIAbstractKeyword.findWebElement(driver, to, timeoutInMillis)
                logger.logDebug("Checking if element is interactable: " + to.getObjectId());
                if (webElement != null && driver instanceof JavascriptExecutor) {
                    waitElementInteractable((JavascriptExecutor) driver, webElement, timeoutInMillis, (RetryContext) retryContext);
                }
                int numPresent = WebUiCommonHelper.getNumberOfOptionByLabel(new Select(webElement), label, isRegex,
                        to.getObjectId())

                if (numPresent <= 0) {
                    WebUIKeywordMain.stepFailed(MessageFormat.format(StringConstants.KW_MSG_THERE_IS_NO_OPT_W_LBL_X_PRESENT_IN_OBJ_Y, label, to.getObjectId(), regularExpressionLog), flowControl, null, true)
                } else {
                    logger.logPassed(MessageFormat.format(StringConstants.KW_LOG_PASSED_X_OPTS_W_LBL_Y_PRESENTED_IN_OBJ_Z, numPresent, label, to.getObjectId(), regularExpressionLog))
                }
                return numPresent > 0
            } finally {
                if (isSwitchIntoFrame) {
                    WebUiCommonHelper.switchToDefaultContent(driver)
                }
            }
            return false
        }, flowControl, RunConfiguration.getTakeScreenshotOption(), (to != null && label != null) ? MessageFormat.format(StringConstants.KW_MSG_CANNOT_VERIFY_OPT_IS_PRESENT_BY_LBL_X_IN_OBJ_Y, label, to.getObjectId(), regularExpressionLog) : MessageFormat.format(StringConstants.KW_MSG_CANNOT_VERIFY_OPT_IS_PRESENT_BY_LBL_X, regularExpressionLog), timeOut)
    }
}
