package com.kms.katalon.core.webui.keyword.builtin

import java.text.MessageFormat
import java.util.concurrent.TimeUnit

import org.openqa.selenium.JavascriptExecutor
import org.openqa.selenium.TimeoutException
import org.openqa.selenium.WebDriver
import org.openqa.selenium.WebElement

import com.kms.katalon.core.annotation.internal.Action
import com.kms.katalon.core.configuration.RunConfiguration
import com.kms.katalon.core.exception.StepFailedException
import com.kms.katalon.core.keyword.internal.SupportLevel
import com.kms.katalon.core.model.FailureHandling
import com.kms.katalon.core.testobject.TestObject
import com.kms.katalon.core.webui.common.WebUiCommonHelper
import com.kms.katalon.core.webui.constants.StringConstants
import com.kms.katalon.core.webui.driver.DriverFactory
import com.kms.katalon.core.webui.exception.WebElementNotFoundException
import com.kms.katalon.core.webui.keyword.internal.WebUIAbstractKeyword
import com.kms.katalon.core.webui.keyword.internal.WebUIKeywordMain
import com.kms.katalon.core.webui.model.SeleniumActionRetryController.RetryContext

import groovy.transform.CompileStatic

@Action(value = "waitForElementClickable")
public class WaitForElementClickableKeyword extends WebUIAbstractKeyword {

    @CompileStatic
    @Override
    public SupportLevel getSupportLevel(Object ...params) {
        return super.getSupportLevel(params)
    }

    @CompileStatic
    @Override
    public Object execute(Object ...params) {
        TestObject to = getTestObject(params[0])
        int timeOut = (int) params[1]
        FailureHandling flowControl = (FailureHandling)(params.length > 2 && params[2] instanceof FailureHandling ? params[2] : RunConfiguration.getDefaultFailureHandling())
        return waitForElementClickable(to, timeOut, flowControl)
    }

    public boolean waitForElementClickable(TestObject to, int timeOut, FailureHandling flowControl) throws StepFailedException {
        WebDriver driver = DriverFactory.getWebDriver()
        timeOut = WebUiCommonHelper.checkTimeout(timeOut)
        long timeoutInMillis = TimeUnit.SECONDS.toMillis(timeOut)
        return WebUIKeywordMain.runKeywordUntilTimeout({retryContext ->
            boolean isSwitchIntoFrame = false
            try {
                WebUiCommonHelper.checkTestObjectParameter(to)
                try {
                    isSwitchIntoFrame = WebUiCommonHelper.switchToParentFrame(to, timeOut)
                    WebElement foundElement = WebUIAbstractKeyword.findWebElement(driver, to, timeoutInMillis)
                    if (foundElement != null && driver instanceof JavascriptExecutor) {
                        boolean isInteractable = waitElementInteractableByWaitingPhases((JavascriptExecutor) driver, foundElement, timeoutInMillis, (RetryContext) retryContext)
                        if (isInteractable) {
                            logger.logPassed(MessageFormat.format(StringConstants.KW_LOG_PASSED_OBJ_X_IS_CLICKABLE, to.getObjectId()))
                            return true
                        }
                    }
                    return false
                } catch (WebElementNotFoundException e) {
                    logger.logWarning(e.getMessage(), null, e)
                    return false
                } catch (TimeoutException e) {
                    logger.logWarning(MessageFormat.format(StringConstants.KW_MSG_OBJ_IS_NOT_CLICKABLE_AFTER_X_SEC, [to.getObjectId(), timeOut] as Object[]), null, e)
                    return false
                }
            } finally {
                if (isSwitchIntoFrame) {
                    WebUiCommonHelper.switchToDefaultContent()
                }
            }
        }, flowControl, RunConfiguration.getTakeScreenshotOption(), (to != null) ? MessageFormat.format(StringConstants.KW_MSG_CANNOT_WAIT_OBJ_X_TO_BE_CLICKABLE, to.getObjectId())
        : StringConstants.KW_MSG_CANNOT_WAIT_FOR_OBJ_TO_BE_CLICKABLE, timeOut)
    }
}
