package com.kms.katalon.core.webui.model;

import java.util.List;
import java.util.stream.Collectors;

import org.apache.commons.lang3.tuple.Pair;

import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.core.testobject.SelectorMethod;

public class WebUiLocatorProvider {
    private List<SelectorMethod> methodsPriorityOrder = RunConfiguration.getMethodsPriorityOrder()
            .stream()
            .filter(e -> e.getRight())
            .map(Pair::getLeft)
            .collect(Collectors.toList());

    private int currentIndex = 0;

    public SelectorMethod getNextLocator() {
        if (currentIndex < methodsPriorityOrder.size()) {
            return methodsPriorityOrder.get(currentIndex++);
        } else {
            currentIndex = 0;
            return null;
        }
    }
    
    public boolean hasNext() {
        return currentIndex < methodsPriorityOrder.size();
    }

    public boolean isLocatorEnabled(SelectorMethod method) {
        return methodsPriorityOrder.contains(method);
    }
}
