package com.kms.katalon.core.webui.trace;

import com.kms.katalon.core.trace.TraceDebug;
import com.kms.katalon.core.webui.driver.DriverFactory;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.UUID;

public final class SnapshotAgent {
    private SnapshotAgent() {
    }

    public static String installAndGetName() {
        WebDriver driver = DriverFactory.getWebDriver();
        if (!(driver instanceof JavascriptExecutor)) {
            return null;
        }
        String name = "__kte_snapshot_streamer_" + UUID.randomUUID().toString().replace("-", "");
        String jsFn = loadPlaywrightSnapshotterFunction();
        try {
            TraceDebug.writeLine("SnapshotAgent: injecting snapshotter name=" + name + " jsBytes=" + (jsFn != null ? jsFn.length() : -1));
        } catch (Throwable ignored) {
        }
        ((JavascriptExecutor) driver).executeScript(jsFn);
        Object result = ((JavascriptExecutor) driver).executeScript(
                "return (window.__kte_initSnapshotter && window.__kte_initSnapshotter(arguments[0], true)) || 'ERR_NO_INIT'",
                name);
        try {
            TraceDebug.writeLine("SnapshotAgent.install result=" + result);
        } catch (Throwable ignored) {
        }
        if ("ERR_NO_FN".equals(result)) {
            return null;
        }
        return result != null ? String.valueOf(result) : null;
    }

    public static Object captureSnapshot(String name) {
        WebDriver driver = DriverFactory.getWebDriver();
        if (!(driver instanceof JavascriptExecutor)) {
            return null;
        }
        String script =
                "var s=window['" + name + "'];" +
                " if(!s||!s.captureSnapshot) return null;" +
                " var r=s.captureSnapshot();" +
                " try{ return JSON.parse(JSON.stringify(r)); }catch(e){ return r; }";
        try {
            Object res = ((JavascriptExecutor) driver).executeScript(script);
            try {
                TraceDebug.writeLine("SnapshotAgent.capture: class=" + (res == null ? "null" : res.getClass().getName()));
            } catch (Throwable ignored) {
            }
            return res;
        } catch (Throwable t) {
            try {
                TraceDebug.writeLine("SnapshotAgent.capture error: " + t.getMessage());
            } catch (Throwable ignored) {
            }
            try {
                return ((JavascriptExecutor) driver).executeScript(script);
            } catch (Throwable ignored2) {
                return null;
            }
        }
    }

    private static String loadPlaywrightSnapshotterFunction() {
        InputStream stream = null;
        try {
            stream = SnapshotAgent.class.getResourceAsStream("/com/kms/katalon/core/trace/resources/snapshotterBundle.js");
            if (stream == null) {
                throw new RuntimeException("snapshotterBundle.js missing from resources");
            }
            return readAll(stream);
        } catch (Throwable t) {
            try {
                TraceDebug.writeLine("SnapshotAgent: failed to load snapshotter bundle: " + t.getMessage());
            } catch (Throwable ignored) {
            }
            throw new RuntimeException("Unable to load snapshotter bundle.", t);
        } finally {
            if (stream != null) {
                try {
                    stream.close();
                } catch (IOException ignored) {
                }
            }
        }
    }

    private static String readAll(InputStream in) throws IOException {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8))) {
            char[] buf = new char[4096];
            int n;
            while ((n = reader.read(buf)) != -1) {
                sb.append(buf, 0, n);
            }
        }
        return sb.toString();
    }
}

