/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.application.usagetracking;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.kms.katalon.application.KatalonApplication;
import com.kms.katalon.application.preference.ProjectSettingPreference;
import com.kms.katalon.application.usagetracking.UsageActionTrigger;
import com.kms.katalon.application.usagetracking.UsageInformation;
import com.kms.katalon.application.utils.ActivationInfoCollector;
import com.kms.katalon.application.utils.ApplicationInfo;
import com.kms.katalon.application.utils.ServerAPICommunicationUtil;
import com.kms.katalon.application.utils.VersionUtil;
import com.kms.katalon.core.model.RunningMode;
import com.kms.katalon.core.util.FileUtil;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.logging.LogUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class UsageInfoCollector {
    private static final String TEST_CASE_FOLDER = "Test Cases";
    private static final String REPORT_FOLDER = "Reports";
    private static final String EMAIL_KEY = "email";

    private UsageInfoCollector() {
    }

    public static void collect(UsageInformation usageInfo) {
        if (VersionUtil.isStagingBuild() || VersionUtil.isDevelopmentBuild()) {
            return;
        }
        JsonObject jsObject = new JsonObject();
        JsonObject jsTraits = ActivationInfoCollector.traitsWithAppInfo();
        jsTraits.addProperty("kat_version", usageInfo.getVersion());
        jsTraits.addProperty("project", (Number)usageInfo.getProjectCount());
        jsTraits.addProperty("test_case", (Number)usageInfo.getTestCaseCount());
        jsTraits.addProperty("test_run", (Number)usageInfo.getTestCaseRunCount());
        jsTraits.addProperty("new_project", (Number)usageInfo.getNewProjectCount());
        jsTraits.addProperty("new_test_case", (Number)usageInfo.getNewTestCaseCount());
        jsTraits.addProperty("new_test_run", (Number)usageInfo.getNewTestRunCount());
        jsTraits.addProperty("new_test_case_created", (Number)usageInfo.getNewTestCaseCreatedCount());
        jsTraits.addProperty("new_project_created", (Number)usageInfo.getNewProjectCreatedCount());
        jsTraits.addProperty("sessionId", KatalonApplication.SESSION_ID);
        jsTraits.addProperty("triggeredBy", usageInfo.getTriggeredBy());
        jsTraits.addProperty("runningMode", usageInfo.getRunningMode());
        jsTraits.addProperty("userKey", usageInfo.getUserKey());
        jsObject.add("traits", (JsonElement)jsTraits);
        jsObject.addProperty("userId", usageInfo.getEmail());
        UsageInfoCollector.sendUsageInfo(jsObject, usageInfo);
    }

    private static void sendUsageInfo(JsonObject jsObject, UsageInformation usageInfo) {
        try {
            ServerAPICommunicationUtil.post("/product/usage", jsObject.toString());
            LogUtil.logErrorMessage((String)jsObject.toString());
            ApplicationInfo.setAppProperty("ntc", String.valueOf(usageInfo.getTestCaseCount()), true);
            ApplicationInfo.setAppProperty("ntr", String.valueOf(usageInfo.getTestCaseRunCount()), true);
            ApplicationInfo.setAppProperty("ntcc", String.valueOf(0), true);
            ApplicationInfo.setAppProperty("npc", String.valueOf(0), true);
            ApplicationInfo.setAppProperty("orgTime", String.valueOf(new Date().getTime()), true);
        }
        catch (Exception ex) {
            LogUtil.logError((Throwable)ex);
        }
    }

    private static Date restorePreviousUsageInfo(UsageInformation usageInfo) {
        try {
            String sTime = ApplicationInfo.getAppProperty("orgTime");
            if (sTime == null) {
                return new Date(0L);
            }
            usageInfo.setTestCaseCount(UsageInfoCollector.getIntProperty("ntc"));
            usageInfo.setTestCaseRunCount(UsageInfoCollector.getIntProperty("ntr"));
            usageInfo.setNewTestCaseCreatedCount(UsageInfoCollector.getIntProperty("ntcc"));
            usageInfo.setNewProjectCreatedCount(UsageInfoCollector.getIntProperty("npc"));
            return new Date(Long.parseLong(sTime));
        }
        catch (Exception ex) {
            LogUtil.logError((Throwable)ex);
            usageInfo.setTestCaseCount(0);
            usageInfo.setTestCaseRunCount(0);
            return new Date(0L);
        }
    }

    private static int getIntProperty(String key) {
        return Integer.parseInt(ApplicationInfo.getAppProperty(key));
    }

    public static UsageInformation getActivatedUsageInfo(UsageActionTrigger actionTrigger, RunningMode runningMode) {
        String email = ApplicationInfo.getAppProperty(EMAIL_KEY);
        UsageInformation usageInfo = UsageInformation.createActivatedInfo(email, KatalonApplication.SESSION_ID, KatalonApplication.USER_KEY);
        Date orgTime = UsageInfoCollector.restorePreviousUsageInfo(usageInfo);
        List<String> projectPaths = UsageInfoCollector.getRecentProjects();
        usageInfo.setVersion(String.valueOf(ApplicationInfo.versionNo()) + " build " + ApplicationInfo.buildNo());
        usageInfo.setTriggeredBy(actionTrigger.getAction());
        usageInfo.setRunningMode(runningMode.getMode());
        for (String prjPath : projectPaths) {
            try {
                UsageInfoCollector.collectUsageProjectInfo(prjPath, usageInfo, orgTime);
            }
            catch (IOException ex) {
                LogUtil.printAndLogError((Throwable)ex);
            }
        }
        return usageInfo;
    }

    public static UsageInformation getAnonymousUsageInfo(UsageActionTrigger actionTrigger, RunningMode runningMode) {
        UsageInformation usageInfo = UsageInformation.createAnonymousInfo(KatalonApplication.SESSION_ID, KatalonApplication.USER_KEY);
        usageInfo.setVersion(String.valueOf(ApplicationInfo.versionNo()) + " build " + ApplicationInfo.buildNo());
        usageInfo.setTriggeredBy(actionTrigger.getAction());
        usageInfo.setRunningMode(runningMode.getMode());
        return usageInfo;
    }

    private static void collectUsageProjectInfo(String prjPath, UsageInformation usageInfo, Date orgTime) throws IOException {
        File reportFolder = new File(String.valueOf(prjPath) + File.separator + REPORT_FOLDER);
        File testcaseFolder = new File(String.valueOf(prjPath) + File.separator + TEST_CASE_FOLDER);
        File[] csvFiles = FileUtil.getFiles((File)reportFolder, (String)".csv", (Date)orgTime);
        int newTestRunCount = 0;
        int newTestcaseCount = 0;
        if (FileUtil.isFileCreateAfter((File)new File(prjPath), (Date)orgTime)) {
            usageInfo.setNewProjectCount(usageInfo.getNewProjectCount() + 1);
        }
        usageInfo.setProjectCount(usageInfo.getProjectCount() + 1);
        newTestcaseCount = FileUtil.countAllFiles((File)testcaseFolder, (String)".tc", (Date)orgTime);
        usageInfo.setNewTestCaseCount(usageInfo.getNewTestCaseCount() + newTestcaseCount);
        usageInfo.setTestCaseCount(usageInfo.getTestCaseCount() + newTestcaseCount);
        File[] fileArray = csvFiles;
        int n = csvFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File csvfile = fileArray[n2];
            newTestRunCount += UsageInfoCollector.getNumberTestRun(csvfile);
            ++n2;
        }
        usageInfo.setNewTestRunCount(usageInfo.getNewTestRunCount() + newTestRunCount);
        usageInfo.setTestCaseRunCount(usageInfo.getTestCaseRunCount() + newTestRunCount);
    }

    private static int getNumberTestRun(File csvFile) {
        int count = 0;
        try {
            List<String> lines = Files.readAllLines(csvFile.toPath(), Charset.forName("UTF-8"));
            for (String line : lines) {
                if (!line.startsWith("Test Cases/")) continue;
                ++count;
            }
        }
        catch (Exception ex) {
            LogUtil.logError((Throwable)ex);
        }
        return count;
    }

    private static List<String> getRecentProjects() {
        ArrayList<String> projectPaths = new ArrayList<String>();
        try {
            for (ProjectEntity prEntity : new ProjectSettingPreference().getRecentProjects()) {
                projectPaths.add(prEntity.getFolderLocation());
            }
        }
        catch (Exception ex) {
            LogUtil.logError((Throwable)ex);
        }
        return projectPaths;
    }
}

