/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.application.utils;

import com.kms.katalon.application.constants.ApplicationStringConstants;
import com.kms.katalon.application.utils.ApplicationInfo;
import com.kms.katalon.logging.LogUtil;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

public class LicenseInfo {
    private static final String LICENSE_SERVER_URL = "serverURL";
    private static final String LICENSE_SERVER_URL_SECOND_OPTION = "serverUrl";
    private static final String LICENSE_SERVER_URL_THIRD_OPTION = "serverurl";
    private static final String LICENSE_API_KEY = "apiKey";
    private static final String LICENSE_API_KEY_SECOND_OPTION = "apikey";
    private static Properties licenseProperties;

    private static Properties getLicenseProperties() {
        if (licenseProperties != null) {
            return licenseProperties;
        }
        File licensePropFile = new File(ApplicationStringConstants.APP_LICENSE_SERVER_FILE_LOCATION);
        File katalonDir = new File(ApplicationInfo.userDirLocation());
        if (!licensePropFile.exists()) {
            if (!katalonDir.exists()) {
                katalonDir.mkdir();
            }
            try {
                licensePropFile.createNewFile();
            }
            catch (Exception e) {
                LogUtil.logError((Throwable)e);
            }
        }
        try {
            Throwable e = null;
            Object var3_6 = null;
            try (FileInputStream in = new FileInputStream(licensePropFile);){
                licenseProperties = new Properties();
                licenseProperties.load(in);
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                } else if (e != throwable) {
                    e.addSuppressed(throwable);
                }
                throw e;
            }
        }
        catch (Exception e) {
            licenseProperties = null;
            LogUtil.logError((Throwable)e);
        }
        return licenseProperties;
    }

    public static String getLicenseProperty(String key) {
        Properties licenseProps = LicenseInfo.getLicenseProperties();
        if (licenseProps != null && licenseProps.containsKey(key)) {
            return licenseProps.getProperty(key);
        }
        return null;
    }

    public static String getServerURL() {
        String server = LicenseInfo.getLicenseProperty(LICENSE_SERVER_URL);
        if (StringUtils.isEmpty((CharSequence)server)) {
            server = LicenseInfo.getLicenseProperty(LICENSE_SERVER_URL_SECOND_OPTION);
        }
        if (StringUtils.isEmpty((CharSequence)server)) {
            server = LicenseInfo.getLicenseProperty(LICENSE_SERVER_URL_THIRD_OPTION);
        }
        return server;
    }

    public static String getApiKey() {
        String apiKey = LicenseInfo.getLicenseProperty(LICENSE_API_KEY);
        if (StringUtils.isEmpty((CharSequence)apiKey)) {
            apiKey = LicenseInfo.getLicenseProperty(LICENSE_API_KEY_SECOND_OPTION);
        }
        return apiKey;
    }
}

