/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.application.utils;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kms.katalon.application.constants.ApplicationMessageConstants;
import com.kms.katalon.application.utils.ApplicationProxyUtil;
import com.kms.katalon.application.utils.RequestException;
import com.kms.katalon.application.utils.VersionUtil;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.logging.LogUtil;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang3.StringUtils;

public class ServerAPICommunicationUtil {
    private static final String PROTOCOL = "SSL";
    public static final String DEVELOPMENT_URL_API = "https://backend-dev.katalon.com/api";
    private static final String PRODUCTION_URL_API = "https://update.katalon.com/api";
    public static final String DEVELOPMENT_WEB_URL = "https://wp-dev.katalon.com";
    public static final String PRODUCTION_WEB_URL = "https://katalon.com";
    private static final String POST = "POST";
    private static final String GET = "GET";
    private static final String PUT = "PUT";
    private static final String HTTP = "http";
    protected static final boolean HOST_NAME_VERIFY_VALUE = true;
    public static final String HUBSPOT_CONTACT_API = "https://raw.githubusercontent.com/katalon-studio/katalon-studio/master/hubspot-contact.json";
    public static final String DEFAULT_HUBSPT_HOST_CONTACT_API_URL = "https://web-api.katalon.com";

    public static String post(String function, String jsonData) throws IOException, GeneralSecurityException {
        return ServerAPICommunicationUtil.invoke(POST, function, jsonData, true);
    }

    public static String post(String function, String jsonData, boolean post) throws IOException, GeneralSecurityException {
        return ServerAPICommunicationUtil.invoke(POST, function, jsonData, post);
    }

    public static String post(String serverUrl, String function, String jsonData, boolean post) throws IOException, GeneralSecurityException {
        return ServerAPICommunicationUtil.invoke(POST, serverUrl, function, jsonData, post);
    }

    public static String put(String function, String jsonData) throws IOException, GeneralSecurityException {
        return ServerAPICommunicationUtil.invoke(PUT, function, jsonData);
    }

    public static String invokeFormEncoded(String endpoint, String method, String data) throws IOException, GeneralSecurityException, RequestException {
        HttpURLConnection connection = null;
        try {
            connection = ServerAPICommunicationUtil.createConnection(method, endpoint, ApplicationProxyUtil.getAuthProxy());
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            String result = ServerAPICommunicationUtil.sendAndReceiveData(connection, data);
            int statusCode = connection.getResponseCode();
            if (statusCode == 403 || statusCode == 502 || statusCode == 503) {
                throw new RequestException("Request failed with status code: " + statusCode);
            }
            String string = result;
            return string;
        }
        catch (Exception ex) {
            LogUtil.logError((Throwable)ex);
            String string = ServerAPICommunicationUtil.retryInvokeFormEncoded(endpoint, method, data);
            return string;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public static String retryInvokeFormEncoded(String endpoint, String method, String data) throws IOException, GeneralSecurityException, RequestException {
        LogUtil.printAndLogError(null, (String)ApplicationMessageConstants.REQUEST_FAILED_AND_RETRY);
        HttpURLConnection connection = null;
        try {
            connection = ServerAPICommunicationUtil.createConnection(method, endpoint, ApplicationProxyUtil.getAuthRetryProxy());
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            String result = ServerAPICommunicationUtil.sendAndReceiveData(connection, data);
            int statusCode = connection.getResponseCode();
            if (statusCode == 403 || statusCode == 502 || statusCode == 503) {
                throw new RequestException("Request failed with status code: " + statusCode);
            }
            String string = result;
            return string;
        }
        catch (IOException e) {
            LogUtil.logError((Throwable)e);
            throw e;
        }
        catch (URISyntaxException e) {
            LogUtil.printAndLogError(null, (String)ApplicationMessageConstants.REQUEST_FAILED);
            LogUtil.logError((Throwable)e);
            return "";
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public static String invoke(String method, String function, String jsonData) throws IOException, GeneralSecurityException {
        return ServerAPICommunicationUtil.invoke(method, function, jsonData, true);
    }

    public static String invoke(String method, String function, String jsonData, boolean retry) throws IOException, GeneralSecurityException {
        HttpURLConnection connection = null;
        try {
            String result;
            connection = ServerAPICommunicationUtil.createConnection(method, String.valueOf(ServerAPICommunicationUtil.getAPIUrl()) + function, ApplicationProxyUtil.getAuthProxy());
            String string = result = ServerAPICommunicationUtil.sendAndReceiveData(connection, jsonData);
            return string;
        }
        catch (Exception ex) {
            LogUtil.logError((Throwable)ex);
            if (retry) {
                String string = ServerAPICommunicationUtil.retryInvoke(method, function, jsonData);
                return string;
            }
            return null;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public static String invoke(String method, String url, String function, String jsonData, boolean retry) throws IOException, GeneralSecurityException {
        HttpURLConnection connection = null;
        try {
            String result;
            connection = ServerAPICommunicationUtil.createConnection(method, String.valueOf(url) + function, ApplicationProxyUtil.getAuthProxy());
            String string = result = ServerAPICommunicationUtil.sendAndReceiveData(connection, jsonData);
            return string;
        }
        catch (Exception ex) {
            LogUtil.logError((Throwable)ex);
            if (retry) {
                String string = ServerAPICommunicationUtil.retryInvoke(method, url, function, jsonData);
                return string;
            }
            return null;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public static String retryInvoke(String method, String function, String jsonData) throws IOException, GeneralSecurityException {
        LogUtil.printAndLogError(null, (String)ApplicationMessageConstants.REQUEST_FAILED_AND_RETRY);
        HttpURLConnection connection = null;
        try {
            connection = ServerAPICommunicationUtil.createConnection(method, String.valueOf(ServerAPICommunicationUtil.getAPIUrl()) + function, ApplicationProxyUtil.getAuthRetryProxy());
            String result = ServerAPICommunicationUtil.sendAndReceiveData(connection, jsonData);
            LogUtil.printOutputLine((String)ApplicationMessageConstants.REQUEST_COMPLETED);
            String string = result;
            return string;
        }
        catch (IOException e) {
            LogUtil.logError((Throwable)e);
            throw e;
        }
        catch (URISyntaxException e) {
            LogUtil.logError((Throwable)e);
            return "";
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public static String retryInvoke(String method, String url, String function, String jsonData) throws IOException, GeneralSecurityException {
        LogUtil.printAndLogError(null, (String)ApplicationMessageConstants.REQUEST_FAILED_AND_RETRY);
        HttpURLConnection connection = null;
        try {
            connection = ServerAPICommunicationUtil.createConnection(method, String.valueOf(url) + function, ApplicationProxyUtil.getAuthRetryProxy());
            String result = ServerAPICommunicationUtil.sendAndReceiveData(connection, jsonData);
            LogUtil.printOutputLine((String)ApplicationMessageConstants.REQUEST_COMPLETED);
            String string = result;
            return string;
        }
        catch (IOException e) {
            LogUtil.logError((Throwable)e);
            throw e;
        }
        catch (URISyntaxException e) {
            LogUtil.logError((Throwable)e);
            return "";
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public static String getAPIUrl() {
        if (VersionUtil.isStagingBuild() || VersionUtil.isDevelopmentBuild()) {
            return DEVELOPMENT_URL_API;
        }
        return PRODUCTION_URL_API;
    }

    public static String getWebUrl() {
        if (VersionUtil.isStagingBuild() || VersionUtil.isDevelopmentBuild()) {
            return DEVELOPMENT_WEB_URL;
        }
        return PRODUCTION_WEB_URL;
    }

    public static String getUpdateContactWebUrl() throws Exception {
        HubSpot hubSpot;
        block3: {
            hubSpot = null;
            try {
                hubSpot = ServerAPICommunicationUtil.getHubsportContactApi();
            }
            catch (Exception e) {
                if (!(e instanceof IllegalArgumentException)) break block3;
                return DEFAULT_HUBSPT_HOST_CONTACT_API_URL;
            }
        }
        if (VersionUtil.isStagingBuild() || VersionUtil.isDevelopmentBuild()) {
            return hubSpot.getStagingUrl();
        }
        return hubSpot.getProductionUrl();
    }

    public static String getSignupAPIUrl() {
        return String.valueOf(ServerAPICommunicationUtil.getWebUrl()) + "/wp-admin/admin-ajax.php";
    }

    public static String getSignupUrlWithActivationRedirectLink() throws UnsupportedEncodingException {
        return String.valueOf(ServerAPICommunicationUtil.getWebUrl()) + "/sign-up?redirect=" + URLEncoder.encode(ServerAPICommunicationUtil.getActivationUrl(), "utf-8");
    }

    public static String getActivationUrl() {
        return String.valueOf(ServerAPICommunicationUtil.getWebUrl()) + "/activation";
    }

    public static String getInformation(String url, JsonObject jsonObject) {
        try {
            return ServerAPICommunicationUtil.invoke(GET, url, jsonObject.toString());
        }
        catch (IOException | GeneralSecurityException exception) {
            return null;
        }
    }

    public static String getInformation(String url) {
        try {
            return ServerAPICommunicationUtil.invoke(GET, url, null);
        }
        catch (IOException | GeneralSecurityException exception) {
            return null;
        }
    }

    public static JsonObject getJsonInformation(String url, JsonObject jsonObject) {
        try {
            return new JsonParser().parse(ServerAPICommunicationUtil.invoke(GET, url, jsonObject.toString())).getAsJsonObject();
        }
        catch (IOException | GeneralSecurityException exception) {
            return null;
        }
    }

    public static JsonObject getJsonInformation(String url, String jsonData) {
        try {
            return new JsonParser().parse(ServerAPICommunicationUtil.invoke(GET, url, jsonData)).getAsJsonObject();
        }
        catch (IOException | GeneralSecurityException exception) {
            return null;
        }
    }

    public static JsonObject getJsonInformation(String url) {
        try {
            return new JsonParser().parse(ServerAPICommunicationUtil.invoke(GET, url, null)).getAsJsonObject();
        }
        catch (IOException | GeneralSecurityException exception) {
            return null;
        }
    }

    private static String sendAndReceiveData(HttpURLConnection uc, String sendingData) throws IOException {
        if (StringUtils.isNotEmpty((CharSequence)sendingData)) {
            Throwable throwable = null;
            Object var3_4 = null;
            try (DataOutputStream wr = new DataOutputStream(uc.getOutputStream());){
                wr.writeBytes(sendingData);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        String result = "";
        int statusCode = uc.getResponseCode();
        Throwable throwable = null;
        Object var5_9 = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(statusCode >= 400 ? uc.getErrorStream() : uc.getInputStream()));){
            String line;
            StringBuilder response = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                response.append(line);
                response.append('\r');
            }
            result = response.toString().trim();
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        return result;
    }

    public static HttpURLConnection createConnection(String method, String sUrl, Proxy proxy) throws IOException, GeneralSecurityException {
        URL url = new URL(sUrl);
        if (HTTP.equals(url.getProtocol())) {
            HttpURLConnection uc = null;
            uc = (HttpURLConnection)url.openConnection(proxy);
            uc.setRequestMethod(method);
            uc.setRequestProperty("Content-Type", "application/json");
            uc.setUseCaches(false);
            uc.setDoOutput(true);
            return uc;
        }
        SSLContext sc = SSLContext.getInstance(PROTOCOL);
        sc.init(null, ServerAPICommunicationUtil.getTrustManagers(), new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        HttpsURLConnection uc = null;
        uc = (HttpsURLConnection)url.openConnection(proxy);
        uc.setHostnameVerifier(ServerAPICommunicationUtil.getHostnameVerifier());
        uc.setRequestMethod(method);
        uc.setRequestProperty("Content-Type", "application/json");
        uc.setUseCaches(false);
        uc.setDoOutput(true);
        return uc;
    }

    private static TrustManager[] getTrustManagers() throws IOException {
        return new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
    }

    private static HostnameVerifier getHostnameVerifier() {
        return new HostnameVerifier(){

            @Override
            public boolean verify(String urlHostName, SSLSession session) {
                return true;
            }
        };
    }

    private static String invokeHubspotContact() throws Exception {
        HttpURLConnection connection = null;
        try {
            String result;
            connection = ServerAPICommunicationUtil.createConnection(GET, HUBSPOT_CONTACT_API, ApplicationProxyUtil.getAuthProxy());
            String string = result = ServerAPICommunicationUtil.sendAndReceiveData(connection, null);
            return string;
        }
        catch (Exception ex) {
            LogUtil.logError((Throwable)ex);
            throw ex;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private static HubSpot getHubsportContactApi() throws Exception {
        String json = ServerAPICommunicationUtil.invokeHubspotContact();
        return (HubSpot)JsonUtil.fromJson((String)json, HubSpot.class);
    }

    private class HubSpot {
        private String stagingUrl;
        private String productionUrl;

        private HubSpot() {
        }

        public String getProductionUrl() {
            return this.productionUrl;
        }

        public String getStagingUrl() {
            return this.stagingUrl;
        }
    }

    public static interface Response {
        public int getStatusCode();

        public String getResponseBody();
    }
}

