/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.feature;

import com.kms.katalon.application.utils.LicenseUtil;
import com.kms.katalon.feature.IFeatureService;
import com.kms.katalon.feature.KSEFeature;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class FeatureConfigurations
implements IFeatureService {
    public static int LIMITED_TEST_SUITES = 40;
    private Properties coreFeatures;
    private Properties customFeatures;
    private static final Map<KSEFeature, Boolean> coreFeaturesMap = new HashMap<KSEFeature, Boolean>(){
        {
            this.put(KSEFeature.SELF_HEALING, Boolean.TRUE);
            this.put(KSEFeature.WEB_LOCATOR_SETTINGS, Boolean.TRUE);
            this.put(KSEFeature.CUSTOM_WEB_SERVICE_METHOD, Boolean.TRUE);
            this.put(KSEFeature.CUSTOM_WEB_SERVICE_REQUEST_TIMEOUT, Boolean.TRUE);
            this.put(KSEFeature.CUSTOM_WEB_SERVICE_RESPONSE_SIZE_LIMIT, Boolean.TRUE);
            this.put(KSEFeature.ORACLE_EXTERNAL_DATA, Boolean.TRUE);
            this.put(KSEFeature.SQL_SERVER_EXTERNAL_DATA, Boolean.TRUE);
            this.put(KSEFeature.ADDTIONAL_TEST_DATA_SOURCE, Boolean.TRUE);
            this.put(KSEFeature.MULTIPLE_DATA_SOURCE_COMBINATION, Boolean.TRUE);
            this.put(KSEFeature.CHECKPOINT, Boolean.TRUE);
            this.put(KSEFeature.REPORT_HISTORY, Boolean.TRUE);
            this.put(KSEFeature.EXPORT_JUNIT_REPORT, Boolean.TRUE);
            this.put(KSEFeature.TEST_OBJECT_REFACTORING, Boolean.TRUE);
            this.put(KSEFeature.EXPORT_TEST_ARTIFACTS, Boolean.TRUE);
            this.put(KSEFeature.IMPORT_TEST_ARTIFACTS, Boolean.TRUE);
            this.put(KSEFeature.DYNAMIC_TEST_SUITE, Boolean.TRUE);
            this.put(KSEFeature.CONSOLE_LOG_CUSTOMIZATION, Boolean.TRUE);
            this.put(KSEFeature.DEBUG_MODE, Boolean.TRUE);
            this.put(KSEFeature.SOURCE_CODE_FOR_DEBUGGING, Boolean.FALSE);
            this.put(KSEFeature.DECOMPILE_CLASS_FILE, Boolean.FALSE);
            this.put(KSEFeature.CONFIGURE_USAGE_TRACKING, Boolean.TRUE);
            this.put(KSEFeature.CONFIGURE_RECEIVE_DYNAMIC_CONTENT_NOTIFICATIONS, Boolean.TRUE);
            this.put(KSEFeature.CONFIGURE_SHOW_START_PAGE_CONTENTS, Boolean.TRUE);
            this.put(KSEFeature.SSL_CLIENT_CERTIFICATE, Boolean.TRUE);
            this.put(KSEFeature.GIT_SSH, Boolean.TRUE);
            this.put(KSEFeature.PRIVATE_PLUGINS, Boolean.TRUE);
            this.put(KSEFeature.CREATE_GENERIC_PROJECT_TYPE, Boolean.TRUE);
            this.put(KSEFeature.OVERRIDE_TESTOPS_AUTHENTICATION, Boolean.TRUE);
            this.put(KSEFeature.RECORDER_RUN_FROM_SELECTED_STEP, Boolean.TRUE);
            this.put(KSEFeature.RECORDER_RUN_SELECTED_STEPS, Boolean.TRUE);
            this.put(KSEFeature.LAUNCH_ARGUMENTS_SETTINGS, Boolean.TRUE);
            this.put(KSEFeature.TEST_CASE_RUN_FROM_SELECTED_STEP, Boolean.TRUE);
            this.put(KSEFeature.TEST_CASE_DEBUG_FROM_SELECTED_STEP, Boolean.TRUE);
            this.put(KSEFeature.TEST_CASE_TOGGLE_STEP, Boolean.TRUE);
            this.put(KSEFeature.RERUN_IMMEDIATELY, Boolean.TRUE);
            this.put(KSEFeature.TEST_SUITE_COLLECTION_EXECUTION_EMAIL, Boolean.TRUE);
            this.put(KSEFeature.WINDOWS_NATIVE_RECORDER, Boolean.TRUE);
            this.put(KSEFeature.IMPORT_OPENAPI, Boolean.TRUE);
            this.put(KSEFeature.IMPORT_SELENIUM_IDE_V3, Boolean.FALSE);
            this.put(KSEFeature.FILTER_ALREADY_ADDED_TEST_CASES, Boolean.TRUE);
            this.put(KSEFeature.APPLITOOLS_PLUGIN, Boolean.TRUE);
            this.put(KSEFeature.EXCLUDE_BUILTIN_LIBRARIES, Boolean.TRUE);
            this.put(KSEFeature.IMPORT_EXPORT_DESIRED_CAPABILITIES, Boolean.TRUE);
            this.put(KSEFeature.TEST_CASE_DATA_BINDING, Boolean.TRUE);
            this.put(KSEFeature.NTLM_AUTHENTICATION, Boolean.TRUE);
            this.put(KSEFeature.AUTO_EXPORT_TEST_SUITE_COLLECTION_HTML, Boolean.TRUE);
            this.put(KSEFeature.IMPORT_CUSTOM_KEYWORD, Boolean.TRUE);
            this.put(KSEFeature.EXPORT_CUSTOM_KEYWORD, Boolean.TRUE);
            this.put(KSEFeature.UNLIMITED_TEST_SUITE_CREATIONS, Boolean.TRUE);
            this.put(KSEFeature.CUSTOM_KEYWORD, Boolean.TRUE);
            this.put(KSEFeature.HIDE_HOSTNAME, Boolean.TRUE);
        }
    };

    public Map<KSEFeature, Boolean> getCoreFeaturesMap() {
        return coreFeaturesMap;
    }

    public FeatureConfigurations() {
        this.loadFeatures();
    }

    protected void loadFeatures() {
        this.loadCoreFeatures();
        this.loadCustomFeatures();
    }

    protected void loadCoreFeatures() {
        if (this.coreFeatures == null) {
            this.coreFeatures = new Properties();
        }
        this.getCoreFeaturesMap().entrySet().stream().forEach(action -> this.coreFeatures.put(((KSEFeature)((Object)((Object)action.getKey()))).name(), ((Boolean)action.getValue()).toString()));
    }

    protected void loadCustomFeatures() {
        if (this.customFeatures == null) {
            this.customFeatures = new Properties();
        }
    }

    @Override
    public boolean canUse(KSEFeature feature) {
        return this.canUse(feature.name());
    }

    @Override
    public boolean canUse(String featureKey) {
        boolean isFreeFeature;
        boolean isCustomFeature = this.customFeatures.containsKey(featureKey);
        if (isCustomFeature && this.getBoolean(this.customFeatures, featureKey)) {
            return true;
        }
        boolean isValidFeature = this.coreFeatures.containsKey(featureKey);
        if (!isValidFeature) {
            return false;
        }
        boolean hasKSELicense = LicenseUtil.isNotFreeLicense();
        boolean isKSEFeature = this.getBoolean(this.coreFeatures, featureKey);
        boolean bl = isFreeFeature = !isKSEFeature;
        return isFreeFeature || isKSEFeature && hasKSELicense;
    }

    @Override
    public void enable(String customFeature) {
        boolean isValidCustomFeature;
        boolean bl = isValidCustomFeature = !this.coreFeatures.containsKey(customFeature);
        if (!isValidCustomFeature) {
            return;
        }
        this.customFeatures.setProperty(customFeature, Boolean.TRUE.toString());
    }

    @Override
    public void disable(String customFeature) {
        boolean isValidCustomFeature;
        boolean bl = isValidCustomFeature = !this.coreFeatures.containsKey(customFeature);
        if (!isValidCustomFeature) {
            return;
        }
        this.customFeatures.setProperty(customFeature, Boolean.FALSE.toString());
    }

    @Override
    public void clear() {
        this.customFeatures.clear();
    }

    private boolean getBoolean(Properties features, String featureKey) {
        return Boolean.valueOf(features.getProperty(featureKey));
    }
}

