/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testsuite.filters;

import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestCaseTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.TestCaseController;
import com.kms.katalon.controller.exception.ControllerException;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class AlreadyAddedTestCaseFilter {
    private Map<String, Boolean> alreadyAddedEntitiesCached = new HashMap<String, Boolean>();

    public int getResultSize() {
        return this.alreadyAddedEntitiesCached.size();
    }

    public Map<String, Boolean> getResult() {
        return this.alreadyAddedEntitiesCached;
    }

    public void filterElements(ITreeEntity[] entities, IProgressMonitor monitor) {
        ITreeEntity[] iTreeEntityArray = entities;
        int n = entities.length;
        int n2 = 0;
        while (n2 < n) {
            ITreeEntity treeEntity = iTreeEntityArray[n2];
            this.filterElement(treeEntity, monitor);
            ++n2;
        }
    }

    private boolean filterElement(Object element, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
        try {
            FolderEntity folderEntity;
            if (element instanceof FolderTreeEntity && (folderEntity = ((FolderTreeEntity)element).getObject()).getFolderType() == FolderEntity.FolderType.TESTCASE) {
                subMonitor.beginTask("", folderEntity.getChildrenEntities().size());
                boolean folderStatus = this.isFolderFullOfTestCasesAlreadyAddedToTestSuites(folderEntity, subMonitor);
                this.alreadyAddedEntitiesCached.put(folderEntity.getIdForDisplay(), new Boolean(folderStatus));
                return folderStatus;
            }
            if (element instanceof TestCaseTreeEntity) {
                TestCaseEntity tcEntity = ((TestCaseTreeEntity)element).getObject();
                boolean testCaseStatus = this.isTestCaseAlreadyAddedInTestSuites(tcEntity);
                this.alreadyAddedEntitiesCached.put(tcEntity.getIdForDisplay(), new Boolean(testCaseStatus));
                return testCaseStatus;
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
        return false;
    }

    private boolean isFolderFullOfTestCasesAlreadyAddedToTestSuites(FolderEntity folderEntity, SubMonitor subMonitor) throws ControllerException {
        boolean isNotFull = false;
        FolderController folderController = FolderController.getInstance();
        for (Object childObject : folderController.getChildren(folderEntity)) {
            boolean addedToTestSuites;
            SubMonitor subSubMonitor = subMonitor.split(1, 0);
            subSubMonitor.beginTask("Check " + folderEntity.getIdForDisplay() + "...", 1);
            if (childObject instanceof TestCaseEntity) {
                addedToTestSuites = this.isTestCaseAlreadyAddedInTestSuites((TestCaseEntity)childObject);
                if (!addedToTestSuites) {
                    isNotFull = true;
                }
                this.alreadyAddedEntitiesCached.put(((TestCaseEntity)childObject).getIdForDisplay(), new Boolean(addedToTestSuites));
                continue;
            }
            if (!(childObject instanceof FolderEntity)) continue;
            addedToTestSuites = this.isFolderFullOfTestCasesAlreadyAddedToTestSuites((FolderEntity)childObject, subMonitor);
            if (!addedToTestSuites) {
                isNotFull = true;
            }
            this.alreadyAddedEntitiesCached.put(((FolderEntity)childObject).getIdForDisplay(), new Boolean(addedToTestSuites));
        }
        return !isNotFull;
    }

    private boolean isTestCaseAlreadyAddedInTestSuites(TestCaseEntity tcEntity) {
        return TestCaseController.getInstance().getTestCaseReferences(tcEntity).size() > 0;
    }

    public boolean isEntityAlreadyAddedToTestSuites(String entityId) {
        return this.alreadyAddedEntitiesCached.getOrDefault(entityId, false);
    }

    public boolean isResultNotEmpty() {
        return this.getResultSize() > 0;
    }
}

