/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testsuite.handlers;

import com.kms.katalon.application.helper.UserProfileHelper;
import com.kms.katalon.application.userprofile.UserProfile;
import com.kms.katalon.application.utils.LicenseUtil;
import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.impl.constants.ComposerComponentsImplMessageConstants;
import com.kms.katalon.composer.components.impl.handler.KSEFeatureAccessHandler;
import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.TestSuiteTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.testsuite.constants.ComposerTestsuiteMessageConstants;
import com.kms.katalon.composer.testsuite.constants.StringConstants;
import com.kms.katalon.composer.testsuite.dialogs.NewTestSuiteDialog;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.TestSuiteController;
import com.kms.katalon.entity.dal.exception.FilePathTooLongException;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.feature.FeatureConfigurations;
import com.kms.katalon.feature.FeatureServiceConsumer;
import com.kms.katalon.feature.KSEFeature;
import com.kms.katalon.tracking.service.Trackings;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class NewTestSuiteHandler {
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private ESelectionService selectionService;
    private FolderTreeEntity testSuiteTreeRoot;
    private String newDefaultName = ComposerTestsuiteMessageConstants.HAND_DEFAULT_NAME_NEW_TEST_SUITE;
    private String getNameTestSuite = "";
    private int DEFAULT_NUM_RETRIES = 3;

    @CanExecute
    private boolean canExecute() {
        return ProjectController.getInstance().getCurrentProject() != null;
    }

    @Execute
    public void execute(@Named(value="activeShell") @Named(value="activeShell") Shell parentShell) {
        try {
            String suggestedName;
            NewTestSuiteDialog dialog;
            Object[] selectedObjects = (Object[])this.selectionService.getSelection("com.kms.katalon.composer.part.explorer");
            ITreeEntity parentTreeEntity = NewTestSuiteHandler.findParentTreeEntity(selectedObjects);
            if (parentTreeEntity == null) {
                if (this.testSuiteTreeRoot == null) {
                    return;
                }
                parentTreeEntity = this.testSuiteTreeRoot;
            }
            if (parentTreeEntity == null) {
                return;
            }
            FolderEntity parentFolderEntity = (FolderEntity)parentTreeEntity.getObject();
            TestSuiteController tsController = TestSuiteController.getInstance();
            if (parentFolderEntity.getFolderType() == FolderEntity.FolderType.TESTSUITE && !FeatureServiceConsumer.getServiceInstance().canUse(KSEFeature.UNLIMITED_TEST_SUITE_CREATIONS)) {
                try {
                    ProjectEntity currentProject = parentFolderEntity.getProject();
                    List tsList = tsController.getAllTestSuites(currentProject);
                    if (tsList.size() >= FeatureConfigurations.LIMITED_TEST_SUITES) {
                        String dialogTitle = ComposerComponentsImplMessageConstants.DIA_KSE_FEATURE_RESTRICT_UNLIMITED_TEST_SUITE_CREATIONS;
                        String dialogMessage = ComposerComponentsImplMessageConstants.MSG_KSE_FEATURE_RESTRICT_UNLIMITED_TEST_SUITE_CREATIONS;
                        KSEFeatureAccessHandler.handleUnauthorizedAccess((KSEFeature)KSEFeature.UNLIMITED_TEST_SUITE_CREATIONS, (String)dialogTitle, (String)dialogMessage);
                        return;
                    }
                }
                catch (Exception e) {
                    LoggerSingleton.logError((Throwable)e);
                    return;
                }
            }
            if ((dialog = new NewTestSuiteDialog(parentShell, parentFolderEntity, suggestedName = tsController.getAvailableTestSuiteName(parentFolderEntity, this.newDefaultName))).open() != 0) {
                return;
            }
            TestSuiteEntity testSuite = tsController.saveNewTestSuite((TestSuiteEntity)dialog.getEntity());
            if (LicenseUtil.isNotFreeLicense()) {
                testSuite.setRerunImmediately(true);
                testSuite.setNumberOfRerun(this.DEFAULT_NUM_RETRIES);
            }
            if (testSuite == null) {
                MessageDialog.openError((Shell)parentShell, (String)StringConstants.ERROR_TITLE, (String)ComposerTestsuiteMessageConstants.HAND_ERROR_MSG_UNABLE_TO_CREATE_TEST_SUITE);
                return;
            }
            Trackings.trackCreatingObject((String)"testSuite");
            UserProfile userProfile = UserProfileHelper.getCurrentProfile();
            userProfile.setDoneCreateFirstTestSuite(true);
            userProfile.addCompletedTour("TEST_PLANNING");
            UserProfileHelper.saveProfile((UserProfile)userProfile);
            this.eventBroker.send("EXPLORER/REFRESH_TREE_ENTITY", (Object)parentTreeEntity);
            this.eventBroker.post("EXPLORER/SET_SELECTED_ITEM", (Object)new TestSuiteTreeEntity(testSuite, parentTreeEntity));
            this.eventBroker.send("TESTSUITE/OPEN", (Object)testSuite);
            this.getNameTestSuite = testSuite.getId();
        }
        catch (FilePathTooLongException e) {
            MessageDialog.openError((Shell)parentShell, (String)StringConstants.ERROR_TITLE, (String)e.getMessage());
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            MessageDialog.openError((Shell)parentShell, (String)StringConstants.ERROR_TITLE, (String)ComposerTestsuiteMessageConstants.HAND_ERROR_MSG_UNABLE_TO_CREATE_TEST_SUITE);
        }
    }

    public static ITreeEntity findParentTreeEntity(Object[] selectedObjects) throws Exception {
        if (selectedObjects != null) {
            Object[] objectArray = selectedObjects;
            int n = selectedObjects.length;
            int n2 = 0;
            while (n2 < n) {
                Object entity = objectArray[n2];
                if (entity instanceof ITreeEntity) {
                    Object entityObject = ((ITreeEntity)entity).getObject();
                    if (entityObject instanceof FolderEntity) {
                        FolderEntity folder = (FolderEntity)entityObject;
                        if (folder.getFolderType() == FolderEntity.FolderType.TESTSUITE) {
                            return (ITreeEntity)entity;
                        }
                    } else if (entityObject instanceof TestSuiteEntity) {
                        return ((ITreeEntity)entity).getParent();
                    }
                }
                ++n2;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Inject
    @Optional
    private void catchTestSuiteFolderTreeEntitiesRoot(@UIEventTopic(value="EXPLORER/RELOAD_INPUT") List<Object> treeEntities) {
        try {
            for (Object o : treeEntities) {
                void folder;
                FolderEntity folderEntity;
                Object entityObject = ((ITreeEntity)o).getObject();
                Object object = entityObject;
                if (!(object instanceof FolderEntity) || (folderEntity = (FolderEntity)object) != (FolderEntity)object || folder.getFolderType() != FolderEntity.FolderType.TESTSUITE) continue;
                this.testSuiteTreeRoot = (FolderTreeEntity)o;
                return;
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    @Inject
    @Optional
    private void execute(@UIEventTopic(value="TESTSUITE/NEW") Object eventData) {
        if (!this.canExecute()) {
            return;
        }
        this.execute(Display.getCurrent().getActiveShell());
    }

    @Inject
    @Optional
    private void executeNewAndAdd(@UIEventTopic(value="TESTSUITE_TESTCASE/NEW") Object eventData) {
        if (!this.canExecute()) {
            return;
        }
        this.execute(Display.getCurrent().getActiveShell());
        TestCaseEntity testCase = (TestCaseEntity)eventData;
        EventBrokerSingleton.getInstance().getEventBroker().post("ADD_TESTCASE_TESTCASE", (Object)new Object[]{testCase, this.getNameTestSuite});
    }
}

