/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testsuite.parts;

import com.kms.katalon.composer.components.imp.listeners.TestDataTableDragListener;
import com.kms.katalon.composer.components.impl.control.CMenu;
import com.kms.katalon.composer.components.impl.control.ImageButton;
import com.kms.katalon.composer.components.impl.handler.KSEFeatureAccessHandler;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.impl.util.MenuUtils;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.components.util.ColumnViewerUtil;
import com.kms.katalon.composer.components.util.ComponentUtil;
import com.kms.katalon.composer.explorer.util.TransferTypeCollection;
import com.kms.katalon.composer.resources.image.ImageManager;
import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapper;
import com.kms.katalon.composer.testcase.handlers.OpenTestCaseHandler;
import com.kms.katalon.composer.testcase.model.InputValueType;
import com.kms.katalon.composer.testsuite.constants.ComposerTestsuiteMessageConstants;
import com.kms.katalon.composer.testsuite.constants.ImageConstants;
import com.kms.katalon.composer.testsuite.constants.StringConstants;
import com.kms.katalon.composer.testsuite.constants.ToolItemConstants;
import com.kms.katalon.composer.testsuite.listeners.TestDataTableDropListener;
import com.kms.katalon.composer.testsuite.listeners.TestDataToolItemListener;
import com.kms.katalon.composer.testsuite.parts.TestSuitePartTestCaseView;
import com.kms.katalon.composer.testsuite.providers.TestDataTableLabelProvider;
import com.kms.katalon.composer.testsuite.providers.VariableTableLabelProvider;
import com.kms.katalon.composer.testsuite.support.TestDataCombinationColumnEditingSupport;
import com.kms.katalon.composer.testsuite.support.TestDataIDColumnEditingSupport;
import com.kms.katalon.composer.testsuite.support.TestDataIterationColumnEditingSupport;
import com.kms.katalon.composer.testsuite.support.VariableTestDataLinkColumnEditingSupport;
import com.kms.katalon.composer.testsuite.support.VariableTypeEditingSupport;
import com.kms.katalon.composer.testsuite.support.VariableValueEditingSupport;
import com.kms.katalon.composer.testsuite.util.TestSuiteEntityUtil;
import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.controller.TestCaseController;
import com.kms.katalon.controller.TestDataController;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.link.TestCaseTestDataLink;
import com.kms.katalon.entity.link.TestSuiteTestCaseLink;
import com.kms.katalon.entity.link.VariableLink;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.testdata.DataFileEntity;
import com.kms.katalon.entity.variable.VariableEntity;
import com.kms.katalon.feature.FeatureServiceConsumer;
import com.kms.katalon.feature.IFeatureService;
import com.kms.katalon.feature.KSEFeature;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class TestSuitePartDataBindingView {
    private TestSuitePartTestCaseView parentView;
    private SashForm sashFormBindingView;
    private Composite compositeTestData;
    private ImageButton btnExpandCompositeTestData;
    private Label lblTestDataInformation;
    private Composite compositeTestDataDetails;
    private ToolBar testDataToolBar;
    private Composite compositeTestDataTreeTable;
    private TableViewer testDataTableViewer;
    private boolean isTestDataCompositeExpanded;
    private Composite compositeVariable;
    private TableViewer testCaseVariableTableViewer;
    private Callable<Boolean> enableWhenItemSelected;
    private Button radioDataBindingAtTestSuite;
    private Button radioDataBindingAtTestCase;
    private CMenu menu;
    private IFeatureService featureService = FeatureServiceConsumer.getServiceInstance();
    private Listener layoutTestDataCompositeListener = new Listener(){

        public void handleEvent(Event event) {
            TestSuitePartDataBindingView.this.isTestDataCompositeExpanded = !TestSuitePartDataBindingView.this.isTestDataCompositeExpanded;
            TestSuitePartDataBindingView.this.layoutTestDataComposite();
        }
    };
    private ToolItem setTypeToolItem;
    private ToolItem setTestDataToolItem;
    private Combo cbbSetTestName;
    private List<VariableEntity> variableList = new ArrayList<VariableEntity>();
    private Label lbSetTestNameIcon;
    private Label lbSetTestName;

    public TestSuitePartDataBindingView(TestSuitePartTestCaseView parentView) {
        this.parentView = parentView;
    }

    void createCompositeTestDataAndVariable(SashForm sashForm) {
        this.sashFormBindingView = new SashForm((Composite)sashForm, 512);
        this.sashFormBindingView.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.sashFormBindingView.setBackground(ColorUtil.getExtraLightGrayBackgroundColor());
        GridLayout glCompositeBindingChild = new GridLayout(1, false);
        glCompositeBindingChild.marginHeight = 0;
        glCompositeBindingChild.marginWidth = 0;
        this.sashFormBindingView.setLayout((Layout)glCompositeBindingChild);
        this.createCompositeSettings();
        this.createCompositeTestData();
        this.createCompositeVariableBinding();
        this.setTestDataTableSelection();
    }

    private void setTestDataTableSelection() {
        this.testDataTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TestSuitePartDataBindingView.this.createDynamicGotoTestDataMenu();
            }
        });
    }

    private void createCompositeSettings() {
        Composite compositeSettings = new Composite((Composite)this.sashFormBindingView, 0);
        compositeSettings.setLayoutData((Object)new GridData(4, 4, true, true, 4, 1));
        GridLayout glSettings = new GridLayout(1, false);
        glSettings.marginWidth = 2;
        glSettings.marginHeight = 5;
        compositeSettings.setLayout((Layout)glSettings);
        Label label = new Label(compositeSettings, 0);
        label.setFont(JFaceResources.getFontRegistry().getBold(""));
        label.setText(ComposerTestsuiteMessageConstants.LBL_SELECT_DATA_BINDING_OPTION);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 4, 1));
        Composite compositeFirstOption = new Composite(compositeSettings, 0);
        compositeFirstOption.setLayoutData((Object)new GridData(4, 4, true, false, 0, 0));
        GridLayout glFirstOption = new GridLayout(2, false);
        glFirstOption.marginWidth = 0;
        glFirstOption.horizontalSpacing = 0;
        compositeFirstOption.setLayout((Layout)glFirstOption);
        this.radioDataBindingAtTestCase = new Button(compositeFirstOption, 16);
        this.radioDataBindingAtTestCase.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!TestSuitePartDataBindingView.this.radioDataBindingAtTestCase.getSelection()) {
                    return;
                }
                if (TestSuitePartDataBindingView.this.getSelectedTestCaseLink() == null) {
                    TestSuitePartDataBindingView.this.showWarningSelectedTestCaseDialog();
                } else {
                    boolean canUseDdtAtTcLevel = TestSuitePartDataBindingView.this.featureService.canUse(KSEFeature.TEST_CASE_DATA_BINDING);
                    if (!canUseDdtAtTcLevel) {
                        KSEFeatureAccessHandler.handleUnauthorizedAccess((KSEFeature)KSEFeature.TEST_CASE_DATA_BINDING);
                        if (TestSuitePartDataBindingView.this.getSelectedTestCaseLink().isUsingDataBindingAtTestSuiteLevel()) {
                            TestSuitePartDataBindingView.this.radioDataBindingAtTestSuite.setSelection(true);
                            TestSuitePartDataBindingView.this.radioDataBindingAtTestCase.setSelection(false);
                        }
                        return;
                    }
                    TestSuitePartDataBindingView.this.getSelectedTestCaseLink().setUsingDataBindingAtTestSuiteLevel(false);
                    TestSuitePartDataBindingView.this.setDirty(true);
                    TestSuitePartDataBindingView.this.lockTestSuiteDataBinding(true);
                }
            }
        });
        this.radioDataBindingAtTestCase.setText(ComposerTestsuiteMessageConstants.BTN_OPTION_DATA_BINDING_AT_TC);
        Link link = new Link(compositeFirstOption, 0);
        link.setText(ComposerTestsuiteMessageConstants.TEST_CASE_LINK);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    TestCaseEntity testCaseEntity = TestCaseController.getInstance().getTestCaseByDisplayId(TestSuitePartDataBindingView.this.getSelectedTestCaseLink().getTestCaseId());
                    if (testCaseEntity != null) {
                        OpenTestCaseHandler.getInstance().openTestCaseInDataBindingView(testCaseEntity);
                    } else {
                        MessageDialog.openWarning(null, (String)StringConstants.WARN, (String)StringConstants.LIS_INFO_SELECT_A_TEST_CASE);
                    }
                }
                catch (Exception exception) {
                    MessageDialog.openWarning(null, (String)StringConstants.ERROR_TITLE, (String)ComposerTestsuiteMessageConstants.HAND_ERROR_MSG_CANNOT_OPEN_TEST_CASE);
                }
            }
        });
        this.radioDataBindingAtTestSuite = new Button(compositeSettings, 16);
        this.radioDataBindingAtTestSuite.setText(ComposerTestsuiteMessageConstants.BTN_OPTION_DATA_BINDING_AT_TS);
        this.radioDataBindingAtTestSuite.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!TestSuitePartDataBindingView.this.radioDataBindingAtTestSuite.getSelection()) {
                    return;
                }
                if (TestSuitePartDataBindingView.this.getSelectedTestCaseLink() == null) {
                    TestSuitePartDataBindingView.this.showWarningSelectedTestCaseDialog();
                } else {
                    TestSuitePartDataBindingView.this.getSelectedTestCaseLink().setUsingDataBindingAtTestSuiteLevel(true);
                    TestSuitePartDataBindingView.this.setDirty(true);
                    TestSuitePartDataBindingView.this.lockTestSuiteDataBinding(false);
                }
            }
        });
    }

    private void showWarningSelectedTestCaseDialog() {
        MessageDialog.openInformation(null, (String)StringConstants.INFORMATION, (String)StringConstants.LIS_INFO_SELECT_A_TEST_CASE);
        this.radioDataBindingAtTestCase.setSelection(false);
        this.radioDataBindingAtTestSuite.setSelection(false);
    }

    private void lockTestSuiteDataBinding(boolean isLock) {
        if (isLock) {
            this.radioDataBindingAtTestSuite.setSelection(false);
        } else {
            this.radioDataBindingAtTestCase.setSelection(false);
        }
        this.testDataToolBar.setEnabled(!isLock);
        this.setTypeToolItem.setEnabled(!isLock);
        this.setTestDataToolItem.setEnabled(!isLock);
        this.cbbSetTestName.setEnabled(!isLock);
        Image editImage = ImageConstants.IMG_16_EDIT;
        Image editDisabledImage = ImageConstants.IMG_16_EDIT_DISABLED;
        if (isLock) {
            this.lbSetTestNameIcon.setImage(editDisabledImage);
            this.lbSetTestName.setForeground(ColorUtil.getDisabledTextColor());
            ControlUtils.recursiveSetEnabled((Control)this.lbSetTestNameIcon.getParent(), (boolean)false);
        } else {
            this.lbSetTestNameIcon.setImage(editImage);
            this.lbSetTestName.setForeground(ColorUtil.getTextColor());
            ControlUtils.recursiveSetEnabled((Control)this.lbSetTestNameIcon.getParent(), (boolean)true);
        }
    }

    private void createCompositeVariableBinding() {
        this.compositeVariable = new Composite((Composite)this.sashFormBindingView, 0);
        this.compositeVariable.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        GridLayout gl_compositeVariable = new GridLayout(1, false);
        this.compositeVariable.setLayout((Layout)gl_compositeVariable);
        Composite compositeVariableHeader = new Composite(this.compositeVariable, 0);
        compositeVariableHeader.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        GridLayout glCompositeVariableHeader = new GridLayout(1, false);
        glCompositeVariableHeader.marginWidth = 0;
        glCompositeVariableHeader.marginHeight = 0;
        compositeVariableHeader.setLayout((Layout)glCompositeVariableHeader);
        Label lblCompositeVariableName = new Label(compositeVariableHeader, 0);
        lblCompositeVariableName.setFont(JFaceResources.getFontRegistry().getBold(""));
        lblCompositeVariableName.setText(ComposerTestsuiteMessageConstants.PA_LBL_VAR_BINDING);
        this.createVariableToolBarComposite(this.compositeVariable);
        Composite compositeVariableTable = new Composite(this.compositeVariable, 0);
        compositeVariableTable.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.testCaseVariableTableViewer = new TableViewer(compositeVariableTable, 67586);
        Table testCaseVariableTable = this.testCaseVariableTableViewer.getTable();
        testCaseVariableTable.setHeaderVisible(true);
        testCaseVariableTable.setLinesVisible(ControlUtils.shouldLineVisble((Display)testCaseVariableTable.getDisplay()));
        ColumnViewerUtil.setTableActivation((TableViewer)this.testCaseVariableTableViewer);
        TableViewerColumn variableNotificationColumnViewer = new TableViewerColumn(this.testCaseVariableTableViewer, 0);
        TableColumn tblclmnVariableNotification = variableNotificationColumnViewer.getColumn();
        tblclmnVariableNotification.setImage(ImageConstants.IMG_16_NOTIFICATION_HEADER);
        tblclmnVariableNotification.setToolTipText("Notification");
        TableViewerColumn variableOrderColumnViewer = new TableViewerColumn(this.testCaseVariableTableViewer, 0);
        TableColumn tblclmnVariableNo = variableOrderColumnViewer.getColumn();
        tblclmnVariableNo.setText(StringConstants.PA_TREE_VIEWER_COL_NO);
        TableViewerColumn variableNameColumnViewer = new TableViewerColumn(this.testCaseVariableTableViewer, 0);
        TableColumn tblclmnVariableName = variableNameColumnViewer.getColumn();
        tblclmnVariableName.setText(StringConstants.PA_TREE_VIEWER_COL_NAME);
        TableViewerColumn variableDefaultValueColumnViewer = new TableViewerColumn(this.testCaseVariableTableViewer, 0);
        TableColumn tblclmnVaribaleDefaultValue = variableDefaultValueColumnViewer.getColumn();
        tblclmnVaribaleDefaultValue.setText(ComposerTestsuiteMessageConstants.PA_TREE_VIEWER_COL_DEFAULT_VAL);
        TableViewerColumn variableTypeColumnViewer = new TableViewerColumn(this.testCaseVariableTableViewer, 0);
        TableColumn tblclmnVariableType = variableTypeColumnViewer.getColumn();
        tblclmnVariableType.setText(ComposerTestsuiteMessageConstants.PA_TREE_VIEWER_COL_TYPE);
        variableTypeColumnViewer.setEditingSupport((EditingSupport)new VariableTypeEditingSupport((ColumnViewer)this.testCaseVariableTableViewer, this));
        TableViewerColumn variableTestDataLinkIDViewerColumn = new TableViewerColumn(this.testCaseVariableTableViewer, 0);
        TableColumn tblclmnTestDataLinkId = variableTestDataLinkIDViewerColumn.getColumn();
        tblclmnTestDataLinkId.setText(StringConstants.PA_TREE_VIEWER_COL_TEST_DATA);
        variableTestDataLinkIDViewerColumn.setEditingSupport((EditingSupport)new VariableTestDataLinkColumnEditingSupport((ColumnViewer)this.testCaseVariableTableViewer, this));
        TableViewerColumn variableValueColumnViewer = new TableViewerColumn(this.testCaseVariableTableViewer, 0);
        TableColumn tblclmnVariableValue = variableValueColumnViewer.getColumn();
        tblclmnVariableValue.setText(StringConstants.PA_TREE_VIEWER_COL_VALUE);
        variableValueColumnViewer.setEditingSupport((EditingSupport)new VariableValueEditingSupport((ColumnViewer)this.testCaseVariableTableViewer, this));
        TableColumnLayout tableLayout = new TableColumnLayout();
        tableLayout.setColumnData((Widget)tblclmnVariableNotification, (ColumnLayoutData)new ColumnWeightData(0, 30));
        tableLayout.setColumnData((Widget)tblclmnVariableNo, (ColumnLayoutData)new ColumnWeightData(0, 40));
        tableLayout.setColumnData((Widget)tblclmnVariableName, (ColumnLayoutData)new ColumnWeightData(15, 90));
        tableLayout.setColumnData((Widget)tblclmnVaribaleDefaultValue, (ColumnLayoutData)new ColumnWeightData(0, 90));
        tableLayout.setColumnData((Widget)tblclmnVariableType, (ColumnLayoutData)new ColumnWeightData(0, 120));
        tableLayout.setColumnData((Widget)tblclmnTestDataLinkId, (ColumnLayoutData)new ColumnWeightData(30, 100));
        tableLayout.setColumnData((Widget)tblclmnVariableValue, (ColumnLayoutData)new ColumnWeightData(15, 90));
        compositeVariableTable.setLayout((Layout)tableLayout);
        this.testCaseVariableTableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        variableNotificationColumnViewer.setLabelProvider((CellLabelProvider)new VariableTableLabelProvider(0, this));
        variableOrderColumnViewer.setLabelProvider((CellLabelProvider)new VariableTableLabelProvider(1, this));
        variableNameColumnViewer.setLabelProvider((CellLabelProvider)new VariableTableLabelProvider(2, this));
        variableDefaultValueColumnViewer.setLabelProvider((CellLabelProvider)new VariableTableLabelProvider(3, this));
        variableTypeColumnViewer.setLabelProvider((CellLabelProvider)new VariableTableLabelProvider(4, this));
        variableTestDataLinkIDViewerColumn.setLabelProvider((CellLabelProvider)new VariableTableLabelProvider(5, this));
        variableValueColumnViewer.setLabelProvider((CellLabelProvider)new VariableTableLabelProvider(6, this));
        this.testCaseVariableTableViewer.getTable().setToolTipText("");
        this.testCaseVariableTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (TestSuitePartDataBindingView.this.handleLockDataBinding()) {
                    return;
                }
                ISelection selection = TestSuitePartDataBindingView.this.testCaseVariableTableViewer.getSelection();
                if (!(selection instanceof StructuredSelection)) {
                    return;
                }
                StructuredSelection structuredSelection = (StructuredSelection)selection;
                Object[] objectArray = structuredSelection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    VariableLink variableLink;
                    Object selectedObject = objectArray[n2];
                    if (selectedObject instanceof VariableLink && ((variableLink = (VariableLink)selectedObject).getType() == VariableLink.VariableType.DATA_COLUMN || variableLink.getType() == VariableLink.VariableType.DATA_COLUMN_INDEX)) break;
                    ++n2;
                }
            }
        });
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.testCaseVariableTableViewer, (int)2);
        this.sashFormBindingView.setWeights(new int[]{7, 14, 16});
        this.sashFormBindingView.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                TestSuitePartDataBindingView.this.setWeightSashForm();
            }
        });
    }

    private void setWeightSashForm() {
        int height = this.sashFormBindingView.getClientArea().height;
        int heightTestData = this.compositeTestData.getClientArea().height;
        heightTestData = !this.isTestDataCompositeExpanded ? 25 : 200;
        int heightVariableBinding = 0;
        if (height == 0) {
            height = 300;
        } else {
            heightVariableBinding = height - 100 - heightTestData;
        }
        try {
            this.sashFormBindingView.setWeights(new int[]{100, heightTestData, heightVariableBinding});
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    private void createVariableToolBarComposite(Composite parentComposite) {
        Composite variableToolBarComposite = new Composite(parentComposite, 0);
        variableToolBarComposite.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        GridLayout gl_compositeToolbar = new GridLayout(2, false);
        gl_compositeToolbar.marginWidth = 0;
        gl_compositeToolbar.marginHeight = 0;
        variableToolBarComposite.setLayout((Layout)gl_compositeToolbar);
        variableToolBarComposite.setBackground(ColorUtil.getCompositeBackgroundColor());
        ToolBarManager toolBarManager = new ToolBarManager(0x820000);
        ToolBar toolBar = toolBarManager.createControl(variableToolBarComposite);
        toolBar.setForeground(ColorUtil.getToolBarForegroundColor());
        Image editImage = ImageConstants.IMG_16_EDIT;
        Image editDisabledImage = ImageConstants.IMG_16_EDIT_DISABLED;
        this.setTypeToolItem = new ToolItem(toolBar, 4);
        this.setTypeToolItem.setText(ComposerTestsuiteMessageConstants.LBL_SET_TYPE);
        this.setTypeToolItem.setImage(editImage);
        this.setTypeToolItem.setDisabledImage(editDisabledImage);
        Menu setTypeMenu = new Menu((Control)this.setTypeToolItem.getParent().getShell());
        this.fillSetTypeToolItemMenu(setTypeMenu);
        this.setTypeToolItem.setData((Object)setTypeMenu);
        this.setTypeToolItem.addSelectionListener((SelectionListener)new ToolItemDropdownSelectionListener());
        this.setTestDataToolItem = new ToolItem(toolBar, 4);
        this.setTestDataToolItem.setText(ComposerTestsuiteMessageConstants.LBL_SET_TEST_DATA);
        this.setTestDataToolItem.setImage(editImage);
        this.setTestDataToolItem.setDisabledImage(editDisabledImage);
        Composite stnComposite = new Composite(variableToolBarComposite, 0);
        GridLayout stnLayout = new GridLayout(4, false);
        stnComposite.setLayout((Layout)stnLayout);
        this.lbSetTestNameIcon = new Label(stnComposite, 0);
        this.lbSetTestNameIcon.setImage(editImage);
        this.lbSetTestName = new Label(stnComposite, 0);
        this.lbSetTestName.setText(ComposerTestsuiteMessageConstants.LBL_SET_TEST_NAME);
        this.cbbSetTestName = new Combo(stnComposite, 12);
        GridData gdSetTestName = new GridData(16384, 0x1000000, false, false);
        gdSetTestName.verticalIndent = 2;
        gdSetTestName.widthHint = SystemUtils.IS_OS_WINDOWS ? ComponentUtil.applyZoom((int)90) : ComponentUtil.applyZoom((int)160);
        this.cbbSetTestName.setLayoutData((Object)gdSetTestName);
        this.cbbSetTestName.removeAll();
        this.cbbSetTestName.add(ComposerTestsuiteMessageConstants.CBB_SET_TEST_NAME_DEFAULT, 0);
        this.cbbSetTestName.select(0);
        Label lbToolTip = new Label(stnComposite, 0);
        lbToolTip.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        lbToolTip.setImage(ImageManager.getImage((String)"info_16.png"));
        lbToolTip.setToolTipText(ComposerTestsuiteMessageConstants.TOOLTIP_SET_TEST_NAME);
        this.cbbSetTestName.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TestSuiteTestCaseLink selectedTestCaseLink = TestSuitePartDataBindingView.this.getSelectedTestCaseLink();
                if (selectedTestCaseLink == null || TestSuitePartDataBindingView.this.variableList == null || TestSuitePartDataBindingView.this.variableList.isEmpty()) {
                    return;
                }
                if (TestSuitePartDataBindingView.this.cbbSetTestName.getSelectionIndex() == 0) {
                    selectedTestCaseLink.setIterationNameVariable(null);
                    TestSuitePartDataBindingView.this.setDirty(true);
                    return;
                }
                VariableEntity chosenVar = TestSuitePartDataBindingView.this.variableList.get(TestSuitePartDataBindingView.this.cbbSetTestName.getSelectionIndex() - 1);
                TestSuitePartDataBindingView.this.cbbSetTestName.setToolTipText(chosenVar.getName());
                selectedTestCaseLink.setIterationNameVariable(chosenVar);
                TestSuitePartDataBindingView.this.setDirty(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.setTestDataToolItem.addSelectionListener((SelectionListener)new ToolItemDropdownSelectionListener(this){

            @Override
            public void widgetSelected(SelectionEvent e) {
                if (!setTestDataToolItem.isEnabled()) {
                    return;
                }
                Menu setTestDataMenu = new Menu((Control)setTestDataToolItem.getParent().getShell());
                setTestDataToolItem.setData((Object)setTestDataMenu);
                this.fillSetTestDataToolItemMenu(setTestDataMenu);
                super.widgetSelected(e);
            }
        });
    }

    private void fillSetTypeToolItemMenu(Menu setTypeMenu) {
        Arrays.asList(VariableLink.VariableType.values()).stream().forEach(variableType -> {
            MenuItem menuItem = TestSuitePartDataBindingView.addNewMenuItem((SelectionListener)new SelectionAdapter((VariableLink.VariableType)variableType){
                private final /* synthetic */ VariableLink.VariableType val$variableType;
                {
                    this.val$variableType = variableType;
                }

                public void widgetSelected(SelectionEvent e) {
                    ISelection selection = TestSuitePartDataBindingView.this.testCaseVariableTableViewer.getSelection();
                    if (selection.isEmpty() || !(selection instanceof StructuredSelection)) {
                        return;
                    }
                    StructuredSelection structuredSelection = (StructuredSelection)selection;
                    new ArrayList(structuredSelection.toList()).stream().filter(VariableLink.class::isInstance).map(VariableLink.class::cast).filter(variableLink -> this.val$variableType != variableLink.getType()).forEach(variableLink -> {
                        switch (this.val$variableType) {
                            case DATA_COLUMN: 
                            case DATA_COLUMN_INDEX: {
                                variableLink.setType(this.val$variableType);
                                variableLink.setValue("");
                            }
                            case DEFAULT: {
                                variableLink.setTestDataLinkId("");
                                variableLink.setValue("");
                                break;
                            }
                            case SCRIPT_VARIABLE: {
                                variableLink.setTestDataLinkId("");
                                Object newValue = InputValueType.Null.newValue();
                                variableLink.setValue(((ASTNodeWrapper)newValue).getInputText());
                            }
                        }
                        variableLink.setType(this.val$variableType);
                        TestSuitePartDataBindingView.this.testCaseVariableTableViewer.update(variableLink, null);
                        TestSuitePartDataBindingView.this.setDirty(true);
                    });
                    TestSuitePartDataBindingView.this.testCaseVariableTableViewer.setSelection((ISelection)structuredSelection);
                }
            }, setTypeMenu, variableType.toString(), 8);
        });
    }

    private void fillSetTestDataToolItemMenu(Menu setTestDataMenu) {
        TestSuiteTestCaseLink testCaseLink = this.getSelectedTestCaseLink();
        if (testCaseLink == null || testCaseLink.getTestDataLinks() == null || testCaseLink.getTestDataLinks().isEmpty()) {
            return;
        }
        testCaseLink.getTestDataLinks().stream().forEach(testCaseTestDataLink -> {
            MenuItem menuItem = TestSuitePartDataBindingView.addNewMenuItem((SelectionListener)new SelectionAdapter((TestCaseTestDataLink)testCaseTestDataLink){
                private final /* synthetic */ TestCaseTestDataLink val$testCaseTestDataLink;
                {
                    this.val$testCaseTestDataLink = testCaseTestDataLink;
                }

                public void widgetSelected(SelectionEvent e) {
                    ISelection selection = TestSuitePartDataBindingView.this.testCaseVariableTableViewer.getSelection();
                    if (selection.isEmpty() || !(selection instanceof StructuredSelection)) {
                        return;
                    }
                    StructuredSelection structuredSelection = (StructuredSelection)selection;
                    new ArrayList(structuredSelection.toList()).stream().filter(VariableLink.class::isInstance).map(VariableLink.class::cast).filter(variableLink -> (variableLink.getType() == VariableLink.VariableType.DATA_COLUMN || variableLink.getType() == VariableLink.VariableType.DATA_COLUMN_INDEX) && !this.val$testCaseTestDataLink.getId().equals(variableLink.getTestDataLinkId())).forEach(variableLink -> {
                        variableLink.setTestDataLinkId(this.val$testCaseTestDataLink.getId());
                        variableLink.setValue("");
                        TestSuitePartDataBindingView.this.testCaseVariableTableViewer.update(variableLink, null);
                        TestSuitePartDataBindingView.this.setDirty(true);
                    });
                    TestSuitePartDataBindingView.this.testCaseVariableTableViewer.setSelection((ISelection)structuredSelection);
                }
            }, setTestDataMenu, testCaseTestDataLink.getTestDataId(), 8);
        });
    }

    private static MenuItem addNewMenuItem(SelectionListener selectionListener, Menu actionMenu, String text, int type) {
        MenuItem newMenuItem = new MenuItem(actionMenu, type);
        newMenuItem.setText(text);
        newMenuItem.addSelectionListener(selectionListener);
        return newMenuItem;
    }

    private void fillSetTestNameCombobox() {
        TestSuiteTestCaseLink testCaseLink = this.getSelectedTestCaseLink();
        if (testCaseLink == null) {
            return;
        }
        this.cbbSetTestName.removeAll();
        this.cbbSetTestName.add(ComposerTestsuiteMessageConstants.CBB_SET_TEST_NAME_DEFAULT, 0);
        try {
            TestCaseEntity testCaseEntity = TestCaseController.getInstance().getTestCaseByDisplayId(testCaseLink.getTestCaseId());
            if (this.variableList == null) {
                this.variableList = new ArrayList<VariableEntity>();
            }
            this.variableList.clear();
            for (VariableLink variableLink : this.getVariableLinks()) {
                VariableEntity variable = TestCaseController.getInstance().getVariable(testCaseEntity, variableLink.getVariableId());
                if (variable == null) continue;
                this.variableList.add(variable);
                String variableName = StringUtils.abbreviate((String)variable.getName(), (int)15);
                this.cbbSetTestName.add(variableName);
            }
            if (testCaseLink.getIterationNameVariable() != null && TestSuiteEntityUtil.indexOfIterationName(this.variableList, testCaseLink.getIterationNameVariable()) > -1) {
                int index = TestSuiteEntityUtil.indexOfIterationName(this.variableList, testCaseLink.getIterationNameVariable());
                this.cbbSetTestName.select(index + 1);
                this.cbbSetTestName.setToolTipText(this.variableList.get(index).getName());
            } else {
                this.cbbSetTestName.select(0);
                this.cbbSetTestName.setToolTipText("");
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private void createCompositeTestDataToolbar() {
        Composite compositeTestDataButton = new Composite(this.compositeTestDataDetails, 0);
        compositeTestDataButton.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        GridLayout glCompositeTestDataButton = new GridLayout(1, false);
        glCompositeTestDataButton.marginWidth = 0;
        glCompositeTestDataButton.marginHeight = 0;
        compositeTestDataButton.setLayout((Layout)glCompositeTestDataButton);
        this.testDataToolBar = new ToolBar(compositeTestDataButton, 0x820000);
        this.testDataToolBar.setForeground(ColorUtil.getToolBarForegroundColor());
        ToolItem tltmAddTestData = new ToolItem(this.testDataToolBar, 4);
        tltmAddTestData.setText(ToolItemConstants.ADD);
        tltmAddTestData.setToolTipText(ToolItemConstants.ADD);
        tltmAddTestData.setImage(ImageConstants.IMG_16_ADD);
        ToolItem tltmRemoveTestData = new ToolItem(this.testDataToolBar, 0);
        tltmRemoveTestData.setText(ToolItemConstants.REMOVE);
        tltmRemoveTestData.setToolTipText(ToolItemConstants.REMOVE);
        tltmRemoveTestData.setImage(ImageConstants.IMG_16_REMOVE);
        ToolItem tltmUpTestData = new ToolItem(this.testDataToolBar, 0);
        tltmUpTestData.setText(ToolItemConstants.UP);
        tltmUpTestData.setToolTipText(ToolItemConstants.UP);
        tltmUpTestData.setImage(ImageConstants.IMG_16_MOVE_UP);
        ToolItem tltmDownTestData = new ToolItem(this.testDataToolBar, 0);
        tltmDownTestData.setText(ToolItemConstants.DOWN);
        tltmDownTestData.setToolTipText(ToolItemConstants.DOWN);
        tltmDownTestData.setImage(ImageConstants.IMG_16_MOVE_DOWN);
        ToolItem tltmMapAllTestData = new ToolItem(this.testDataToolBar, 0);
        tltmMapAllTestData.setText(ToolItemConstants.MAPALL);
        tltmMapAllTestData.setToolTipText(ComposerTestsuiteMessageConstants.TOOLTIP_MAP_ALL);
        tltmMapAllTestData.setImage(ImageConstants.IMG_16_MAP_ALL);
    }

    private void createTestDataTreeTable() {
        this.compositeTestDataTreeTable = new Composite(this.compositeTestDataDetails, 0);
        this.compositeTestDataTreeTable.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.testDataTableViewer = new TableViewer(this.compositeTestDataTreeTable, 67586);
        Table testDataTable = this.testDataTableViewer.getTable();
        testDataTable.setLinesVisible(ControlUtils.shouldLineVisble((Display)testDataTable.getDisplay()));
        testDataTable.setHeaderVisible(true);
        ColumnViewerUtil.setTableActivation((TableViewer)this.testDataTableViewer);
        TableViewerColumn treeViewerColumnNotification = new TableViewerColumn(this.testDataTableViewer, 0);
        TableColumn trclmnNotification = treeViewerColumnNotification.getColumn();
        trclmnNotification.setImage(ImageConstants.IMG_16_NOTIFICATION_HEADER);
        trclmnNotification.setToolTipText(GlobalStringConstants.NOTIFICATION);
        TableViewerColumn treeViewerColumnNo = new TableViewerColumn(this.testDataTableViewer, 0);
        TableColumn trclmnNo = treeViewerColumnNo.getColumn();
        trclmnNo.setText(StringConstants.PA_TREE_VIEWER_COL_NO);
        TableViewerColumn testDataTableViewerColumnID = new TableViewerColumn(this.testDataTableViewer, 0);
        TableColumn tblclmnTestDataId = testDataTableViewerColumnID.getColumn();
        tblclmnTestDataId.setText(StringConstants.PA_TREE_VIEWER_COL_ID);
        testDataTableViewerColumnID.setEditingSupport((EditingSupport)new TestDataIDColumnEditingSupport((ColumnViewer)this.testDataTableViewer, this));
        TableViewerColumn testDataTableViewerColumnIteration = new TableViewerColumn(this.testDataTableViewer, 0);
        TableColumn tblclmnTestDataIteration = testDataTableViewerColumnIteration.getColumn();
        tblclmnTestDataIteration.setText(ComposerTestsuiteMessageConstants.PA_TREE_VIEWER_COL_DATA_ITERATION);
        testDataTableViewerColumnIteration.setEditingSupport((EditingSupport)new TestDataIterationColumnEditingSupport((ColumnViewer)this.testDataTableViewer, this));
        TableViewerColumn testDataTableViewerColumnCombination = new TableViewerColumn(this.testDataTableViewer, 0);
        TableColumn tblclmnCombination = testDataTableViewerColumnCombination.getColumn();
        tblclmnCombination.setText(ComposerTestsuiteMessageConstants.PA_TREE_VIEWER_COL_TYPE);
        testDataTableViewerColumnCombination.setEditingSupport((EditingSupport)new TestDataCombinationColumnEditingSupport((ColumnViewer)this.testDataTableViewer, this));
        TableColumnLayout treeLayout = new TableColumnLayout();
        treeLayout.setColumnData((Widget)trclmnNotification, (ColumnLayoutData)new ColumnWeightData(0, 30));
        treeLayout.setColumnData((Widget)trclmnNo, (ColumnLayoutData)new ColumnWeightData(0, 40));
        treeLayout.setColumnData((Widget)tblclmnTestDataId, (ColumnLayoutData)new ColumnWeightData(40, 200));
        treeLayout.setColumnData((Widget)tblclmnTestDataIteration, (ColumnLayoutData)new ColumnWeightData(15, 150));
        treeLayout.setColumnData((Widget)tblclmnCombination, (ColumnLayoutData)new ColumnWeightData(0, 80));
        this.compositeTestDataTreeTable.setLayout((Layout)treeLayout);
        this.testDataTableViewer.getTable().setToolTipText("");
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.testDataTableViewer, (int)2);
        this.testDataTableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        treeViewerColumnNotification.setLabelProvider((CellLabelProvider)new TestDataTableLabelProvider(0, this));
        treeViewerColumnNo.setLabelProvider((CellLabelProvider)new TestDataTableLabelProvider(1, this));
        testDataTableViewerColumnID.setLabelProvider((CellLabelProvider)new TestDataTableLabelProvider(2, this));
        testDataTableViewerColumnIteration.setLabelProvider((CellLabelProvider)new TestDataTableLabelProvider(3, this));
        testDataTableViewerColumnCombination.setLabelProvider((CellLabelProvider)new TestDataTableLabelProvider(4, this));
        this.hookDropTestDataEvent();
        this.hookDragTestDataEvent();
        this.createTestDataTableContextMenu(this.testDataTableViewer.getTable());
        this.setTestDataTableSelection();
        this.testDataTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TestSuitePartDataBindingView.this.handleLockDataBinding();
            }
        });
    }

    private boolean handleLockDataBinding() {
        if (this.getSelectedTestCaseLink() != null) {
            boolean isLock;
            boolean bl = isLock = !this.getSelectedTestCaseLink().isUsingDataBindingAtTestSuiteLevel();
            if (isLock) {
                MessageDialog.openInformation(null, (String)StringConstants.INFORMATION, (String)ComposerTestsuiteMessageConstants.WRN_SELECT_BINDING_AT_SUITE_TEST_CASE);
                this.testDataTableViewer.cancelEditing();
                return true;
            }
        }
        return false;
    }

    private void createTestDataTableContextMenu(Table table) {
        this.menu = new CMenu((Control)table, null);
        table.setMenu((Menu)this.menu);
        this.enableWhenItemSelected = new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return !TestSuitePartDataBindingView.this.testDataTableViewer.getSelection().isEmpty();
            }
        };
    }

    private void hookDropTestDataEvent() {
        DropTarget dt = new DropTarget((Control)this.testDataTableViewer.getTable(), 3);
        List treeEntityTransfers = TransferTypeCollection.getInstance().getTreeEntityTransfer();
        treeEntityTransfers.add(TextTransfer.getInstance());
        dt.setTransfer(treeEntityTransfers.toArray(new Transfer[treeEntityTransfers.size()]));
        dt.addDropListener((DropTargetListener)new TestDataTableDropListener(this.testDataTableViewer, this));
    }

    private void hookDragTestDataEvent() {
        int operations = 3;
        DragSource dragSource = new DragSource((Control)this.testDataTableViewer.getTable(), operations);
        dragSource.setTransfer(new Transfer[]{TextTransfer.getInstance()});
        dragSource.addDragListener((DragSourceListener)new TestDataTableDragListener(this.testDataTableViewer));
    }

    private void createCompositeTestData() {
        this.compositeTestData = new Composite((Composite)this.sashFormBindingView, 0);
        this.compositeTestData.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.compositeTestData.setBackground(ColorUtil.getCompositeBackgroundColor());
        GridLayout glCompositeTestData = new GridLayout(1, false);
        glCompositeTestData.marginWidth = 0;
        glCompositeTestData.marginHeight = 0;
        this.compositeTestData.setLayout((Layout)glCompositeTestData);
        Composite compositeTestDataHeader = new Composite(this.compositeTestData, 0);
        GridLayout glCompositeTestDataHeader = new GridLayout(3, false);
        glCompositeTestDataHeader.marginWidth = 0;
        glCompositeTestDataHeader.marginHeight = 0;
        compositeTestDataHeader.setLayout((Layout)glCompositeTestDataHeader);
        compositeTestDataHeader.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        compositeTestDataHeader.setCursor(compositeTestDataHeader.getDisplay().getSystemCursor(21));
        this.btnExpandCompositeTestData = new ImageButton(compositeTestDataHeader, 0);
        this.redrawBtnExpandCompositeTestData();
        this.lblTestDataInformation = new Label(compositeTestDataHeader, 0);
        this.lblTestDataInformation.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.lblTestDataInformation.setText(StringConstants.PA_LBL_TEST_DATA);
        this.lblTestDataInformation.setFont(JFaceResources.getFontRegistry().getBold(""));
        this.compositeTestDataDetails = new Composite(this.compositeTestData, 0);
        this.compositeTestDataDetails.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        GridLayout glCompositeTestDataDetails = new GridLayout(1, false);
        glCompositeTestDataDetails.marginHeight = 0;
        this.compositeTestDataDetails.setLayout((Layout)glCompositeTestDataDetails);
        this.createCompositeTestDataToolbar();
        this.createTestDataTreeTable();
    }

    private void redrawBtnExpandCompositeTestData() {
        if (this.isTestDataCompositeExpanded) {
            this.btnExpandCompositeTestData.setImage(ImageConstants.IMG_16_ARROW_DOWN);
        } else {
            this.btnExpandCompositeTestData.setImage(ImageConstants.IMG_16_ARROW);
        }
    }

    void layout() {
        this.layoutTestDataComposite();
    }

    private void layoutTestDataComposite() {
        Display.getDefault().timerExec(10, new Runnable(){

            @Override
            public void run() {
                TestSuitePartDataBindingView.this.setWeightSashForm();
                TestSuitePartDataBindingView.this.sashFormBindingView.layout(true, true);
                TestSuitePartDataBindingView.this.sashFormBindingView.redraw();
                TestSuitePartDataBindingView.this.redrawBtnExpandCompositeTestData();
            }
        });
    }

    void registerControlModifyListeners() {
        TestDataToolItemListener testDataToolItemListener = new TestDataToolItemListener(this.testDataTableViewer, this);
        ToolItem[] toolItemArray = this.testDataToolBar.getItems();
        int n = toolItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            ToolItem item = toolItemArray[n2];
            item.addSelectionListener((SelectionListener)testDataToolItemListener);
            ++n2;
        }
        this.btnExpandCompositeTestData.addListener(3, this.layoutTestDataCompositeListener);
        this.lblTestDataInformation.addListener(3, this.layoutTestDataCompositeListener);
    }

    void refreshTestSuiteAfterTestDataChanged(String oldTestDataId, String newTestDataId) {
        for (TestSuiteTestCaseLink testCaseLink : this.parentView.getTestSuite().getTestSuiteTestCaseLinks()) {
            for (TestCaseTestDataLink testDataLink : testCaseLink.getTestDataLinks()) {
                if (testDataLink.getTestDataId() == null || !testDataLink.getTestDataId().equals(oldTestDataId)) continue;
                testDataLink.setTestDataId(newTestDataId);
            }
            if (this.parentView.getSelectedTestCaseLink() == null || !this.getSelectedTestCaseLink().getTestCaseId().equals(testCaseLink.getTestCaseId())) continue;
            this.testDataTableViewer.cancelEditing();
            this.testCaseVariableTableViewer.cancelEditing();
            this.testDataTableViewer.refresh();
            this.testCaseVariableTableViewer.refresh();
        }
    }

    public TestSuiteTestCaseLink getSelectedTestCaseLink() {
        return this.parentView.getSelectedTestCaseLink();
    }

    public void setDirty(boolean dirty) {
        this.parentView.setDirty(dirty);
    }

    void updateSelectedTestCase(IStructuredSelection selection) {
        block7: {
            this.testCaseVariableTableViewer.cancelEditing();
            this.testCaseVariableTableViewer.getTable().clearAll();
            this.testDataTableViewer.cancelEditing();
            this.testDataTableViewer.getTable().clearAll();
            if (selection.size() == 1) {
                TestSuiteTestCaseLink testCaseLink = (TestSuiteTestCaseLink)selection.getFirstElement();
                this.testDataTableViewer.setInput((Object)testCaseLink.getTestDataLinks());
                if (testCaseLink.isUsingDataBindingAtTestSuiteLevel()) {
                    this.lockTestSuiteDataBinding(false);
                    this.radioDataBindingAtTestSuite.setSelection(true);
                } else {
                    this.lockTestSuiteDataBinding(true);
                    this.radioDataBindingAtTestCase.setSelection(true);
                }
                try {
                    if (TestCaseController.getInstance().getTestCaseByDisplayId(testCaseLink.getTestCaseId()) != null) {
                        this.testCaseVariableTableViewer.setInput((Object)testCaseLink.getVariableLinks());
                        this.fillSetTestNameCombobox();
                        break block7;
                    }
                    this.testCaseVariableTableViewer.setInput(null);
                }
                catch (Exception exception) {
                    this.testCaseVariableTableViewer.setInput(null);
                }
            } else {
                this.testDataTableViewer.setInput(null);
                this.testCaseVariableTableViewer.setInput(null);
                this.radioDataBindingAtTestSuite.setSelection(false);
                this.radioDataBindingAtTestCase.setSelection(false);
            }
        }
    }

    void initExpandedState() {
        this.isTestDataCompositeExpanded = true;
    }

    public List<VariableLink> getVariableLinks() {
        return (List)this.testCaseVariableTableViewer.getInput();
    }

    public void refreshVariableTable() {
        this.testCaseVariableTableViewer.refresh();
        this.fillSetTestNameCombobox();
    }

    public void refreshVariableLink(VariableLink link) {
        this.testCaseVariableTableViewer.update((Object)link, null);
    }

    private void createDynamicGotoTestDataMenu() {
        ControlUtils.removeOldOpenMenuItem((Menu)this.menu);
        IStructuredSelection selection = (IStructuredSelection)this.testDataTableViewer.getSelection();
        List<DataFileEntity> dataFileEntities = this.getListDataFileFromSelection(selection);
        SelectionAdapter openSubMenuSelected = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object source = e.getSource();
                if (!(source instanceof MenuItem)) {
                    return;
                }
                DataFileEntity dataFileEntity = TestSuitePartDataBindingView.this.getDataFileFromMenuItem((MenuItem)source);
                if (dataFileEntity != null) {
                    TestSuitePartDataBindingView.this.parentView.openAddedTestData(dataFileEntity);
                }
            }
        };
        if (dataFileEntities.size() == 1) {
            ControlUtils.createOpenMenuWhenSelectOnlyOne((CMenu)this.menu, (FileEntity)((FileEntity)dataFileEntities.get(0)), this.enableWhenItemSelected, (SelectionAdapter)openSubMenuSelected);
            return;
        }
        MenuUtils.createOpenTestArtifactsMenu(this.getMapFileEntityToSelectionAdapter(dataFileEntities, openSubMenuSelected), (Menu)this.menu);
    }

    private DataFileEntity getDataFileFromMenuItem(MenuItem selectedMenuItem) {
        DataFileEntity selectedTestData = null;
        if (selectedMenuItem.getData() instanceof DataFileEntity) {
            selectedTestData = (DataFileEntity)selectedMenuItem.getData();
        }
        return selectedTestData;
    }

    private List<DataFileEntity> getListDataFileFromSelection(IStructuredSelection selection) {
        ArrayList<DataFileEntity> fileEntities = new ArrayList<DataFileEntity>();
        TestDataController controller = TestDataController.getInstance();
        for (Object object : selection.toList()) {
            if (!(object instanceof TestCaseTestDataLink)) continue;
            try {
                fileEntities.add(controller.getTestDataByDisplayId(((TestCaseTestDataLink)object).getTestDataId()));
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
            }
        }
        return fileEntities;
    }

    private HashMap<FileEntity, SelectionAdapter> getMapFileEntityToSelectionAdapter(List<? extends FileEntity> fileEntities, SelectionAdapter openTestData) {
        HashMap<FileEntity, SelectionAdapter> map = new HashMap<FileEntity, SelectionAdapter>();
        for (FileEntity fileEntity : fileEntities) {
            if (!(fileEntity instanceof DataFileEntity)) continue;
            map.put(fileEntity, openTestData);
        }
        return map;
    }

    private class ToolItemDropdownSelectionListener
    extends SelectionAdapter {
        private ToolItemDropdownSelectionListener() {
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            Object item = selectionEvent.getSource();
            if (!(item instanceof ToolItem)) {
                return;
            }
            ToolItem toolItem = (ToolItem)item;
            if (!toolItem.isEnabled()) {
                return;
            }
            if (toolItem.getData() instanceof Menu) {
                Rectangle rect = toolItem.getBounds();
                Point pt = toolItem.getParent().toDisplay(new Point(rect.x, rect.y));
                Menu menu = (Menu)toolItem.getData();
                menu.setLocation(pt.x, pt.y + rect.height);
                menu.setVisible(true);
            }
        }
    }
}

