/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.testsuite.support;

import com.kms.katalon.composer.components.impl.support.TypeCheckedEditingSupport;
import com.kms.katalon.composer.testcase.groovy.ast.ASTNodeWrapper;
import com.kms.katalon.composer.testcase.model.InputValueType;
import com.kms.katalon.composer.testsuite.parts.TestSuitePartDataBindingView;
import com.kms.katalon.entity.link.VariableLink;
import java.util.List;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class VariableTypeEditingSupport
extends TypeCheckedEditingSupport<VariableLink> {
    private static final List<String> variableTypes = VariableLink.VariableType.getValueStrings();
    private TestSuitePartDataBindingView mpart;

    public VariableTypeEditingSupport(ColumnViewer viewer, TestSuitePartDataBindingView mpart) {
        super(viewer);
        this.mpart = mpart;
    }

    protected Class<VariableLink> getElementType() {
        return VariableLink.class;
    }

    protected CellEditor getCellEditorByElement(VariableLink element) {
        return new ComboBoxCellEditor(this.getComposite(), variableTypes.toArray(new String[0]));
    }

    protected boolean canEditElement(VariableLink element) {
        return true;
    }

    protected Object getElementValue(VariableLink element) {
        return variableTypes.indexOf(element.getType().toString());
    }

    protected void setElementValue(VariableLink variableLink, Object value) {
        if (!(value instanceof Integer)) {
            return;
        }
        int selectedIndex = (Integer)value;
        if (selectedIndex < 0) {
            return;
        }
        VariableLink.VariableType variableType = VariableLink.VariableType.fromValue((String)variableTypes.get(selectedIndex));
        if (variableType == variableLink.getType()) {
            return;
        }
        switch (variableType) {
            case DATA_COLUMN: 
            case DATA_COLUMN_INDEX: {
                variableLink.setType(variableType);
                variableLink.setValue("");
            }
            case DEFAULT: {
                variableLink.setTestDataLinkId("");
                variableLink.setValue("");
                break;
            }
            case SCRIPT_VARIABLE: {
                variableLink.setTestDataLinkId("");
                Object newValue = InputValueType.Null.newValue();
                variableLink.setValue(((ASTNodeWrapper)newValue).getInputText());
            }
        }
        variableLink.setType(variableType);
        this.getViewer().update((Object)variableLink, null);
        this.getViewer().setSelection((ISelection)new StructuredSelection((Object)variableLink));
        this.mpart.setDirty(true);
    }
}

