/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.execution.collection.dialog;

import com.kms.katalon.composer.components.impl.dialogs.AbstractDialog;
import com.kms.katalon.composer.execution.collection.dialog.TestExecutionItemLabelProvider;
import com.kms.katalon.composer.execution.collection.dialog.TestExecutionItemTreeContentProvider;
import com.kms.katalon.composer.execution.constants.ComposerExecutionMessageConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.testsuite.RunConfigurationDescription;
import com.kms.katalon.execution.collection.collector.TestExecutionGroupCollector;
import com.kms.katalon.execution.collection.provider.TestExecutionConfigurationProvider;
import com.kms.katalon.execution.collection.provider.TestExecutionGroup;
import java.util.ArrayList;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeColumn;

public class RunConfigurationSelectionDialog
extends AbstractDialog {
    private TreeViewer treeViewer;
    private RunConfigurationDescription testRunConfigurationEntry;

    public RunConfigurationSelectionDialog(Shell parentShell, RunConfigurationDescription preConfiguration) {
        super(parentShell);
        this.testRunConfigurationEntry = preConfiguration;
    }

    protected void registerControlModifyListeners() {
        this.treeViewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!(event.getSelection() instanceof StructuredSelection)) {
                    return;
                }
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                if (!(selection.getFirstElement() instanceof TestExecutionConfigurationProvider)) {
                    RunConfigurationSelectionDialog.this.getButton(0).setEnabled(false);
                    RunConfigurationSelectionDialog.this.testRunConfigurationEntry = null;
                    return;
                }
                RunConfigurationSelectionDialog.this.getButton(0).setEnabled(true);
                RunConfigurationSelectionDialog.this.testRunConfigurationEntry = ((TestExecutionConfigurationProvider)selection.getFirstElement()).toConfigurationEntity(RunConfigurationSelectionDialog.this.testRunConfigurationEntry);
            }
        });
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                if (selection.getFirstElement() instanceof TestExecutionConfigurationProvider) {
                    RunConfigurationSelectionDialog.this.okPressed();
                }
            }
        });
    }

    protected void setInput() {
        ArrayList<TestExecutionGroup> groups = new ArrayList<TestExecutionGroup>();
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        TestExecutionGroup[] testExecutionGroupArray = TestExecutionGroupCollector.getInstance().getGroupAsArray();
        int n = testExecutionGroupArray.length;
        int n2 = 0;
        while (n2 < n) {
            TestExecutionGroup grp = testExecutionGroupArray[n2];
            if (grp.shouldBeDisplayed(project)) {
                groups.add(grp);
            }
            ++n2;
        }
        this.treeViewer.setInput((Object)groups.toArray(new TestExecutionGroup[groups.size()]));
        this.treeViewer.expandAll();
        this.initializeBounds();
        if (this.testRunConfigurationEntry == null) {
            return;
        }
        TestExecutionGroup group = TestExecutionGroupCollector.getInstance().getGroup(this.testRunConfigurationEntry.getGroupName());
        TestExecutionConfigurationProvider executionProvider = TestExecutionGroupCollector.getInstance().getExecutionProvider(this.testRunConfigurationEntry);
        if (group == null || executionProvider == null) {
            return;
        }
        TreePath treePath = new TreePath(new Object[]{group, executionProvider});
        this.treeViewer.setSelection((ISelection)new TreeSelection(treePath));
    }

    protected Point getInitialSize() {
        return new Point(400, 400);
    }

    protected Control createDialogContainer(Composite parent) {
        this.treeViewer = new TreeViewer(parent, 2048);
        TreeViewerColumn treeViewerColumn = new TreeViewerColumn(this.treeViewer, 0);
        TreeColumn trclmnRunConfiguration = treeViewerColumn.getColumn();
        trclmnRunConfiguration.setWidth(300);
        this.treeViewer.setContentProvider((IContentProvider)new TestExecutionItemTreeContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new TestExecutionItemLabelProvider());
        return this.treeViewer.getTree();
    }

    public String getDialogTitle() {
        return ComposerExecutionMessageConstants.DIA_TITLE_RUN_CONFIG_SELECTION;
    }

    public RunConfigurationDescription getSelectedConfiguration() {
        return this.testRunConfigurationEntry;
    }
}

