/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.execution.constants;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeMap;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;

public class ProblemMarkerConstants {
    public static List<IMarker> findErrorMarkers(IProject project) throws CoreException {
        return ProblemMarkerConstants.findMarkers(project, 2);
    }

    public static List<IMarker> findMarkers(IProject project, int targetSeverity) throws CoreException {
        return ProblemMarkerConstants.findMarkers(project, targetSeverity, null);
    }

    private static List<IMarker> findMarkers(IProject project, int targetSeverity, String withAttribute) throws CoreException {
        TreeMap<IMarker, IMarker> errors = new TreeMap<IMarker, IMarker>(new Comparator<IMarker>(){

            @Override
            public int compare(IMarker o1, IMarker o2) {
                int lineNumber2;
                int lineNumber1 = o1.getAttribute("lineNumber", -1);
                if (lineNumber1 < (lineNumber2 = o2.getAttribute("lineNumber", -1))) {
                    return -1;
                }
                if (lineNumber1 > lineNumber2) {
                    return 1;
                }
                String message1 = o1.getAttribute("message", "");
                String message2 = o2.getAttribute("message", "");
                return message1.compareTo(message2);
            }
        });
        IMarker[] iMarkerArray = project.findMarkers(null, true, 2);
        int n = iMarkerArray.length;
        int n2 = 0;
        while (n2 < n) {
            String attribute;
            IMarker marker = iMarkerArray[n2];
            int severity = marker.getAttribute("severity", 0);
            if (severity == targetSeverity && (withAttribute == null || (attribute = marker.getAttribute(withAttribute, null)) != null)) {
                errors.put(marker, marker);
            }
            ++n2;
        }
        ArrayList<IMarker> result = new ArrayList<IMarker>();
        result.addAll(errors.keySet());
        return result;
    }
}

