/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.execution.dialog;

import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.handler.KSEFeatureAccessHandler;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.execution.components.DriverPreferenceComposite;
import com.kms.katalon.composer.execution.constants.ComposerExecutionMessageConstants;
import com.kms.katalon.composer.execution.constants.StringConstants;
import com.kms.katalon.composer.execution.dialog.ImportDesiredCapabilitiesDialog;
import com.kms.katalon.execution.configuration.IDriverConnector;
import com.kms.katalon.feature.FeatureServiceConsumer;
import com.kms.katalon.feature.IFeatureService;
import com.kms.katalon.feature.KSEFeature;
import java.text.MessageFormat;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public abstract class DriverConnectorBuilderDialog
extends Dialog {
    private Button btnImport;
    private Button btnExport;
    protected DriverPreferenceComposite driverPreferenceComposite;

    public DriverConnectorBuilderDialog(Shell parentShell) {
        super(parentShell);
    }

    public abstract IDriverConnector getResult();

    protected Point getInitialSize() {
        return new Point(700, 500);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(StringConstants.DIA_DRIVER_CONNECTOR_BUILDER);
    }

    public void createButtonsForButtonBar(Composite parent) {
        GridLayout parentLayout = (GridLayout)parent.getLayout();
        parentLayout.numColumns += 2;
        this.btnImport = new Button(parent, 0x1000000);
        this.btnImport.setText(ComposerExecutionMessageConstants.BTN_IMPORT);
        this.setButtonLayoutData(this.btnImport);
        this.btnExport = new Button(parent, 0x1000000);
        this.btnExport.setText(ComposerExecutionMessageConstants.BTN_EXPORT);
        this.setButtonLayoutData(this.btnExport);
        super.createButtonsForButtonBar(parent);
        this.addControlListeners();
    }

    private void addControlListeners() {
        this.btnImport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!DriverConnectorBuilderDialog.this.canUseImportExportDesiredCapabilities()) {
                    KSEFeatureAccessHandler.handleUnauthorizedAccess((KSEFeature)KSEFeature.IMPORT_EXPORT_DESIRED_CAPABILITIES);
                    return;
                }
                ImportDesiredCapabilitiesDialog importDialog = new ImportDesiredCapabilitiesDialog(DriverConnectorBuilderDialog.this.getShell());
                if (importDialog.open() == 0) {
                    DriverConnectorBuilderDialog.this.importPropertiesFromFile(importDialog.getFilePath(), importDialog.isOverridingExistingProperties());
                }
            }
        });
        this.btnExport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!DriverConnectorBuilderDialog.this.canUseImportExportDesiredCapabilities()) {
                    KSEFeatureAccessHandler.handleUnauthorizedAccess((KSEFeature)KSEFeature.IMPORT_EXPORT_DESIRED_CAPABILITIES);
                    return;
                }
                FileDialog exportFileDialog = new FileDialog(DriverConnectorBuilderDialog.this.getShell(), 8192);
                exportFileDialog.setFilterNames(StringConstants.IMPORT_EXPORT_DESIRED_CAPABILITIES_FILTER_NAMES);
                exportFileDialog.setFilterExtensions(StringConstants.IMPORT_EXPORT_DESIRED_CAPABILITIES_FILTER_EXTS);
                exportFileDialog.setOverwrite(true);
                exportFileDialog.setFileName(DriverConnectorBuilderDialog.this.generateDefaultExportFileName());
                String filePath = exportFileDialog.open();
                if (filePath != null) {
                    DriverConnectorBuilderDialog.this.exportPropertiesToFile(filePath);
                }
            }
        });
    }

    protected void importPropertiesFromFile(String importFilePath, boolean isOverridingExistingProperties) {
        try {
            this.getResult().importConfigProperties(importFilePath, isOverridingExistingProperties);
            this.driverPreferenceComposite.updateInputToUI();
        }
        catch (Exception exception) {
            LoggerSingleton.logError((Throwable)exception);
            MultiStatusErrorDialog.showErrorDialog((Throwable)exception, (String)MessageFormat.format(ComposerExecutionMessageConstants.WARN_CANNOT_IMPORT_DESIRED_CAPABILITIES, importFilePath), (String)exception.getMessage());
        }
    }

    protected void exportPropertiesToFile(String exportFilePath) {
        try {
            this.getResult().exportConfigProperties(exportFilePath);
        }
        catch (Exception exception) {
            LoggerSingleton.logError((Throwable)exception);
            MultiStatusErrorDialog.showErrorDialog((Throwable)exception, (String)MessageFormat.format(ComposerExecutionMessageConstants.WARN_CANNOT_EXPORT_DESIRED_CAPABILITIES, exportFilePath), (String)exception.getMessage());
        }
    }

    protected String generateDefaultExportFileName() {
        String driverTypeName = this.getResult().getDriverType().getName().toLowerCase();
        driverTypeName = driverTypeName.substring(0, driverTypeName.indexOf("_driver"));
        return String.valueOf(driverTypeName) + "_caps.json";
    }

    private boolean canUseImportExportDesiredCapabilities() {
        IFeatureService featureService = FeatureServiceConsumer.getServiceInstance();
        return featureService.canUse(KSEFeature.IMPORT_EXPORT_DESIRED_CAPABILITIES);
    }
}

