/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.execution.dialog;

import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.execution.constants.StringConstants;
import com.kms.katalon.core.logging.XmlLogRecord;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class LogPropertyDialog
extends Dialog {
    private XmlLogRecord record;
    private boolean isOpen = false;

    public LogPropertyDialog(Shell parentShell, XmlLogRecord record) {
        super(parentShell);
        this.record = record;
    }

    public int open() {
        this.isOpen = true;
        return super.open();
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout glContainer = new GridLayout(1, false);
        glContainer.marginWidth = 0;
        container.setLayout((Layout)glContainer);
        Composite mainComposite = new Composite(container, 0);
        mainComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        GridLayout glMainComposite = new GridLayout(2, false);
        glMainComposite.marginWidth = 10;
        glMainComposite.horizontalSpacing = 15;
        mainComposite.setLayout((Layout)glMainComposite);
        Label lblRecordTime = new Label(mainComposite, 0);
        lblRecordTime.setText(StringConstants.DIA_LBL_TIME);
        ControlUtils.setFontToBeBold((Control)lblRecordTime);
        StyledText txtRecordTime = new StyledText(mainComposite, 2056);
        GridData gdTxtRecordTime = new GridData(4, 0x1000000, true, false, 1, 1);
        gdTxtRecordTime.heightHint = 18;
        txtRecordTime.setLayoutData((Object)gdTxtRecordTime);
        txtRecordTime.setText(this.record.getLogTimeString());
        Label lblLevel = new Label(mainComposite, 0);
        lblLevel.setText(StringConstants.DIA_LBL_LEVEL);
        ControlUtils.setFontToBeBold((Control)lblLevel);
        StyledText txtLevel = new StyledText(mainComposite, 2056);
        GridData gdTxtLevel = new GridData(4, 0x1000000, false, false, 1, 1);
        gdTxtLevel.heightHint = 18;
        txtLevel.setLayoutData((Object)gdTxtLevel);
        txtLevel.setText(this.record.getLevel().toString());
        Label lblMessage = new Label(mainComposite, 0);
        lblMessage.setLayoutData((Object)new GridData(131072, 128, false, false, 1, 1));
        lblMessage.setText(StringConstants.DIA_LBL_MESSAGE);
        ControlUtils.setFontToBeBold((Control)lblMessage);
        StyledText txtRecordMessage = new StyledText(mainComposite, 2634);
        txtRecordMessage.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        txtRecordMessage.setText(this.record.getMessage());
        Label label = new Label(container, 258);
        label.setLayoutData((Object)new GridData(4, 1024, true, false, 1, 1));
        return container;
    }

    protected void setShellStyle(int arg0) {
        super.setShellStyle(112);
    }

    public boolean close() {
        this.isOpen = false;
        return super.close();
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    protected Point getInitialSize() {
        return new Point(500, 400);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(StringConstants.DIA_TITLE_LOG_PROPERTIES);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }
}

