/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.execution.handlers;

import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.helpers.DialogBuilder;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.util.ComponentUtil;
import com.kms.katalon.composer.execution.constants.ComposerExecutionMessageConstants;
import com.kms.katalon.composer.execution.exceptions.JobCancelException;
import com.kms.katalon.constants.DocumentationMessageConstants;
import com.kms.katalon.constants.GlobalMessageConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.Entity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.integration.analytics.entity.TestOpsUsage;
import com.kms.katalon.integration.analytics.exceptions.AnalyticsApiException;
import com.kms.katalon.integration.analytics.helpers.TestOpsUsageHelper;
import com.kms.katalon.integration.analytics.providers.TestOpsService;
import com.kms.katalon.integration.analytics.setting.AnalyticsSettingStore;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;

public class CheckingTestOpsUsageHandler {
    public boolean execute(Entity targetEntity) throws Exception {
        return this.execute(targetEntity, null);
    }

    public boolean execute(Entity targetEntity, final CheckingCallback callback) throws Exception {
        boolean executeAsync = callback != null;
        final boolean[] result = new boolean[1];
        final Exception[] lastError = new Exception[1];
        if (!(targetEntity instanceof TestCaseEntity)) {
            Job job = new Job(ComposerExecutionMessageConstants.MSG_CHECKING_TESTOPS_QUOTA){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        monitor.beginTask(ComposerExecutionMessageConstants.MSG_CHECKING_TESTOPS_QUOTA, 3);
                        monitor.worked(1);
                        result[0] = CheckingTestOpsUsageHandler.this.checkQuotaWithRetry(monitor);
                        monitor.done();
                        return Status.OK_STATUS;
                    }
                    catch (JobCancelException jobCancelException) {
                        result[0] = false;
                        return Status.CANCEL_STATUS;
                    }
                    catch (Exception error) {
                        UISynchronizeService.syncExec(() -> MultiStatusErrorDialog.showErrorDialog((Throwable)error, (String)ComposerExecutionMessageConstants.MSG_UNABLE_TO_CHECK_TESTOPS_QUOTA, (String)error.getMessage()));
                        result[0] = false;
                        lastError[0] = error;
                        return Status.CANCEL_STATUS;
                    }
                }
            };
            job.setUser(true);
            job.schedule();
            if (executeAsync) {
                job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                    public void done(IJobChangeEvent event) {
                        try {
                            callback.call(result[0]);
                        }
                        catch (Exception error) {
                            lastError[0] = error;
                        }
                    }
                });
            } else {
                job.join();
            }
        } else {
            result[0] = true;
            if (executeAsync) {
                callback.call(result[0]);
            }
        }
        return result[0];
    }

    private boolean checkQuotaWithRetry(IProgressMonitor monitor) throws JobCancelException, AnalyticsApiException, URISyntaxException, IOException, GeneralSecurityException {
        return this.checkQuotaWithRetry(monitor, 3);
    }

    private boolean checkQuotaWithRetry(IProgressMonitor monitor, int retryTimes) throws JobCancelException, AnalyticsApiException, URISyntaxException, IOException, GeneralSecurityException {
        int counter = 0;
        AnalyticsApiException lastError = null;
        while (counter++ < retryTimes) {
            try {
                return this.doCheckQuota();
            }
            catch (AnalyticsApiException error) {
                lastError = error;
                monitor.worked(1);
                this.validateJobProgressMonitor(monitor);
            }
        }
        throw lastError;
    }

    private boolean doCheckQuota() throws AnalyticsApiException, URISyntaxException, IOException, GeneralSecurityException {
        AnalyticsSettingStore analyticsSettingStore = new AnalyticsSettingStore(ProjectController.getInstance().getCurrentProject().getFolderLocation());
        Long orgId = analyticsSettingStore.getOrganization().getId();
        TestOpsUsage usage = TestOpsService.getInstance().getUserUsage(orgId);
        if (TestOpsUsageHelper.reachSoftLimit((TestOpsUsage)usage)) {
            UISynchronizeService.syncExec(() -> new DialogBuilder().warning().message(ComposerExecutionMessageConstants.MSG_REACH_SOFT_LIMIT).button(buttonBuilder -> buttonBuilder.text(GlobalMessageConstants.CONTINUE).closeButton()).button(buttonBuilder -> buttonBuilder.text(GlobalMessageConstants.UPGRADE_NOW).onClick(event -> ComponentUtil.triggerLink((String)DocumentationMessageConstants.KATALON_PRICING_PAGE)).defaultButton()).build().open());
        }
        if (TestOpsUsageHelper.reachHardLimit((TestOpsUsage)usage)) {
            UISynchronizeService.syncExec(() -> new DialogBuilder().error().message(ComposerExecutionMessageConstants.MSG_REACH_HARD_LIMIT).button(buttonBuilder -> buttonBuilder.text(GlobalMessageConstants.ACKNOWLEDGE).closeButton()).button(buttonBuilder -> buttonBuilder.text(GlobalMessageConstants.UPGRADE_NOW).onClick(event -> ComponentUtil.triggerLink((String)DocumentationMessageConstants.KATALON_PRICING_PAGE)).defaultButton()).build().open());
            return false;
        }
        return true;
    }

    void validateJobProgressMonitor(IProgressMonitor monitor) throws JobCancelException {
        if (monitor.isCanceled()) {
            throw new JobCancelException();
        }
    }

    public static interface CheckingCallback {
        public void call(boolean var1) throws Exception;
    }
}

