/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.execution.handlers;

import com.kms.katalon.composer.execution.ExecutionProfileManager;
import com.kms.katalon.composer.execution.handlers.AbstractExecutionHandler;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.execution.configuration.AbstractRunConfiguration;
import com.kms.katalon.execution.configuration.ExistingRunConfiguration;
import com.kms.katalon.execution.configuration.IRunConfiguration;
import com.kms.katalon.execution.configuration.impl.DefaultExecutionSetting;
import com.kms.katalon.execution.exception.ExecutionException;
import com.kms.katalon.execution.launcher.model.LaunchMode;
import java.io.IOException;
import org.apache.commons.lang.ObjectUtils;
import org.eclipse.core.commands.ParameterizedCommand;

public class ExistingExecutionHandler
extends AbstractExecutionHandler {
    private ExistingRunConfiguration existingRunConfig;

    @Override
    protected IRunConfiguration getRunConfigurationForExecution(String projectDir) throws IOException, ExecutionException, InterruptedException {
        return new ExistingRunConfiguration(projectDir);
    }

    @Override
    public void execute(ParameterizedCommand command) {
        String sessionId = this.getSessionId(command);
        String remoteServerUrl = this.getServerUrl(command);
        String driverTypeName = this.getDriverTypeName(command);
        this.existingRunConfig = new ExistingRunConfiguration(ProjectController.getInstance().getCurrentProject().getFolderLocation());
        this.existingRunConfig.setSessionId(sessionId);
        this.existingRunConfig.setRemoteUrl(remoteServerUrl);
        this.existingRunConfig.setDriverName(driverTypeName);
        super.execute(command);
    }

    private String getSessionId(ParameterizedCommand command) {
        return this.getParameter(command, "com.kms.katalon.composer.execution.existingSession.sessionId");
    }

    protected String getParameter(ParameterizedCommand command, String parameterId) {
        return ObjectUtils.toString(command.getParameterMap().get(parameterId));
    }

    protected String getServerUrl(ParameterizedCommand command) {
        return this.getParameter(command, "com.kms.katalon.composer.execution.existingSession.serverUrl");
    }

    protected String getDriverTypeName(ParameterizedCommand command) {
        return this.getParameter(command, "com.kms.katalon.composer.execution.existingSession.driverName");
    }

    @Override
    public void executeTestCase(TestCaseEntity testCase, LaunchMode launchMode) throws Exception {
        super.executeTestCase(testCase, launchMode);
    }

    @Override
    public void executeTestSuite(TestSuiteEntity testSuite, LaunchMode launchMode) throws Exception {
        super.executeTestSuite(testSuite, launchMode);
    }

    public ExistingRunConfiguration getExistingRunConfig() {
        return this.existingRunConfig;
    }

    public void setExistingRunConfig(ExistingRunConfiguration existingRunConfig) {
        this.existingRunConfig = existingRunConfig;
    }

    @Override
    public AbstractRunConfiguration buildRunConfiguration(String projectDir) throws IOException, ExecutionException, InterruptedException {
        ExistingRunConfiguration existingRunConfiguration = new ExistingRunConfiguration(projectDir);
        existingRunConfiguration.setSessionId(this.existingRunConfig.getSessionId());
        existingRunConfiguration.setRemoteUrl(this.existingRunConfig.getRemoteUrl());
        existingRunConfiguration.setDriverName(this.existingRunConfig.getDriverName());
        existingRunConfiguration.setExecutionProfile(ExecutionProfileManager.getInstance().getSelectedProfile());
        if (this.existingRunConfig != null) {
            ((DefaultExecutionSetting)existingRunConfiguration.getExecutionSetting()).setRawScript(this.existingRunConfig.getExecutionSetting().getRawScript());
        }
        return existingRunConfiguration;
    }
}

