/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.execution.jobs;

import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.handler.KSEFeatureAccessHandler;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.execution.constants.StringConstants;
import com.kms.katalon.composer.execution.exceptions.JobCancelException;
import com.kms.katalon.composer.execution.handlers.AbstractExecutionHandler;
import com.kms.katalon.composer.execution.launcher.IDELauncher;
import com.kms.katalon.controller.TestCaseController;
import com.kms.katalon.core.util.internal.ExceptionsUtil;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.testcase.TestCaseEntity;
import com.kms.katalon.execution.configuration.IRunConfiguration;
import com.kms.katalon.execution.entity.IExecutedEntity;
import com.kms.katalon.execution.entity.TestCaseBindingExecutedEntity;
import com.kms.katalon.execution.entity.TestCaseExecutedEntity;
import com.kms.katalon.execution.exception.ExecutionException;
import com.kms.katalon.execution.launcher.ILauncher;
import com.kms.katalon.execution.launcher.listener.LauncherEvent;
import com.kms.katalon.execution.launcher.listener.LauncherListener;
import com.kms.katalon.execution.launcher.listener.LauncherNotifiedObject;
import com.kms.katalon.execution.launcher.manager.LauncherManager;
import com.kms.katalon.execution.launcher.model.LaunchMode;
import com.kms.katalon.execution.launcher.result.LauncherStatus;
import com.kms.katalon.feature.FeatureServiceConsumer;
import com.kms.katalon.feature.IFeatureService;
import com.kms.katalon.feature.KSEFeature;
import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.ui.di.UISynchronize;

public class ExecuteTestCaseJob
extends Job {
    protected final UISynchronize sync;
    protected IRunConfiguration runConfig;
    protected final TestCaseEntity testCase;
    protected final LaunchMode launchMode;
    private AbstractExecutionHandler handler;
    protected boolean isCanceled;
    protected boolean executeFromHere;
    private IFeatureService featureService = FeatureServiceConsumer.getServiceInstance();

    public ExecuteTestCaseJob(String name, TestCaseEntity testCase, LaunchMode launchMode, UISynchronize sync, AbstractExecutionHandler handler) {
        super(name);
        this.testCase = testCase;
        this.launchMode = launchMode;
        this.sync = sync;
        this.handler = handler;
    }

    public ExecuteTestCaseJob(String name, TestCaseEntity testCase, LaunchMode launchMode, UISynchronize sync, AbstractExecutionHandler handler, boolean executeFromHere) {
        this(name, testCase, launchMode, sync, handler);
        this.executeFromHere = executeFromHere;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            monitor.beginTask(StringConstants.HAND_JOB_LAUNCHING_TEST_CASE, 3);
            monitor.subTask(StringConstants.HAND_JOB_ACTIVATING_VIEWERS);
            this.activateViewers();
            ExecuteTestCaseJob.validateJobProgressMonitor(monitor);
            monitor.worked(1);
            monitor.subTask(StringConstants.HAND_JOB_BUILDING_SCRIPTS);
            this.buildScripts();
            if (this.isCanceled) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            ExecuteTestCaseJob.validateJobProgressMonitor(monitor);
            this.startLauncher();
            monitor.worked(1);
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (JobCancelException jobCancelException) {
            IStatus iStatus = Status.CANCEL_STATUS;
            return iStatus;
        }
        catch (Exception e) {
            this.sync.syncExec(new Runnable(){

                @Override
                public void run() {
                    MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)StringConstants.HAND_ERROR_MSG_UNABLE_TO_EXECUTE_SELECTED_TEST_CASE, (String)StringConstants.HAND_ERROR_MSG_REASON_WRONG_SYNTAX);
                }
            });
            IStatus iStatus = Status.CANCEL_STATUS;
            return iStatus;
        }
        finally {
            monitor.done();
        }
    }

    protected void startLauncher() {
        LauncherManager launcherManager = LauncherManager.getInstance();
        final IDELauncher launcher = new IDELauncher(launcherManager, this.runConfig, this.launchMode, this.executeFromHere);
        launcher.addListener(new LauncherListener(){

            public void handleLauncherEvent(LauncherEvent event, LauncherNotifiedObject notifiedObject) {
                if (event == LauncherEvent.UPDATE_STATUS) {
                    ExecuteTestCaseJob.this.handleLauncherStatusChange(launcher, (LauncherStatus)notifiedObject.getObject());
                }
            }
        });
        launcherManager.addLauncher((ILauncher)launcher);
    }

    protected void handleLauncherStatusChange(IDELauncher launcher, LauncherStatus status) {
        if (status == LauncherStatus.DONE) {
            this.handleLauncherCompleted(launcher);
        }
    }

    protected void handleLauncherCompleted(IDELauncher launcher) {
        EventBrokerSingleton.getInstance().getEventBroker().post("EXECUTE/EXECUTE_TEST_CASE_COMPLETED", (Object)launcher.getResult());
    }

    protected void activateViewers() {
        AbstractExecutionHandler.openConsoleLog();
    }

    protected void buildScripts() {
        UISynchronizeService.syncExec(() -> {
            try {
                this.runConfig = this.handler.buildRunConfiguration(this.testCase.getProject().getFolderLocation());
                if (this.runConfig == null) {
                    this.isCanceled = true;
                    return;
                }
                if (this.testCase.getVariables().isEmpty() || TestCaseController.getInstance().isNotUsingDataBinding(this.testCase)) {
                    this.runConfig.build((FileEntity)this.testCase, (IExecutedEntity)new TestCaseExecutedEntity(this.testCase));
                } else {
                    boolean canUseDdtAtTcLevel = this.featureService.canUse(KSEFeature.TEST_CASE_DATA_BINDING);
                    if (!canUseDdtAtTcLevel) {
                        KSEFeatureAccessHandler.handleUnauthorizedAccess((KSEFeature)KSEFeature.TEST_CASE_DATA_BINDING);
                        this.isCanceled = true;
                        return;
                    }
                    TestCaseBindingExecutedEntity executedEntity = new TestCaseBindingExecutedEntity(this.testCase);
                    this.runConfig.build((FileEntity)this.testCase, (IExecutedEntity)executedEntity);
                }
            }
            catch (ExecutionException | IOException | ArithmeticException | InterruptedException e) {
                MultiStatusErrorDialog.showErrorDialog((String)StringConstants.HAND_ERROR_MSG_UNABLE_TO_EXECUTE_SELECTED_TEST_CASE, (String)e.getMessage(), (String)ExceptionsUtil.getStackTraceForThrowable((Throwable)e));
                LoggerSingleton.logError((Throwable)e);
                this.isCanceled = true;
            }
        });
    }

    private static void validateJobProgressMonitor(IProgressMonitor monitor) throws JobCancelException {
        if (monitor.isCanceled()) {
            throw new JobCancelException();
        }
    }
}

