/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.execution.preferences;

import com.kms.katalon.composer.components.dialogs.PreferencePageWithHelp;
import com.kms.katalon.composer.execution.constants.ComposerExecutionMessageConstants;
import com.kms.katalon.composer.execution.constants.StringConstants;
import com.kms.katalon.constants.DocumentationMessageConstants;
import com.kms.katalon.constants.MessageConstants;
import com.kms.katalon.core.network.ProxyInformation;
import com.kms.katalon.core.network.ProxyOption;
import com.kms.katalon.core.network.ProxyServerType;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractProxyConfigurationPreferencesPage
extends PreferencePageWithHelp {
    private Text txtAddress;
    private Text txtPort;
    private Text txtUsername;
    private Text txtPass;
    private Text txtExceptionList;
    private Combo cboProxyOption;
    private Combo cboProxyServerType;
    private Button chkRequireAuthentication;
    private static final int MAX_PORT_VALUE = 65535;

    public AbstractProxyConfigurationPreferencesPage() {
        this.noDefaultButton();
    }

    protected Control createContents(Composite parent) {
        Composite area = parent;
        Composite innerComposite = new Composite(area, 0);
        innerComposite.setLayoutData((Object)new GridData(1808));
        GridLayout glContainer = new GridLayout(2, false);
        glContainer.verticalSpacing = 10;
        glContainer.marginTop = 20;
        glContainer.marginLeft = 10;
        glContainer.marginRight = 10;
        glContainer.marginBottom = 30;
        innerComposite.setLayout((Layout)glContainer);
        this.createHeaderComposite(innerComposite);
        Label lblProxyOption = new Label(innerComposite, 0);
        lblProxyOption.setText(MessageConstants.LBL_PROXY_OPTION);
        this.cboProxyOption = new Combo(innerComposite, 8);
        GridData gdComboProxyOption = new GridData(4, 4, true, false, 1, 1);
        gdComboProxyOption.widthHint = 320;
        gdComboProxyOption.heightHint = 18;
        this.cboProxyOption.setLayoutData((Object)gdComboProxyOption);
        this.cboProxyOption.setItems(ProxyOption.displayStringValues());
        this.cboProxyOption.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.getSource() != AbstractProxyConfigurationPreferencesPage.this.cboProxyOption) {
                    return;
                }
                ProxyOption proxyOption = ProxyOption.valueOfDisplayName((String)AbstractProxyConfigurationPreferencesPage.this.cboProxyOption.getText());
                AbstractProxyConfigurationPreferencesPage.this.cboProxyOption.setData((Object)proxyOption.name());
                switch (proxyOption) {
                    case MANUAL_CONFIG: {
                        AbstractProxyConfigurationPreferencesPage.this.selectManualConfigProxyOption();
                        return;
                    }
                    case NO_PROXY: {
                        AbstractProxyConfigurationPreferencesPage.this.selectNoProxyOption();
                        return;
                    }
                    case USE_SYSTEM: {
                        AbstractProxyConfigurationPreferencesPage.this.selectSystemProxyOption();
                        return;
                    }
                }
            }
        });
        Label lblNewLabel = new Label(innerComposite, 0);
        lblNewLabel.setText(MessageConstants.LBL_PROXY_SERVER_TYPE);
        this.cboProxyServerType = new Combo(innerComposite, 8);
        GridData gdComboProxyServerType = new GridData(4, 4, true, false, 1, 1);
        gdComboProxyServerType.widthHint = 319;
        gdComboProxyServerType.heightHint = 18;
        this.cboProxyServerType.setLayoutData((Object)gdComboProxyServerType);
        this.cboProxyServerType.setBackground(Display.getCurrent().getSystemColor(1));
        this.cboProxyServerType.setItems(ProxyServerType.stringValues());
        Label lblAddress = new Label(innerComposite, 0);
        lblAddress.setText(MessageConstants.LBL_ADDRESS);
        Composite composite = new Composite(innerComposite, 0);
        GridLayout glComposite = new GridLayout(3, false);
        glComposite.marginWidth = 0;
        glComposite.marginHeight = 0;
        glComposite.horizontalSpacing = 0;
        glComposite.verticalSpacing = 0;
        composite.setLayout((Layout)glComposite);
        GridData gdComposite = new GridData(4, 4, false, false, 1, 1);
        gdComposite.widthHint = 314;
        gdComposite.heightHint = 22;
        composite.setLayoutData((Object)gdComposite);
        this.txtAddress = new Text(composite, 2048);
        GridData gdAddress = new GridData(16384, 4, true, false, 1, 1);
        gdAddress.widthHint = 206;
        this.txtAddress.setLayoutData((Object)gdAddress);
        Label lblPort = new Label(composite, 0);
        GridData gdLblPort = new GridData(16384, 0x1000000, false, false, 1, 1);
        gdLblPort.widthHint = 32;
        lblPort.setLayoutData((Object)gdLblPort);
        lblPort.setText(MessageConstants.LBL_PORT);
        this.txtPort = new Text(composite, 2048);
        GridData gd_txtPort = new GridData(4, 4, true, false, 1, 1);
        gd_txtPort.widthHint = 68;
        this.txtPort.setLayoutData((Object)gd_txtPort);
        this.txtPort.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                String text = AbstractProxyConfigurationPreferencesPage.this.txtPort.getText();
                String newText = String.valueOf(text.substring(0, e.start)) + e.text + text.substring(e.end);
                if (StringUtils.isEmpty((String)newText)) {
                    e.doit = true;
                    return;
                }
                try {
                    int val = Integer.parseInt(newText);
                    e.doit = val >= 0 && val <= 65535;
                }
                catch (NumberFormatException numberFormatException) {
                    e.doit = false;
                }
            }
        });
        Label separatorEx = new Label(area, 258);
        separatorEx.setLayoutData((Object)new GridData(768));
        Label lblExceptionList = new Label(innerComposite, 0);
        GridData gdLblException = new GridData(16384, 0x1000000, false, false, 1, 1);
        lblExceptionList.setLayoutData((Object)gdLblException);
        lblExceptionList.setText(MessageConstants.LBL_EXCEPTION_LIST);
        this.txtExceptionList = new Text(innerComposite, 2048);
        GridData gdExceptionList = new GridData(4, 4, true, false, 1, 1);
        gdExceptionList.widthHint = 320;
        gdExceptionList.heightHint = 28;
        this.txtExceptionList.setLayoutData((Object)gdExceptionList);
        this.chkRequireAuthentication = new Button(innerComposite, 32);
        this.chkRequireAuthentication.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.chkRequireAuthentication.setText(MessageConstants.CHK_TEXT_PROXY_SERVER_TYPE_REQUIRE_AUTHENTICATION);
        this.chkRequireAuthentication.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selection = AbstractProxyConfigurationPreferencesPage.this.chkRequireAuthentication.getSelection();
                AbstractProxyConfigurationPreferencesPage.this.txtUsername.setEnabled(selection);
                AbstractProxyConfigurationPreferencesPage.this.txtUsername.setText(selection ? AbstractProxyConfigurationPreferencesPage.this.txtUsername.getText() : "");
                AbstractProxyConfigurationPreferencesPage.this.txtPass.setEnabled(selection);
                AbstractProxyConfigurationPreferencesPage.this.txtPass.setText(selection ? AbstractProxyConfigurationPreferencesPage.this.txtPass.getText() : "");
            }
        });
        Group authenticateGroup = new Group(innerComposite, 0);
        authenticateGroup.setText("Authentication");
        authenticateGroup.setLayout((Layout)new GridLayout(2, false));
        authenticateGroup.setLayoutData((Object)new GridData(4, 128, false, true, 2, 1));
        Label lblUsername = new Label((Composite)authenticateGroup, 0);
        lblUsername.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblUsername.setText(MessageConstants.LBL_USERNAME);
        this.txtUsername = new Text((Composite)authenticateGroup, 2048);
        GridData gdUsername = new GridData(4, 0x1000000, true, false, 1, 1);
        this.txtUsername.setLayoutData((Object)gdUsername);
        Label lblPassword = new Label((Composite)authenticateGroup, 0);
        lblPassword.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblPassword.setText(MessageConstants.LBL_PASSWORD);
        this.txtPass = new Text((Composite)authenticateGroup, 0x400800);
        GridData gdPass = new GridData(4, 0x1000000, true, false, 1, 1);
        this.txtPass.setLayoutData((Object)gdPass);
        this.createFooterComposite(innerComposite);
        this.initialize();
        return area;
    }

    protected void createHeaderComposite(Composite parent) {
        Composite headerComposite = new Composite(parent, 0);
        GridLayout glHeader = new GridLayout(1, true);
        glHeader.marginTop = 0;
        glHeader.marginWidth = 0;
        glHeader.marginBottom = 20;
        headerComposite.setLayout((Layout)glHeader);
        GridData gdHeader = new GridData(16384, 128, true, false, 2, 1);
        gdHeader.widthHint = 500;
        headerComposite.setLayoutData((Object)gdHeader);
        if (StringUtils.isNotBlank((String)this.getGuideMessage())) {
            Label lblGuideMessage = new Label(headerComposite, 64);
            GridData gdGuideMessage = new GridData(16384, 128, true, false);
            lblGuideMessage.setLayoutData((Object)gdGuideMessage);
            lblGuideMessage.setText(this.getGuideMessage());
        }
    }

    protected String getGuideMessage() {
        return "";
    }

    protected void createFooterComposite(Composite parent) {
    }

    protected void selectNoProxyOption() {
        this.cboProxyServerType.setEnabled(false);
        this.txtPort.setEnabled(false);
        this.txtAddress.setEnabled(false);
        this.chkRequireAuthentication.setEnabled(false);
        this.txtUsername.setEnabled(false);
        this.txtPass.setEnabled(false);
        this.txtExceptionList.setEnabled(false);
    }

    protected void selectSystemProxyOption() {
        this.selectNoProxyOption();
    }

    protected void selectManualConfigProxyOption() {
        ProxyInformation proxyInfo = this.getProxyInfo();
        this.inputProxyInfo(proxyInfo);
        this.cboProxyServerType.setEnabled(true);
        this.txtPort.setEnabled(true);
        this.txtAddress.setEnabled(true);
        this.chkRequireAuthentication.setEnabled(true);
        boolean isEnableAuthentication = this.chkRequireAuthentication.getSelection();
        this.txtUsername.setEnabled(isEnableAuthentication);
        this.txtPass.setEnabled(isEnableAuthentication);
        this.txtExceptionList.setEnabled(true);
    }

    private void initialize() {
        ProxyInformation proxyInfo = this.getProxyInfo();
        this.inputProxyInfo(proxyInfo);
        this.chkRequireAuthentication.setEnabled(true);
        if (StringUtils.isNotEmpty((String)this.txtUsername.getText()) && StringUtils.isNotEmpty((String)this.txtPass.getText())) {
            this.chkRequireAuthentication.setSelection(true);
        }
        this.cboProxyOption.setText(ProxyOption.valueOf((String)proxyInfo.getProxyOption()).getDisplayName());
        this.cboProxyOption.setData((Object)proxyInfo.getProxyOption());
        String proxyOption = proxyInfo.getProxyOption();
        if (ProxyOption.NO_PROXY.name().equals(proxyOption)) {
            this.selectNoProxyOption();
        } else if (ProxyOption.USE_SYSTEM.name().equals(proxyOption)) {
            this.selectSystemProxyOption();
        } else {
            boolean requiredAuthentication = this.chkRequireAuthentication.getSelection();
            this.txtUsername.setEnabled(requiredAuthentication);
            this.txtPass.setEnabled(requiredAuthentication);
        }
    }

    private void inputProxyInfo(ProxyInformation proxyInfo) {
        this.cboProxyServerType.setText(proxyInfo.getProxyServerType());
        this.txtAddress.setText(proxyInfo.getProxyServerAddress());
        this.txtPort.setText(proxyInfo.getProxyServerPort() > 0 ? String.valueOf(proxyInfo.getProxyServerPort()) : "");
        this.txtUsername.setText(proxyInfo.getUsername());
        this.txtPass.setText(proxyInfo.getPassword());
        this.txtExceptionList.setText(proxyInfo.getExceptionList());
    }

    public boolean performOk() {
        if (this.cboProxyOption == null) {
            return true;
        }
        ProxyInformation proxyInfo = new ProxyInformation();
        String proxyOption = (String)this.cboProxyOption.getData();
        proxyInfo.setProxyOption(proxyOption);
        proxyInfo.setProxyServerType(this.cboProxyServerType.getText());
        proxyInfo.setProxyServerAddress(this.txtAddress.getText());
        String portValue = this.txtPort.getText();
        proxyInfo.setProxyServerPort(StringUtils.isEmpty((String)portValue) ? String.valueOf(0) : portValue);
        proxyInfo.setUsername(this.txtUsername.getText());
        proxyInfo.setPassword(this.txtPass.getText());
        proxyInfo.setExceptionList(this.txtExceptionList.getText());
        try {
            this.saveProxyInfo(proxyInfo);
            return true;
        }
        catch (IOException iOException) {
            MessageDialog.openError((Shell)this.getShell(), (String)StringConstants.ERROR_TITLE, (String)ComposerExecutionMessageConstants.PREF_MSG_UNABLE_TO_SAVE_PROXY_CONFIG);
            return false;
        }
    }

    protected abstract ProxyInformation getProxyInfo();

    protected abstract void saveProxyInfo(ProxyInformation var1) throws IOException;

    public boolean hasDocumentation() {
        return true;
    }

    public String getDocumentationUrl() {
        return DocumentationMessageConstants.PREFERENCE_PROXY;
    }
}

