/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.execution.settings;

import com.kms.katalon.composer.components.dialogs.PreferencePageWithHelp;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.execution.constants.ComposerExecutionMessageConstants;
import com.kms.katalon.composer.execution.constants.StringConstants;
import com.kms.katalon.constants.DocumentationMessageConstants;
import com.kms.katalon.execution.collector.RunConfigurationCollector;
import com.kms.katalon.execution.configuration.contributor.IRunConfigurationContributor;
import com.kms.katalon.execution.constants.ExecutionMessageConstants;
import com.kms.katalon.execution.setting.ExecutionDefaultSettingStore;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class DefaultExecutionSettingPage
extends PreferencePageWithHelp {
    private static final String LBL_DEFAULT_EXECUTION = ExecutionMessageConstants.LBL_DEFAULT_EXECUTION;
    private static final String LBL_APPLY_NEIGHBOR_XPATHS = ExecutionMessageConstants.LBL_APPLY_NEIGHBOR_XPATHS;
    public static final short TIMEOUT_MIN_VALUE = 0;
    public static final short TIMEOUT_MAX_VALUE = 9999;
    private static final int INPUT_WIDTH = 60;
    private ExecutionDefaultSettingStore store = ExecutionDefaultSettingStore.getStore();
    private Composite container;
    private Combo cbDefaultBrowser;
    private Text txtDefaultElementTimeout;
    private Button chckApplyNeighborXpaths;
    private Button chckOpenReport;
    private Button chckQuitDriversTestCase;
    private Button chckQuitDriversTestSuite;
    private IRunConfigurationContributor[] runConfigs;
    private String selectedExecutionConfiguration;

    protected Control createContents(Composite parent) {
        this.container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.verticalSpacing = 10;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.container.setLayout((Layout)layout);
        Composite comp = new Composite(this.container, 0);
        GridLayout glComp = new GridLayout(2, false);
        glComp.verticalSpacing = 10;
        glComp.marginHeight = 0;
        glComp.marginWidth = 0;
        comp.setLayout((Layout)glComp);
        Label lblDefaultBrowser = new Label(comp, 0);
        lblDefaultBrowser.setText(LBL_DEFAULT_EXECUTION);
        lblDefaultBrowser.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.cbDefaultBrowser = new Combo(comp, 2060);
        GridData gdCbDefaultBrowser = new GridData(16384, 0x1000000, false, false, 1, 1);
        gdCbDefaultBrowser.widthHint = 120;
        this.cbDefaultBrowser.setLayoutData((Object)gdCbDefaultBrowser);
        Label lblDefaultElementTimeout = new Label(comp, 0);
        lblDefaultElementTimeout.setText(StringConstants.PREF_LBL_DEFAULT_IMPLICIT_TIMEOUT);
        lblDefaultElementTimeout.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.txtDefaultElementTimeout = new Text(comp, 2048);
        GridData gdTxtDefaultElementTimeout = new GridData(16384, 0x1000000, false, false, 1, 1);
        gdTxtDefaultElementTimeout.widthHint = 60;
        this.txtDefaultElementTimeout.setLayoutData((Object)gdTxtDefaultElementTimeout);
        Group grpAfterExecuting = new Group(this.container, 0);
        grpAfterExecuting.setText(StringConstants.PREF_GRP_POST_EXECUTION_OPTIONS);
        GridLayout glGrpAfterExecuting = new GridLayout();
        glGrpAfterExecuting.marginLeft = 15;
        grpAfterExecuting.setLayout((Layout)glGrpAfterExecuting);
        grpAfterExecuting.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.chckOpenReport = new Button((Composite)grpAfterExecuting, 32);
        this.chckOpenReport.setText(StringConstants.PREF_CHKBOX_OPEN_RPT_AFTER_EXE_COMPLETELY);
        this.chckQuitDriversTestCase = new Button((Composite)grpAfterExecuting, 32);
        this.chckQuitDriversTestCase.setText(StringConstants.PREF_CHKBOX_QUIT_DRIVERS_AFTER_EXE_COMPLETELY);
        this.chckQuitDriversTestSuite = new Button((Composite)grpAfterExecuting, 32);
        this.chckQuitDriversTestSuite.setText(ComposerExecutionMessageConstants.PREF_CHKBOX_QUIT_DRIVERS_AFTER_EXE_TEST_SUITE_COMPLETELY);
        try {
            this.initialize();
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e);
        }
        this.registerListeners();
        return this.container;
    }

    private void registerListeners() {
        this.addNumberVerification(this.txtDefaultElementTimeout, 0, 9999);
    }

    private void addNumberVerification(Text txtInput, final int min, final int max) {
        if (txtInput == null || txtInput.isDisposed()) {
            return;
        }
        txtInput.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                String oldValue = ((Text)e.getSource()).getText();
                String enterValue = e.text;
                String newValue = String.valueOf(oldValue.substring(0, e.start)) + enterValue + oldValue.substring(e.end);
                if (!newValue.matches("\\d+")) {
                    e.doit = false;
                    return;
                }
                try {
                    int val = Integer.parseInt(newValue);
                    e.doit = val >= min && val <= max;
                }
                catch (NumberFormatException numberFormatException) {
                    e.doit = false;
                }
            }
        });
        txtInput.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ((Text)e.getSource()).selectAll();
            }

            public void focusLost(FocusEvent e) {
                Text inputField = (Text)e.getSource();
                String value = inputField.getText();
                if (value.length() <= 1 || !value.startsWith("0")) {
                    return;
                }
                try {
                    int val = Integer.parseInt(value);
                    inputField.setText(String.valueOf(val));
                }
                catch (NumberFormatException numberFormatException) {}
            }
        });
        txtInput.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                ((Text)e.getSource()).selectAll();
            }
        });
    }

    private void initialize() throws IOException {
        this.selectedExecutionConfiguration = this.store.getExecutionConfiguration();
        this.runConfigs = RunConfigurationCollector.getInstance().getAllBuiltinRunConfigurationContributors();
        if (this.runConfigs.length > 0) {
            List<String> runConfigIds = Arrays.stream(this.runConfigs).map(config -> config.getId()).collect(Collectors.toList());
            int selectedIndex = Math.max(runConfigIds.indexOf(this.selectedExecutionConfiguration), 0);
            String[] runConfigIdList = runConfigIds.toArray(new String[0]);
            this.cbDefaultBrowser.setItems(runConfigIdList);
            this.cbDefaultBrowser.select(selectedIndex);
        }
        this.txtDefaultElementTimeout.setText(Integer.toString(this.store.getElementTimeout()));
        this.chckOpenReport.setSelection(this.store.isPostExecOpenReport());
        this.chckQuitDriversTestCase.setSelection(this.store.isPostTestCaseExecQuitDriver());
        this.chckQuitDriversTestSuite.setSelection(this.store.isPostTestSuiteExecQuitDriver());
    }

    protected void performDefaults() {
        if (this.container == null) {
            return;
        }
        String selectedExecutionConfiguration = ExecutionDefaultSettingStore.getStore().getDefaultExecutionConfiguration();
        this.runConfigs = RunConfigurationCollector.getInstance().getAllBuiltinRunConfigurationContributors();
        if (this.runConfigs.length > 0) {
            List<String> runConfigIds = Arrays.stream(this.runConfigs).map(config -> config.getId()).collect(Collectors.toList());
            int selectedIndex = Math.max(runConfigIds.indexOf(selectedExecutionConfiguration), 0);
            String[] runConfigIdList = runConfigIds.toArray(new String[0]);
            this.cbDefaultBrowser.setItems(runConfigIdList);
            this.cbDefaultBrowser.select(selectedIndex);
        }
        this.txtDefaultElementTimeout.setText(Integer.toString(30));
        this.chckOpenReport.setSelection(false);
        this.chckQuitDriversTestCase.setSelection(false);
        this.chckQuitDriversTestSuite.setSelection(true);
    }

    protected void performApply() {
        if (this.container == null) {
            return;
        }
        try {
            if (this.cbDefaultBrowser != null && this.runConfigs != null && this.runConfigs.length > 0 && !StringUtils.equals((CharSequence)this.cbDefaultBrowser.getText(), (CharSequence)this.selectedExecutionConfiguration)) {
                this.selectedExecutionConfiguration = this.cbDefaultBrowser.getText();
                this.store.setExecutionConfiguration(this.selectedExecutionConfiguration);
            }
            if (this.txtDefaultElementTimeout != null) {
                this.store.setElementTimeout(Integer.parseInt(this.txtDefaultElementTimeout.getText()));
            }
            if (this.chckOpenReport != null) {
                this.store.setPostExecOpenReport(this.chckOpenReport.getSelection());
            }
            if (this.chckQuitDriversTestCase != null) {
                this.store.setPostTestCaseExecQuitDriver(this.chckQuitDriversTestCase.getSelection());
            }
            if (this.chckQuitDriversTestSuite != null) {
                this.store.setPostTestSuiteExecQuitDriver(this.chckQuitDriversTestSuite.getSelection());
            }
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    public boolean performOk() {
        if (super.performOk() && this.isValid()) {
            this.performApply();
        }
        return true;
    }

    public boolean hasDocumentation() {
        return true;
    }

    public String getDocumentationUrl() {
        return DocumentationMessageConstants.SETTINGS_EXECUTION;
    }
}

