/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.execution.settings;

import com.kms.katalon.composer.components.dialogs.PreferencePageWithHelp;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.execution.constants.StringConstants;
import com.kms.katalon.webserver.WebViewController;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public abstract class EmailTemplatePage
extends PreferencePageWithHelp {
    public static final String TYPE_TEST_SUITE = "TEST_SUITE";
    public static final String TYPE_TEST_SUITE_COLLECTION = "TEST_SUITE_COLLECTION";
    private Browser browser;
    private String type;

    protected Control createContents(Composite parent) {
        Composite browserComposite = new Composite(parent, 2048);
        browserComposite.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        browserComposite.setLayout((Layout)new FillLayout());
        this.browser = (Browser)ComponentBuilder.browser((Composite)browserComposite).build();
        this.browser.setJavascriptEnabled(true);
        this.updateInput();
        return browserComposite;
    }

    private void updateInput() {
        try {
            this.setEditorContent(false);
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    protected String getHtmlMessage() {
        String body = (String)this.browser.evaluate("return tinymce.activeEditor.getContent({ format: 'html' });");
        return String.format("<html><body>%s</body></html>", body);
    }

    protected void performDefaults() {
        try {
            this.setEditorContent(true);
        }
        catch (Exception e) {
            MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)StringConstants.ERROR_TITLE, (String)e.getMessage());
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private void setEditorContent(boolean isSetDefaults) throws IOException, URISyntaxException, NoSuchMethodException, SecurityException, ClassNotFoundException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, InstantiationException {
        String query = MessageFormat.format("type={0}&setDefaults={1}", this.type, isSetDefaults);
        String url = WebViewController.getInstance().getPage("EmailTemplatePage.html?" + query);
        this.browser.setUrl(url);
    }

    public boolean performOk() {
        if (!this.isControlCreated()) {
            return true;
        }
        try {
            this.save();
            return true;
        }
        catch (Exception e) {
            MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)StringConstants.ERROR_TITLE, (String)e.getMessage());
            LoggerSingleton.logError((Throwable)e);
            return false;
        }
    }

    protected abstract String getHTMLTemplate() throws Exception;

    protected abstract String getDefaultHTMLTemplate() throws Exception;

    protected abstract void save() throws Exception;

    public void setType(String type) {
        this.type = type;
    }
}

