/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.execution.settings;

import com.kms.katalon.composer.components.controls.HelpComposite;
import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.handler.KSEFeatureAccessHandler;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.components.util.ComponentEventUtil;
import com.kms.katalon.composer.execution.constants.ComposerExecutionMessageConstants;
import com.kms.katalon.composer.execution.constants.StringConstants;
import com.kms.katalon.composer.execution.settings.AbstractExecutionSettingPage;
import com.kms.katalon.constants.DocumentationMessageConstants;
import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.core.helper.screenrecorder.VideoFileFormat;
import com.kms.katalon.core.helper.screenrecorder.VideoQuality;
import com.kms.katalon.core.setting.VideoRecorderSetting;
import com.kms.katalon.execution.collector.RunConfigurationCollector;
import com.kms.katalon.execution.configuration.contributor.IRunConfigurationContributor;
import com.kms.katalon.execution.constants.ExecutionMessageConstants;
import com.kms.katalon.execution.setting.ExecutionDefaultSettingStore;
import com.kms.katalon.execution.setting.ExecutionSettingStore;
import com.kms.katalon.feature.FeatureServiceConsumer;
import com.kms.katalon.feature.IFeatureService;
import com.kms.katalon.feature.KSEFeature;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ExecutionSettingPage
extends AbstractExecutionSettingPage {
    private static final String LBL_DEFAULT_EXECUTION = ExecutionMessageConstants.LBL_DEFAULT_EXECUTION;
    private static final String[] VIDEO_FORMAT_ITEMS = Arrays.asList(VideoFileFormat.values()).stream().map(format -> format.toString()).collect(Collectors.toList()).toArray(new String[0]);
    private static final String[] VIDEO_QUALITY_ITEMS = Arrays.asList(VideoQuality.values()).stream().map(format -> format.getReadableName()).collect(Collectors.toList()).toArray(new String[0]);
    private ExecutionDefaultSettingStore defaultSettingStore;
    private ExecutionSettingStore store;
    private Combo cbDefaultBrowser;
    private Combo cbLogTestSteps;
    private Text txtDefaultElementTimeout;
    private Combo cbHideHostName;
    private Button chckOpenReport;
    private Button chckQuitDriversTestCase;
    private Button chckQuitDriversTestSuite;
    private Composite videoRecordingSettings;
    private Composite browserRecorderSettings;
    private Composite screenRecorderSettings;
    private Button btnEnableScreenshot;
    private Button btnEnableVideoRecording;
    private Button btnScreenRecorder;
    private Button btnBrowserRecorder;
    private Combo cbbVideoFormat;
    private Combo cbbVideoQuality;
    private Button btnRecordIfPassed;
    private Button btnRecordIfFailed;
    private Button btnRecordAllTestCases;
    private Button btnRecordFailedTestCases;
    private IRunConfigurationContributor[] runConfigs;
    private String selectedExecutionConfiguration;
    private IFeatureService featureService = FeatureServiceConsumer.getServiceInstance();

    public ExecutionSettingPage() {
        this.defaultSettingStore = ExecutionDefaultSettingStore.getStore();
        this.store = ExecutionSettingStore.getStore();
    }

    @Override
    protected Composite createSettingsArea(Composite container) {
        this.createCommonExecutionOptions(container);
        this.createDuringExecutionOptionsGroup(container);
        this.createPostExecutionOptionsGroup(container);
        return container;
    }

    private void createCommonExecutionOptions(Composite parent) {
        Composite commonContainer = (Composite)ComponentBuilder.gridContainer((Composite)parent, (int)2).margin(0).gridVerticalSpacing(10).build();
        ComponentBuilder.label((Composite)commonContainer).text(LBL_DEFAULT_EXECUTION).build();
        this.cbDefaultBrowser = (Combo)ComponentBuilder.comboBox((Composite)commonContainer, (int)8).width(120).build();
        ComponentBuilder.label((Composite)commonContainer).text(StringConstants.PREF_LBL_LOG_TEST_STEPS).build();
        this.cbLogTestSteps = (Combo)ComponentBuilder.comboBox((Composite)commonContainer, (int)2056).width(120).build();
        ComponentBuilder.label((Composite)commonContainer).text(StringConstants.PREF_LBL_DEFAULT_IMPLICIT_TIMEOUT).build();
        this.txtDefaultElementTimeout = (Text)ComponentBuilder.text((Composite)commonContainer, (int)2048).width(60).build();
        ComponentBuilder.label((Composite)commonContainer).text(StringConstants.PREF_LBL_HIDE_HOST_NAME).build();
        this.cbHideHostName = (Combo)ComponentBuilder.comboBox((Composite)commonContainer, (int)2056).width(120).build();
    }

    private void createDuringExecutionOptionsGroup(Composite parent) {
        Group grpDuringExecution = (Group)ComponentBuilder.group((Composite)parent).margin(0).text(ComposerExecutionMessageConstants.PREF_GRP_DURING_EXECUTION_OPTIONS).fillHorizontal().gridVerticalSpacing(10).build();
        this.btnEnableScreenshot = (Button)ComponentBuilder.checkBox((Composite)grpDuringExecution).text(ComposerExecutionMessageConstants.PAGE_TXT_ENABLE_TAKE_SCREENSHOT).build();
        this.btnEnableVideoRecording = (Button)ComponentBuilder.checkBox((Composite)grpDuringExecution).text(ComposerExecutionMessageConstants.PREF_CHCK_ENABLE_VIDEO_RECORDER).build();
        this.videoRecordingSettings = (Composite)ComponentBuilder.gridContainer((Composite)grpDuringExecution).build();
        Composite browserRecorderRow = (Composite)ComponentBuilder.gridContainer((Composite)this.videoRecordingSettings, (int)2).build();
        this.btnBrowserRecorder = (Button)ComponentBuilder.radio((Composite)browserRecorderRow).text(ComposerExecutionMessageConstants.PREF_RADIO_RECORD_BROWSER_WINDOW).check().build();
        new HelpComposite(browserRecorderRow, DocumentationMessageConstants.BROWSER_BASED_RECORDER);
        this.browserRecorderSettings = (Composite)ComponentBuilder.gridContainer((Composite)this.videoRecordingSettings).marginLeft(20).build();
        this.btnRecordAllTestCases = (Button)ComponentBuilder.radio((Composite)this.browserRecorderSettings).text(ComposerExecutionMessageConstants.PREF_RADIO_RECORD_ALL_TEST_CASES).build();
        this.btnRecordFailedTestCases = (Button)ComponentBuilder.radio((Composite)this.browserRecorderSettings).text(ComposerExecutionMessageConstants.PREF_RADIO_RECORD_FAILED_TEST_CASES).build();
        Composite screenRecorderRow = (Composite)ComponentBuilder.gridContainer((Composite)this.videoRecordingSettings, (int)2).build();
        this.btnScreenRecorder = (Button)ComponentBuilder.radio((Composite)screenRecorderRow).text(ComposerExecutionMessageConstants.PREF_RADIO_RECORD_FULLSCREEN).check().build();
        new HelpComposite(screenRecorderRow, DocumentationMessageConstants.SCREEN_RECORDER);
        this.screenRecorderSettings = (Composite)ComponentBuilder.gridContainer((Composite)this.videoRecordingSettings, (int)2).marginLeft(20).fillHorizontal().build();
        this.btnRecordIfPassed = (Button)ComponentBuilder.checkBox((Composite)this.screenRecorderSettings).text(ComposerExecutionMessageConstants.PREF_CHCK_RECORD_IF_PASSED).colSpan(2).build();
        this.btnRecordIfFailed = (Button)ComponentBuilder.checkBox((Composite)this.screenRecorderSettings).text(ComposerExecutionMessageConstants.PREF_CHCK_RECORD_IF_FAILED).colSpan(2).build();
        ComponentBuilder.label((Composite)this.screenRecorderSettings).text(ComposerExecutionMessageConstants.PREF_LBL_VIDEO_FORMAT).build();
        this.cbbVideoFormat = (Combo)ComponentBuilder.comboBox((Composite)this.screenRecorderSettings, (int)8).width(120).build();
        this.cbbVideoFormat.setItems(VIDEO_FORMAT_ITEMS);
        ComponentBuilder.label((Composite)this.screenRecorderSettings).text(ComposerExecutionMessageConstants.PREF_LBL_VIDEO_QUALITY).build();
        this.cbbVideoQuality = (Combo)ComponentBuilder.comboBox((Composite)this.screenRecorderSettings, (int)8).width(120).build();
        this.cbbVideoQuality.setItems(VIDEO_QUALITY_ITEMS);
    }

    private void createPostExecutionOptionsGroup(Composite parent) {
        Group grpAfterExecuting = (Group)ComponentBuilder.group((Composite)parent).text(StringConstants.PREF_GRP_POST_EXECUTION_OPTIONS).fillHorizontal().gridLayout().build();
        this.chckOpenReport = new Button((Composite)grpAfterExecuting, 32);
        this.chckOpenReport.setText(StringConstants.PREF_CHKBOX_OPEN_RPT_AFTER_EXE_COMPLETELY);
        this.chckQuitDriversTestCase = new Button((Composite)grpAfterExecuting, 32);
        this.chckQuitDriversTestCase.setText(StringConstants.PREF_CHKBOX_QUIT_DRIVERS_AFTER_EXE_COMPLETELY);
        this.chckQuitDriversTestSuite = new Button((Composite)grpAfterExecuting, 32);
        this.chckQuitDriversTestSuite.setText(ComposerExecutionMessageConstants.PREF_CHKBOX_QUIT_DRIVERS_AFTER_EXE_TEST_SUITE_COMPLETELY);
    }

    @Override
    protected void registerListeners() {
        this.cbLogTestSteps.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!ExecutionSettingPage.this.featureService.canUse(KSEFeature.CONSOLE_LOG_CUSTOMIZATION)) {
                    KSEFeatureAccessHandler.handleUnauthorizedAccess((KSEFeature)KSEFeature.CONSOLE_LOG_CUSTOMIZATION);
                    ExecutionSettingPage.this.cbLogTestSteps.select(0);
                }
            }
        });
        this.cbHideHostName.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!ExecutionSettingPage.this.featureService.canUse(KSEFeature.HIDE_HOSTNAME)) {
                    KSEFeatureAccessHandler.handleUnauthorizedAccess((KSEFeature)KSEFeature.HIDE_HOSTNAME);
                    ExecutionSettingPage.this.cbHideHostName.select(1);
                }
            }
        });
        this.btnEnableVideoRecording.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExecutionSettingPage.this.updateControlState();
            }
        });
        Listener onChangeRecorder = event -> {
            if (event.widget == this.btnBrowserRecorder) {
                this.btnScreenRecorder.setSelection(!this.btnBrowserRecorder.getSelection());
            } else {
                this.btnBrowserRecorder.setSelection(!this.btnScreenRecorder.getSelection());
            }
            this.updateControlState();
        };
        ComponentEventUtil.onClick((Widget)this.btnBrowserRecorder, (Listener)onChangeRecorder);
        ComponentEventUtil.onClick((Widget)this.btnScreenRecorder, (Listener)onChangeRecorder);
        this.addNumberVerification(this.txtDefaultElementTimeout, 0, 9999);
    }

    @Override
    protected void initialize() throws IOException {
        this.selectedExecutionConfiguration = this.defaultSettingStore.getExecutionConfiguration();
        this.runConfigs = RunConfigurationCollector.getInstance().getAllBuiltinRunConfigurationContributors();
        if (this.runConfigs.length > 0) {
            List<String> runConfigIds = Arrays.stream(this.runConfigs).map(config -> config.getId()).filter(id -> !id.equalsIgnoreCase(GlobalStringConstants.TESTCLOUD_NAME)).collect(Collectors.toList());
            int selectedIndex = Math.max(runConfigIds.indexOf(this.selectedExecutionConfiguration), 0);
            String[] runConfigIdList = runConfigIds.toArray(new String[0]);
            this.cbDefaultBrowser.setItems(runConfigIdList);
            this.cbDefaultBrowser.select(selectedIndex);
        }
        Boolean selectedLogTestSteps = this.defaultSettingStore.getLogTestSteps();
        this.cbLogTestSteps.setItems(new String[]{GlobalStringConstants.ENABLED, GlobalStringConstants.DISABLED});
        this.cbLogTestSteps.select(selectedLogTestSteps != false ? 0 : 1);
        if (!this.featureService.canUse(KSEFeature.CONSOLE_LOG_CUSTOMIZATION)) {
            this.cbLogTestSteps.select(0);
        }
        Boolean selectedHideHostName = this.defaultSettingStore.getHideHostName();
        this.cbHideHostName.setItems(new String[]{GlobalStringConstants.ENABLED, GlobalStringConstants.DISABLED});
        this.cbHideHostName.select(selectedHideHostName != false ? 0 : 1);
        if (!this.featureService.canUse(KSEFeature.CONSOLE_LOG_CUSTOMIZATION)) {
            this.cbHideHostName.select(1);
        }
        this.txtDefaultElementTimeout.setText(Integer.toString(this.defaultSettingStore.getElementTimeout()));
        this.chckOpenReport.setSelection(this.defaultSettingStore.isPostExecOpenReport());
        this.chckQuitDriversTestCase.setSelection(this.defaultSettingStore.isPostTestCaseExecQuitDriver());
        this.chckQuitDriversTestSuite.setSelection(this.defaultSettingStore.isPostTestSuiteExecQuitDriver());
        this.updateVideoSettingInputs();
    }

    private void updateVideoSettingInputs() {
        try {
            this.btnEnableScreenshot.setSelection(this.store.getScreenCaptureOption());
            VideoRecorderSetting videoSetting = this.store.getVideoRecorderSetting();
            this.btnEnableVideoRecording.setSelection(videoSetting.isEnable());
            boolean hasVideoSetting = this.store.hasVideoRecorderSetting();
            if (!hasVideoSetting && !videoSetting.isEnable()) {
                videoSetting.setUseBrowserRecorder(true);
                this.store.setVideoRecorderSetting(videoSetting);
            }
            boolean isUseBrowserRecorder = videoSetting.isUseBrowserRecorder();
            this.btnBrowserRecorder.setSelection(isUseBrowserRecorder);
            this.btnScreenRecorder.setSelection(!isUseBrowserRecorder);
            this.btnRecordAllTestCases.setSelection(videoSetting.isRecordAllTestCases());
            this.btnRecordFailedTestCases.setSelection(!videoSetting.isRecordAllTestCases());
            this.btnRecordIfPassed.setSelection(videoSetting.isAllowedRecordIfPassed());
            this.btnRecordIfFailed.setSelection(videoSetting.isAllowedRecordIfFailed());
            this.cbbVideoFormat.select(videoSetting.getVideoFormat().ordinal());
            this.cbbVideoQuality.select(videoSetting.getVideoQuality().ordinal());
            this.updateControlState();
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e);
            MultiStatusErrorDialog.showErrorDialog((Throwable)e, (String)ComposerExecutionMessageConstants.PAGE_ERROR_MSG_UNABLE_TO_READ_SETTINGS, (String)e.getMessage());
        }
    }

    private void updateControlState() {
        boolean isEnableVideoRecording = this.btnEnableVideoRecording.getSelection();
        ControlUtils.recursiveSetEnabled((Control)this.videoRecordingSettings, (boolean)isEnableVideoRecording);
        boolean isBrowserRecorder = this.btnBrowserRecorder.getSelection();
        ControlUtils.recursiveSetEnabled((Control)this.browserRecorderSettings, (isEnableVideoRecording && isBrowserRecorder ? 1 : 0) != 0);
        ControlUtils.recursiveSetEnabled((Control)this.screenRecorderSettings, (isEnableVideoRecording && !isBrowserRecorder ? 1 : 0) != 0);
    }

    @Override
    protected void performDefaults() {
        String selectedExecutionConfiguration = ExecutionDefaultSettingStore.getStore().getDefaultExecutionConfiguration();
        this.runConfigs = RunConfigurationCollector.getInstance().getAllBuiltinRunConfigurationContributors();
        if (this.runConfigs.length > 0) {
            List<String> runConfigIds = Arrays.stream(this.runConfigs).map(config -> config.getId()).filter(id -> !id.equalsIgnoreCase(GlobalStringConstants.TESTCLOUD_NAME)).collect(Collectors.toList());
            int selectedIndex = Math.max(runConfigIds.indexOf(selectedExecutionConfiguration), 0);
            String[] runConfigIdList = runConfigIds.toArray(new String[0]);
            this.cbDefaultBrowser.setItems(runConfigIdList);
            this.cbDefaultBrowser.select(selectedIndex);
        }
        this.cbLogTestSteps.select(0);
        this.cbHideHostName.select(1);
        this.txtDefaultElementTimeout.setText(Integer.toString(30));
        this.chckOpenReport.setSelection(false);
        this.chckQuitDriversTestCase.setSelection(false);
        this.chckQuitDriversTestSuite.setSelection(true);
        this.updateVideoSettingInputs();
        super.performApply();
    }

    @Override
    protected boolean saveSettings() {
        if (this.container == null || this.container.isDisposed()) {
            return true;
        }
        try {
            if (this.runConfigs != null && this.runConfigs.length > 0 && !StringUtils.equals((CharSequence)this.cbDefaultBrowser.getText(), (CharSequence)this.selectedExecutionConfiguration)) {
                this.selectedExecutionConfiguration = this.cbDefaultBrowser.getText();
                this.defaultSettingStore.setExecutionConfiguration(this.selectedExecutionConfiguration);
            }
            this.defaultSettingStore.setLogTestSteps(this.cbLogTestSteps.getSelectionIndex() == 0 ? Boolean.valueOf(true) : Boolean.valueOf(false));
            this.defaultSettingStore.setHideHostName(this.cbHideHostName.getSelectionIndex() == 0 ? Boolean.valueOf(true) : Boolean.valueOf(false));
            this.defaultSettingStore.setElementTimeout(Integer.parseInt(this.txtDefaultElementTimeout.getText()));
            this.defaultSettingStore.setPostExecOpenReport(this.chckOpenReport.getSelection());
            this.defaultSettingStore.setPostTestCaseExecQuitDriver(this.chckQuitDriversTestCase.getSelection());
            this.defaultSettingStore.setPostTestSuiteExecQuitDriver(this.chckQuitDriversTestSuite.getSelection());
            this.store.setScreenCaptureOption(this.btnEnableScreenshot.getSelection());
            VideoRecorderSetting videoSetting = new VideoRecorderSetting();
            videoSetting.setEnable(this.btnEnableVideoRecording.getSelection());
            videoSetting.setAllowedRecordIfPassed(this.btnRecordIfPassed.getSelection());
            videoSetting.setAllowedRecordIfFailed(this.btnRecordIfFailed.getSelection());
            videoSetting.setVideoFormat(VideoFileFormat.values()[this.cbbVideoFormat.getSelectionIndex()]);
            videoSetting.setVideoQuality(VideoQuality.values()[this.cbbVideoQuality.getSelectionIndex()]);
            videoSetting.setRecordAllTestCases(this.btnRecordAllTestCases.getSelection());
            videoSetting.setUseBrowserRecorder(this.btnBrowserRecorder.getSelection());
            this.store.setVideoRecorderSetting(videoSetting);
        }
        catch (IOException error) {
            LoggerSingleton.logError((Throwable)error);
            MultiStatusErrorDialog.showErrorDialog((Throwable)error, (String)ComposerExecutionMessageConstants.PAGE_ERROR_MSG_UNABLE_TO_UPDATE_SETTINGS, (String)error.getMessage());
            return false;
        }
        return true;
    }
}

