/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.execution.settings;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.execution.constants.ComposerExecutionMessageConstants;
import com.kms.katalon.composer.execution.settings.AbstractExecutionSettingPage;
import com.kms.katalon.execution.constants.ExecutionMessageConstants;
import com.kms.katalon.execution.setting.ExecutionDefaultSettingStore;
import com.kms.katalon.execution.webui.setting.WebUiExecutionSettingStore;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class WebUIExecutionSettingPage
extends AbstractExecutionSettingPage {
    private static final String LBL_APPLY_NEIGHBOR_XPATHS = ExecutionMessageConstants.LBL_APPLY_NEIGHBOR_XPATHS;
    private WebUiExecutionSettingStore webUISettingStore;
    private ExecutionDefaultSettingStore defaultSettingStore = ExecutionDefaultSettingStore.getStore();
    private Combo cbDefaultSmartWait;
    private Combo cbDefaultTimeCapsule;
    private Text txtDefaultPageLoadTimeout;
    private Text txtActionDelayInSecond;
    private Text txtActionDelayInMilisecond;
    private Text txtDefaultIEHangTimeout;
    private Button radioNotUsePageLoadTimeout;
    private Button radioUsePageLoadTimeout;
    private Button chckIgnorePageLoadTimeoutException;
    private Button radioDelayBetweenActionsInSecond;
    private Button radioDelayBetweenActionsInMilisecond;

    public WebUIExecutionSettingPage() {
        this.webUISettingStore = WebUiExecutionSettingStore.getStore();
    }

    @Override
    protected Composite createSettingsArea(Composite container) {
        this.createWebUISettingsComposite(container);
        return container;
    }

    private Composite createWebUISettingsComposite(Composite parent) {
        Composite settingsComposite = new Composite(parent, 0);
        GridLayout glContainer = new GridLayout(2, false);
        glContainer.verticalSpacing = 10;
        glContainer.marginHeight = 0;
        glContainer.marginWidth = 0;
        settingsComposite.setLayout((Layout)glContainer);
        Label lblDefaultSmartWait = new Label(settingsComposite, 0);
        lblDefaultSmartWait.setText(ComposerExecutionMessageConstants.PREF_WEBUI_LBL_DEFAULT_SMART_WAIT);
        GridData gdLblDefaultSmartWait = new GridData(16384, 0x1000000, false, false, 1, 1);
        lblDefaultSmartWait.setLayoutData((Object)gdLblDefaultSmartWait);
        this.cbDefaultSmartWait = new Combo(settingsComposite, 2060);
        GridData gdCbDefaultSmartWait = new GridData(16384, 0x1000000, false, false, 1, 1);
        gdCbDefaultSmartWait.widthHint = 120;
        this.cbDefaultSmartWait.setLayoutData((Object)gdCbDefaultSmartWait);
        Label lblDefaultTimeCapsule = new Label(settingsComposite, 0);
        lblDefaultTimeCapsule.setText(ComposerExecutionMessageConstants.PREF_WEBUI_LBL_DEFAULT_TIME_CAPSULE);
        GridData gdLblDefaultTimeCapsule = new GridData(16384, 0x1000000, false, false, 1, 1);
        lblDefaultTimeCapsule.setLayoutData((Object)gdLblDefaultTimeCapsule);
        this.cbDefaultTimeCapsule = new Combo(settingsComposite, 2060);
        GridData gdCbDefaultTimeCapsule = new GridData(16384, 0x1000000, false, false, 1, 1);
        gdCbDefaultTimeCapsule.widthHint = 120;
        this.cbDefaultTimeCapsule.setLayoutData((Object)gdCbDefaultTimeCapsule);
        this.buildDefaultIEHangTimeoutComposite(settingsComposite);
        this.buildDefaultPageLoadTimeoutComposite(settingsComposite);
        this.buildDelayBetweenActionsComposite(settingsComposite);
        return settingsComposite;
    }

    private void buildDefaultIEHangTimeoutComposite(Composite parent) {
        Label lblDefaultIEHangTimeout = new Label(parent, 0);
        lblDefaultIEHangTimeout.setText(ComposerExecutionMessageConstants.PREF_LBL_DEFAULT_WAIT_FOR_IE_HANGING_TIMEOUT);
        lblDefaultIEHangTimeout.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.txtDefaultIEHangTimeout = new Text(parent, 2048);
        GridData gdTxtDefaultIEHangTimeout = new GridData(16384, 0x1000000, false, false, 1, 1);
        gdTxtDefaultIEHangTimeout.widthHint = 60;
        this.txtDefaultIEHangTimeout.setLayoutData((Object)gdTxtDefaultIEHangTimeout);
    }

    private void buildDelayBetweenActionsComposite(Composite parent) {
        Label lblActionDelay = new Label(parent, 0);
        lblActionDelay.setText(ComposerExecutionMessageConstants.LBL_ACTION_DELAY);
        GridData gdLblActionDelay = new GridData(16384, 0x1000000, true, false, 2, 1);
        lblActionDelay.setLayoutData((Object)gdLblActionDelay);
        Composite compPageLoad = new Composite(parent, 0);
        GridLayout glCompPageLoad = new GridLayout(2, false);
        glCompPageLoad.marginWidth = 0;
        glCompPageLoad.marginHeight = 0;
        glCompPageLoad.marginLeft = 15;
        compPageLoad.setLayout((Layout)glCompPageLoad);
        compPageLoad.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.radioDelayBetweenActionsInSecond = new Button(compPageLoad, 16);
        this.radioDelayBetweenActionsInSecond.setText(ComposerExecutionMessageConstants.PREF_LBL_ACTION_DELAY_IN_SECONDS);
        this.radioDelayBetweenActionsInSecond.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.txtActionDelayInSecond = new Text(compPageLoad, 2048);
        GridData ldActionDelayInSecond = new GridData(16384, 0x1000000, true, false, 1, 1);
        ldActionDelayInSecond.widthHint = 60;
        this.txtActionDelayInSecond.setLayoutData((Object)ldActionDelayInSecond);
        this.radioDelayBetweenActionsInMilisecond = new Button(compPageLoad, 16);
        this.radioDelayBetweenActionsInMilisecond.setText(ComposerExecutionMessageConstants.PREF_LBL_ACTION_DELAY_IN_MILISECONDS);
        this.radioDelayBetweenActionsInMilisecond.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.txtActionDelayInMilisecond = new Text(compPageLoad, 2048);
        GridData ldActionDelayInMiliisecond = new GridData(16384, 0x1000000, true, false, 1, 1);
        ldActionDelayInMiliisecond.widthHint = 60;
        this.txtActionDelayInMilisecond.setLayoutData((Object)ldActionDelayInMiliisecond);
    }

    private void buildDefaultPageLoadTimeoutComposite(Composite parent) {
        Label lblDefaultPageLoadTimeout = new Label(parent, 0);
        lblDefaultPageLoadTimeout.setText(ComposerExecutionMessageConstants.PREF_LBL_DEFAULT_PAGE_LOAD_TIMEOUT);
        lblDefaultPageLoadTimeout.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Composite compPageLoad = new Composite(parent, 0);
        GridLayout glCompPageLoad = new GridLayout(2, false);
        glCompPageLoad.marginWidth = 0;
        glCompPageLoad.marginHeight = 0;
        glCompPageLoad.marginLeft = 15;
        compPageLoad.setLayout((Layout)glCompPageLoad);
        compPageLoad.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.radioNotUsePageLoadTimeout = new Button(compPageLoad, 16);
        this.radioNotUsePageLoadTimeout.setText(ComposerExecutionMessageConstants.PREF_LBL_ENABLE_DEFAULT_PAGE_LOAD_TIMEOUT);
        this.radioNotUsePageLoadTimeout.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.radioUsePageLoadTimeout = new Button(compPageLoad, 16);
        this.radioUsePageLoadTimeout.setText(ComposerExecutionMessageConstants.PREF_LBL_CUSTOM_PAGE_LOAD_TIMEOUT);
        GridData gdRadioPageLoadTimeout = new GridData(16384, 0x1000000, false, false, 1, 1);
        this.radioUsePageLoadTimeout.setLayoutData((Object)gdRadioPageLoadTimeout);
        this.txtDefaultPageLoadTimeout = new Text(compPageLoad, 2048);
        GridData gdDefaultPageLoadTimeout = new GridData(16384, 0x1000000, true, false, 1, 1);
        gdDefaultPageLoadTimeout.widthHint = 60;
        this.txtDefaultPageLoadTimeout.setLayoutData((Object)gdDefaultPageLoadTimeout);
        new Label(compPageLoad, 0);
        this.chckIgnorePageLoadTimeoutException = new Button(compPageLoad, 32);
        this.chckIgnorePageLoadTimeoutException.setText(ComposerExecutionMessageConstants.PREF_LBL_IGNORE_DEFAULT_PAGE_LOAD_TIMEOUT_EXCEPTION);
        this.chckIgnorePageLoadTimeoutException.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
    }

    @Override
    protected void registerListeners() {
        this.radioUsePageLoadTimeout.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean usePageLoadTimeout = WebUIExecutionSettingPage.this.radioUsePageLoadTimeout.getSelection();
                WebUIExecutionSettingPage.this.txtDefaultPageLoadTimeout.setEnabled(usePageLoadTimeout);
                WebUIExecutionSettingPage.this.chckIgnorePageLoadTimeoutException.setEnabled(usePageLoadTimeout);
            }
        });
        this.radioDelayBetweenActionsInMilisecond.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WebUIExecutionSettingPage.this.txtActionDelayInMilisecond.setEnabled(true);
                WebUIExecutionSettingPage.this.txtActionDelayInSecond.setEnabled(false);
            }
        });
        this.radioDelayBetweenActionsInSecond.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WebUIExecutionSettingPage.this.txtActionDelayInSecond.setEnabled(true);
                WebUIExecutionSettingPage.this.txtActionDelayInMilisecond.setEnabled(false);
            }
        });
        this.addNumberVerification(this.txtActionDelayInSecond, 0, 9999);
        this.addNumberVerification(this.txtActionDelayInMilisecond, 0, 9999999);
        this.addNumberVerification(this.txtDefaultIEHangTimeout, 0, 9999);
        this.addNumberVerification(this.txtDefaultPageLoadTimeout, 0, 9999);
    }

    @Override
    protected void initialize() throws IOException {
        Boolean selectedSmartWaitMode = this.defaultSettingStore.getDefaultSmartWaitMode();
        Boolean selectedTimeCapsuleMode = this.webUISettingStore.getTimeCapsuleEnabled();
        this.cbDefaultSmartWait.setItems(ENABLE_DISABLE_ITEMS);
        this.cbDefaultTimeCapsule.setItems(ENABLE_DISABLE_ITEMS);
        this.cbDefaultSmartWait.select(selectedSmartWaitMode != false ? 0 : 1);
        this.cbDefaultTimeCapsule.select(selectedTimeCapsuleMode != false ? 0 : 1);
        Boolean usePageLoadTimeout = this.webUISettingStore.getEnablePageLoadTimeout();
        this.radioUsePageLoadTimeout.setSelection(usePageLoadTimeout.booleanValue());
        this.radioNotUsePageLoadTimeout.setSelection(usePageLoadTimeout == false);
        this.txtDefaultPageLoadTimeout.setText(String.valueOf(this.webUISettingStore.getPageLoadTimeout()));
        this.txtDefaultPageLoadTimeout.setEnabled(usePageLoadTimeout.booleanValue());
        this.chckIgnorePageLoadTimeoutException.setSelection(this.webUISettingStore.getIgnorePageLoadTimeout());
        this.chckIgnorePageLoadTimeoutException.setEnabled(usePageLoadTimeout.booleanValue());
        this.radioDelayBetweenActionsInSecond.setSelection(this.webUISettingStore.getUseDelayActionTimeUnit().equals((Object)TimeUnit.SECONDS));
        this.radioDelayBetweenActionsInMilisecond.setSelection(this.webUISettingStore.getUseDelayActionTimeUnit().equals((Object)TimeUnit.MILLISECONDS));
        if (this.radioDelayBetweenActionsInSecond.getSelection()) {
            this.txtActionDelayInSecond.setText(String.valueOf(this.webUISettingStore.getActionDelay()));
            this.txtActionDelayInMilisecond.setEnabled(false);
        } else {
            this.txtActionDelayInMilisecond.setText(String.valueOf(this.webUISettingStore.getActionDelay()));
            this.txtActionDelayInSecond.setEnabled(false);
        }
        this.txtActionDelayInSecond.setMessage("Ex: 1");
        this.txtActionDelayInMilisecond.setMessage("Ex: 100");
        this.txtDefaultIEHangTimeout.setText(Integer.toString(this.webUISettingStore.getIEHangTimeout()));
    }

    @Override
    protected void performDefaults() {
        if (this.container == null) {
            return;
        }
        this.cbDefaultSmartWait.setItems(ENABLE_DISABLE_ITEMS);
        this.cbDefaultSmartWait.select(0);
        this.cbDefaultTimeCapsule.setItems(ENABLE_DISABLE_ITEMS);
        this.cbDefaultTimeCapsule.select(0);
        this.radioUsePageLoadTimeout.setSelection(false);
        Boolean usePageLoadTimeout = false;
        this.radioUsePageLoadTimeout.setSelection(usePageLoadTimeout.booleanValue());
        this.radioNotUsePageLoadTimeout.setSelection(usePageLoadTimeout == false);
        this.txtDefaultPageLoadTimeout.setText(String.valueOf(30));
        this.txtDefaultPageLoadTimeout.setEnabled(usePageLoadTimeout.booleanValue());
        this.chckIgnorePageLoadTimeoutException.setSelection(false);
        this.chckIgnorePageLoadTimeoutException.setEnabled(usePageLoadTimeout.booleanValue());
        this.txtActionDelayInSecond.setText(String.valueOf(0));
        this.txtDefaultIEHangTimeout.setText(String.valueOf(600));
        this.radioDelayBetweenActionsInSecond.setSelection(true);
        this.radioDelayBetweenActionsInMilisecond.setSelection(false);
        if (this.radioDelayBetweenActionsInSecond.getSelection()) {
            this.txtActionDelayInSecond.setText(String.valueOf(0));
        } else {
            this.txtActionDelayInMilisecond.setText(String.valueOf(0));
        }
        try {
            this.webUISettingStore.setDefaultCapturedTestObjectAttributeLocators();
            this.webUISettingStore.setDefaultCapturedTestObjectXpathLocators();
            this.webUISettingStore.setDefaultCapturedTestObjectSelectorMethods();
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    @Override
    protected boolean saveSettings() {
        if (!this.isValid()) {
            return false;
        }
        try {
            if (this.cbDefaultSmartWait != null) {
                this.defaultSettingStore.setDefaultSmartWaitMode(this.cbDefaultSmartWait.getSelectionIndex() == 0 ? Boolean.valueOf(true) : Boolean.valueOf(false));
            }
            if (this.cbDefaultTimeCapsule != null) {
                this.webUISettingStore.setEnableTimeCapsule((this.cbDefaultTimeCapsule.getSelectionIndex() == 0 ? Boolean.valueOf(true) : Boolean.valueOf(false)).booleanValue());
            }
            if (this.radioUsePageLoadTimeout != null) {
                this.webUISettingStore.setEnablePageLoadTimeout(this.radioUsePageLoadTimeout.getSelection());
            }
            if (this.txtDefaultPageLoadTimeout != null) {
                this.webUISettingStore.setPageLoadTimeout(Integer.parseInt(this.txtDefaultPageLoadTimeout.getText()));
            }
            if (this.chckIgnorePageLoadTimeoutException != null) {
                this.webUISettingStore.setIgnorePageLoadTimeout(this.chckIgnorePageLoadTimeoutException.getSelection());
            }
            if (this.txtActionDelayInSecond != null) {
                TimeUnit chosenTimeUnit = null;
                String secText = this.txtActionDelayInSecond.getText();
                String milisecText = this.txtActionDelayInMilisecond.getText();
                secText = "".equals(secText) ? String.valueOf(0) : secText;
                String string = milisecText = "".equals(milisecText) ? String.valueOf(0) : milisecText;
                if (this.radioDelayBetweenActionsInSecond != null && this.radioDelayBetweenActionsInSecond.getSelection()) {
                    chosenTimeUnit = TimeUnit.SECONDS;
                }
                if (this.radioDelayBetweenActionsInMilisecond != null && this.radioDelayBetweenActionsInMilisecond.getSelection()) {
                    chosenTimeUnit = TimeUnit.MILLISECONDS;
                }
                this.webUISettingStore.setUseDelayActionTimeUnit(chosenTimeUnit);
                this.webUISettingStore.setActionDelay(Integer.parseInt(chosenTimeUnit.equals((Object)TimeUnit.SECONDS) ? secText : milisecText));
            }
            if (this.txtDefaultIEHangTimeout != null) {
                this.webUISettingStore.setIEHangTimeout(Integer.parseInt(this.txtDefaultIEHangTimeout.getText()));
            }
        }
        catch (IOException error) {
            LoggerSingleton.logError((Throwable)error);
            return false;
        }
        return true;
    }
}

